/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.fields;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.xBaseJ.DBF;
import org.xBaseJ.Util;
import org.xBaseJ.xBaseJException;

public abstract class Field
implements Cloneable,
Externalizable {
    public String Name;
    public int Length = 0;
    public byte[] buffer;
    public boolean Deleted;
    public ByteBuffer bytebuffer;
    public long myoffset;
    public static String otherValidCharacters = null;

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.Name = in.readUTF();
        this.Length = in.readInt();
        in.readFully(this.buffer);
        this.Deleted = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.Name);
        out.writeInt(this.Length);
        out.write(this.buffer);
        out.writeBoolean(this.Deleted);
    }

    public Object clone() throws CloneNotSupportedException {
        Field tField = (Field)super.clone();
        tField.Name = new String(this.Name);
        tField.Length = this.Length;
        return tField;
    }

    private void validateName(String iName) throws xBaseJException {
        if (otherValidCharacters == null) {
            try {
                otherValidCharacters = Util.getxBaseJProperty("otherValidCharactersInFieldNames");
            }
            catch (IOException e) {
                otherValidCharacters = "";
            }
            if (otherValidCharacters == null) {
                otherValidCharacters = "";
            }
        }
        if (iName == null) {
            throw new xBaseJException("Missing field name");
        }
        if (iName.length() == 0) {
            throw new xBaseJException("Missing field name");
        }
        if (iName.length() > 10) {
            throw new xBaseJException("Invalid field name " + iName);
        }
        int i = 0;
        while (i < iName.length()) {
            if (!Character.isLetter(iName.charAt(i)) && !Character.isDigit(iName.charAt(i)) && iName.charAt(i) != '_' && otherValidCharacters.indexOf(iName.charAt(i)) <= -1) {
                throw new xBaseJException("Invalid field name " + iName + ", character invalid at " + i);
            }
            ++i;
        }
    }

    public Field() {
        int tlength = this.Length == 0 ? 1 : this.Length;
        this.buffer = new byte[tlength];
        this.buffer[0] = 32;
    }

    public void setField(String iName, int iLength, ByteBuffer inbuffer) throws xBaseJException {
        this.Name = iName.trim();
        this.validateName(this.Name);
        this.Length = iLength;
        this.setBuffer(inbuffer);
    }

    public void setBuffer(ByteBuffer inBuffer) {
        this.bytebuffer = inBuffer;
        this.setBufferSpace();
    }

    public void setBufferSpace() {
        this.buffer = new byte[this.Length];
    }

    public String getName() {
        return this.Name;
    }

    public int getLength() {
        return this.Length;
    }

    public char getType() throws xBaseJException {
        throw new xBaseJException("Undefined field");
    }

    public int getDecimalPositionCount() {
        return 0;
    }

    public void read() throws IOException, xBaseJException {
        this.bytebuffer.get(this.buffer);
    }

    public String get() {
        String s;
        int k = 0;
        while (k < this.Length && this.buffer[k] != 0) {
            ++k;
        }
        if (k == 0) {
            return "";
        }
        try {
            s = new String(this.buffer, 0, k, DBF.encodedType);
        }
        catch (UnsupportedEncodingException UEE) {
            s = new String(this.buffer, 0, k);
        }
        return s;
    }

    public byte[] getBytes() {
        return this.buffer;
    }

    public void write() throws IOException, xBaseJException {
        this.bytebuffer.put(this.buffer);
    }

    public void update() throws IOException, xBaseJException {
        this.bytebuffer.put(this.buffer);
    }

    public void put(String inValue) throws xBaseJException {
        byte[] b;
        if (inValue.length() > this.Length) {
            throw new xBaseJException("Field length too long");
        }
        int i = Math.min(inValue.length(), this.Length);
        try {
            b = inValue.getBytes(DBF.encodedType);
        }
        catch (UnsupportedEncodingException UEE) {
            b = inValue.getBytes();
        }
        i = 0;
        while (i < b.length) {
            this.buffer[i] = b[i];
            ++i;
        }
        int fill = Util.fieldFilledWithSpaces() ? 32 : 0;
        i = inValue.length();
        while (i < this.Length) {
            this.buffer[i] = fill;
            ++i;
        }
    }

    public void put(byte[] inValue) throws xBaseJException {
        if (inValue.length > this.Length) {
            throw new xBaseJException("Field length too long");
        }
        int i = 0;
        while (i < inValue.length) {
            this.buffer[i] = inValue[i];
            ++i;
        }
        while (i < this.Length) {
            this.buffer[i] = Util.fieldFilledWithSpaces() ? 32 : 0;
            ++i;
        }
    }
}

