/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.indexes;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import org.xBaseJ.DBF;
import org.xBaseJ.Util;
import org.xBaseJ.indexes.MDXFile;

public class TagDescriptor {
    static final short BLOCKLENGTH = 512;
    static final short descriptorLength = 32;
    int indheaderpage;
    byte[] tagname = new byte[11];
    byte Fieldflag;
    byte forwardtag = 0;
    byte forwardtag_greater = 0;
    byte backwardtag = 0;
    byte useless = (byte)2;
    byte keytype;
    byte[] rsrvd = new byte[11];
    String name;
    RandomAccessFile nfile;
    long pos;

    public TagDescriptor(RandomAccessFile ifile, short ipos) throws IOException {
        this.nfile = ifile;
        this.pos = 512 + ipos * 32;
        this.read();
        try {
            this.name = new String(this.tagname, DBF.encodedType).trim();
        }
        catch (UnsupportedEncodingException UEE) {
            this.name = new String(this.tagname).trim();
        }
    }

    public TagDescriptor(MDXFile ifile, short ipos, String iName) throws IOException {
        byte[] tname;
        this.nfile = ifile.getRAFile();
        this.pos = 512 + ipos * 32;
        this.name = iName;
        try {
            tname = iName.getBytes(DBF.encodedType);
        }
        catch (UnsupportedEncodingException UEE) {
            tname = iName.getBytes();
        }
        int x = 0;
        while (x < tname.length) {
            this.tagname[x] = tname[x];
            ++x;
        }
        this.indheaderpage = ifile.getAnchor().get_nextavailable();
        this.keytype = (byte)32;
        if (ipos > 1) {
            this.backwardtag = (byte)(ipos - 1);
        }
        this.Fieldflag = (byte)16;
        this.write();
    }

    public void reset(RandomAccessFile ifile) {
        this.nfile = ifile;
    }

    public void setKeyType(char type) throws IOException {
        this.keytype = (byte)type;
        this.write();
    }

    public void resetPos(short ipos) {
        this.pos = 512 + ipos * 32;
    }

    void read() throws IOException {
        this.nfile.seek(this.pos);
        this.indheaderpage = this.nfile.readInt();
        this.nfile.read(this.tagname);
        try {
            this.name = new String(this.tagname, DBF.encodedType);
        }
        catch (UnsupportedEncodingException UEE) {
            this.name = new String(this.tagname);
        }
        this.Fieldflag = this.nfile.readByte();
        this.forwardtag = this.nfile.readByte();
        this.forwardtag_greater = this.nfile.readByte();
        this.backwardtag = this.nfile.readByte();
        this.useless = this.nfile.readByte();
        this.keytype = this.nfile.readByte();
        this.nfile.read(this.rsrvd);
        this.redo_numbers();
    }

    void write() throws IOException {
        this.redo_numbers();
        this.nfile.seek(this.pos);
        this.nfile.writeInt(this.indheaderpage);
        this.nfile.write(this.tagname);
        this.nfile.writeByte(this.Fieldflag);
        this.nfile.write(this.forwardtag);
        this.nfile.write(this.forwardtag_greater);
        this.nfile.write(this.backwardtag);
        this.nfile.writeByte(this.useless);
        this.nfile.writeByte(this.keytype);
        this.nfile.write(this.rsrvd);
        this.redo_numbers();
    }

    void updateForwardTag(short pos) throws IOException {
        this.forwardtag = (byte)pos;
        this.write();
    }

    void redo_numbers() {
        this.indheaderpage = Util.x86(this.indheaderpage);
    }

    public String getName() {
        return this.name;
    }
}

