/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.test;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.xBaseJ.DBF;
import org.xBaseJ.fields.CharField;
import org.xBaseJ.fields.LogicalField;
import org.xBaseJ.fields.MemoField;
import org.xBaseJ.fields.NumField;

public class TestPack
extends TestCase {
    public void setUp() {
        try {
            DBF aDB = new DBF("testfiles/class.dbf", true);
            CharField classId = new CharField("classId", 9);
            CharField className = new CharField("className", 25);
            CharField teacherId = new CharField("teacherId", 9);
            CharField daysMeet = new CharField("daysMeet", 7);
            CharField timeMeet = new CharField("timeMeet", 4);
            NumField credits = new NumField("credits", 2, 0);
            LogicalField UnderGrad = new LogicalField("UnderGrad");
            MemoField discuss = new MemoField("discuss");
            aDB.addField(classId);
            aDB.addField(className);
            aDB.addField(teacherId);
            aDB.addField(daysMeet);
            aDB.addField(timeMeet);
            aDB.addField(credits);
            aDB.addField(UnderGrad);
            aDB.addField(discuss);
            aDB.createIndex("testfiles/classId.ndx", "classId", true, true);
            aDB.createIndex("testfiles/TchrClass.ndx", "teacherID+classId", true, false);
            classId.put("JAVA10100");
            className.put("Introduction to JAVA");
            teacherId.put("120120120");
            daysMeet.put("NYNYNYN");
            timeMeet.put("0800");
            credits.put(3);
            UnderGrad.put(true);
            discuss.put("Intro class");
            aDB.write();
            classId.put("JAVA10200");
            className.put("Intermediate JAVA");
            teacherId.put("300020000");
            daysMeet.put("NYNYNYN");
            timeMeet.put("0930");
            credits.put(3);
            UnderGrad.put(true);
            discuss.put("itermediate class");
            aDB.write();
            classId.put("JAVA102D0");
            className.put("Interm");
            teacherId.put("300020000");
            daysMeet.put("ND");
            timeMeet.put("0930");
            credits.put(3);
            UnderGrad.put(true);
            discuss.put("itermediate class");
            aDB.write();
            aDB.delete();
            classId.put("JAVA501");
            className.put("JAVA And Abstract Algebra");
            teacherId.put("120120120");
            daysMeet.put("NNYNYNN");
            timeMeet.put("0930");
            credits.put(6);
            UnderGrad.put(false);
            discuss.put("weird class");
            aDB.write();
            aDB.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testPack() {
        try {
            DBF dbf = new DBF("testfiles/class.DBF");
            Assert.assertEquals((int)dbf.getRecordCount(), (int)4);
            dbf.pack();
            Assert.assertEquals((int)dbf.getRecordCount(), (int)3);
            int i = 1;
            while (i < 4) {
                dbf.gotoRecord(i);
                String bean = dbf.getField(1).get();
                if (i == 1) {
                    Assert.assertEquals((String)"JAVA10100", (String)bean);
                } else if (i == 2) {
                    Assert.assertEquals((String)"JAVA10200", (String)bean);
                } else {
                    Assert.assertEquals((String)"JAVA501", (String)bean);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public void testPackwithFPT() {
        try {
            DBF dbf = new DBF("testfiles/crw.DBF");
            int recCnt = dbf.getRecordCount();
            dbf.pack();
            Assert.assertEquals((int)dbf.getRecordCount(), (int)recCnt);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

