/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import org.apache.ibatis.parsing.PropertyParser;

public class MigrationReader
extends Reader {
    private Reader target;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MigrationReader(Reader source, boolean undo, Properties variables) throws IOException {
        try {
            String line;
            BufferedReader reader = new BufferedReader(source);
            StringBuilder doBuilder = new StringBuilder();
            StringBuilder undoBuilder = new StringBuilder();
            StringBuilder currentBuilder = doBuilder;
            while ((line = reader.readLine()) != null) {
                if (line == null) continue;
                if (line.trim().startsWith("--//")) {
                    if (line.contains("@UNDO")) {
                        currentBuilder = undoBuilder;
                    }
                    line = line.replace("--//", "-- ");
                }
                currentBuilder.append(line);
                currentBuilder.append("\n");
            }
            this.target = undo ? new StringReader(PropertyParser.parse(undoBuilder.toString(), variables)) : new StringReader(PropertyParser.parse(doBuilder.toString(), variables));
        }
        finally {
            source.close();
        }
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.target.read(cbuf, off, len);
    }

    public void close() throws IOException {
        this.target.close();
    }
}

