/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.creator.gui.panelManager;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import rs.pezar.creator.gui.panelManager.PanelManager;
import rs.pezar.creator.gui.panelManager.PzPanelInterface;

public abstract class PzManagedFrame
extends JFrame {
    private JPanel pnlButtons;
    private JButton btnIzlaz;
    private JLabel jLabel1;
    private JButton btnKraj;
    private JPanel pnlHeader;
    private JPanel pnlPages;
    private JButton btnDalje;
    private JButton btnNazad;
    private Vector<JPanel> panels;
    private ActionListener actListener;
    PanelManager panelManager;
    String img;
    String title;
    private JSeparator separator;

    public PzManagedFrame(String image, String title) {
        this.img = image;
        this.title = title;
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PzManagedFrame(Vector<JPanel> panelVector, String image, String title) {
        this.title = title;
        this.panels = panelVector;
        this.img = image;
    }

    public void showMenu() {
        this.initGUI();
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
    }

    private ActionListener getActionListener() {
        if (this.actListener == null) {
            this.actListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        String actionCommand = ((JButton)e.getSource()).getActionCommand();
                        if (actionCommand == "dalje") {
                            PzManagedFrame.this.OnDaljePressed();
                        } else if (actionCommand == "nazad") {
                            PzManagedFrame.this.OnNazadPressed();
                        } else if (actionCommand == "izlaz") {
                            PzManagedFrame.this.OnIzlazPressed();
                        } else if (actionCommand == "kraj") {
                            PzManagedFrame.this.OnKrajPressed();
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            };
        }
        return this.actListener;
    }

    private void initGUI() {
        try {
            this.setTitle(this.title);
            this.getContentPane().setLayout(new BorderLayout(0, 0));
            this.jLabel1 = new JLabel();
            this.jLabel1.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(this.img)));
            this.jLabel1.setBounds(0, 0, 601, 103);
            JPanel panel = new JPanel();
            this.getContentPane().add(panel);
            GridBagLayout gbl_panel = new GridBagLayout();
            int[] nArray = new int[4];
            nArray[0] = 10;
            nArray[1] = 604;
            nArray[2] = 10;
            gbl_panel.columnWidths = nArray;
            int[] nArray2 = new int[5];
            nArray2[0] = 103;
            nArray2[1] = 400;
            nArray2[3] = 48;
            gbl_panel.rowHeights = nArray2;
            gbl_panel.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
            gbl_panel.rowWeights = new double[]{0.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
            panel.setLayout(gbl_panel);
            this.pnlHeader = new JPanel();
            this.pnlHeader.setBackground(Color.BLACK);
            this.pnlHeader.setForeground(Color.BLACK);
            GridBagConstraints gbc_pnlHeader = new GridBagConstraints();
            gbc_pnlHeader.gridwidth = 3;
            gbc_pnlHeader.fill = 1;
            gbc_pnlHeader.gridx = 0;
            gbc_pnlHeader.gridy = 0;
            panel.add((Component)this.pnlHeader, gbc_pnlHeader);
            this.pnlHeader.setLayout(null);
            this.pnlHeader.add(this.jLabel1);
            this.pnlPages = new JPanel();
            GridBagConstraints gbc_pnlPages = new GridBagConstraints();
            gbc_pnlPages.fill = 1;
            gbc_pnlPages.insets = new Insets(5, 5, 5, 5);
            gbc_pnlPages.gridx = 1;
            gbc_pnlPages.gridy = 1;
            panel.add((Component)this.pnlPages, gbc_pnlPages);
            this.pnlPages.setLayout(new BorderLayout(0, 0));
            this.separator = new JSeparator();
            GridBagConstraints gbc_separator = new GridBagConstraints();
            gbc_separator.fill = 2;
            gbc_separator.insets = new Insets(0, 0, 5, 5);
            gbc_separator.gridx = 1;
            gbc_separator.gridy = 2;
            panel.add((Component)this.separator, gbc_separator);
            this.pnlButtons = new JPanel();
            GridBagConstraints gbc_pnlButtons = new GridBagConstraints();
            gbc_pnlButtons.gridwidth = 3;
            gbc_pnlButtons.anchor = 13;
            gbc_pnlButtons.fill = 3;
            gbc_pnlButtons.insets = new Insets(0, 0, 0, 5);
            gbc_pnlButtons.gridx = 0;
            gbc_pnlButtons.gridy = 3;
            panel.add((Component)this.pnlButtons, gbc_pnlButtons);
            GridBagLayout pnlButtonsLayout = new GridBagLayout();
            this.pnlButtons.setLayout(pnlButtonsLayout);
            this.pnlButtons.setPreferredSize(new Dimension(596, 40));
            pnlButtonsLayout.rowWeights = new double[]{0.1};
            pnlButtonsLayout.rowHeights = new int[]{7};
            pnlButtonsLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
            pnlButtonsLayout.columnWidths = new int[]{310, 89, 89, 89, 5};
            this.btnIzlaz = new JButton();
            this.pnlButtons.add((Component)this.btnIzlaz, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.btnIzlaz.setText("Izlaz");
            this.btnIzlaz.setSize(70, 22);
            this.btnIzlaz.setPreferredSize(new Dimension(70, 22));
            this.btnIzlaz.setActionCommand("izlaz");
            this.btnIzlaz.addActionListener(this.getActionListener());
            this.btnNazad = new JButton();
            this.pnlButtons.add((Component)this.btnNazad, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.btnNazad.setText("Nazad");
            this.btnNazad.setSize(70, 22);
            this.btnNazad.setPreferredSize(new Dimension(70, 22));
            this.btnNazad.setActionCommand("nazad");
            this.btnNazad.addActionListener(this.getActionListener());
            this.btnDalje = new JButton();
            this.pnlButtons.add((Component)this.btnDalje, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.btnDalje.setText("Dalje");
            this.btnDalje.setSize(70, 22);
            this.btnDalje.setPreferredSize(new Dimension(70, 22));
            this.btnDalje.setActionCommand("dalje");
            this.btnDalje.addActionListener(this.getActionListener());
            this.btnKraj = new JButton();
            this.pnlButtons.add((Component)this.btnKraj, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.btnKraj.setText("Kraj");
            this.btnKraj.setSize(70, 22);
            this.btnKraj.setPreferredSize(new Dimension(70, 22));
            this.btnKraj.setActionCommand("kraj");
            this.btnKraj.addActionListener(this.getActionListener());
            this.panelManager = new PanelManager(this.panels, this.pnlPages, this.btnNazad, this.btnDalje, this.btnKraj);
            this.getRootPane().setDefaultButton(this.btnDalje);
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void OnIzlazPressed() {
        this.dispose();
    }

    private void OnNazadPressed() {
        this.panelManager.Back();
    }

    private void OnDaljePressed() {
        this.panelManager.Next();
    }

    public abstract void OnKrajPressed();

    public void addPanel(JPanel panel) {
        if (this.panels == null) {
            this.panels = new Vector();
        }
        this.panels.add(panel);
    }

    public void setPanels(Vector<JPanel> panelVector) {
        panelVector = this.panels;
    }

    public Vector<JPanel> getPanels() {
        return this.panels;
    }

    public void removePanel(JPanel panel) {
        if (this.panels == null) {
            return;
        }
        int i = 0;
        while (i < this.panels.size()) {
            if (this.panels.get(i).equals(panel)) {
                this.panels.remove(i);
                return;
            }
            ++i;
        }
    }

    public JPanel getPanel(Byte type, String id) {
        if (this.panels == null) {
            return null;
        }
        int i = 0;
        while (i < this.panels.size()) {
            if (((PzPanelInterface)((Object)this.panels.get(i))).getIdentifier().equals(id) && ((PzPanelInterface)((Object)this.panels.get(i))).getPanelType().equals(type)) {
                return this.panels.get(i);
            }
            ++i;
        }
        return null;
    }

    public JPanel getPanel(String id) {
        if (this.panels == null) {
            return null;
        }
        int i = 0;
        while (i < this.panels.size()) {
            if (((PzPanelInterface)((Object)this.panels.get(i))).getIdentifier().equals(id)) {
                return this.panels.get(i);
            }
            ++i;
        }
        return null;
    }

    public JPanel getPanel(int listIndex) {
        if (this.panels == null) {
            return null;
        }
        if (this.panels.size() < listIndex || listIndex < 0) {
            return null;
        }
        return this.panels.get(listIndex);
    }

    public void hideEndButton(boolean hide) {
        this.btnKraj.setEnabled(!hide);
    }

    public void restart() {
        for (PzPanelInterface pzPanelInterface : this.panels) {
            pzPanelInterface.reset();
        }
        this.panelManager.goToBeginning();
    }
}

