/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.test;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.xBaseJ.DBF;
import org.xBaseJ.Util;
import org.xBaseJ.fields.CharField;
import org.xBaseJ.fields.Field;
import org.xBaseJ.fields.NumField;

public class TestConcurrInsert
extends TestCase {
    public void testConncur() {
        try {
            Util.setxBaseJProperty("useSharedLocks", "false");
            DBF writer = new DBF("testfiles/concurr.dbf", true);
            CharField str_field = new CharField("thread", 15);
            NumField int_field = new NumField("rownum", 5, 0);
            writer.addField(str_field);
            writer.addField(int_field);
            str_field.put("main thread");
            ((Field)int_field).put("-1");
            writer.write();
            writer.close();
            ConcurrInsert thread1 = new ConcurrInsert(1);
            ConcurrInsert thread2 = new ConcurrInsert(2);
            thread1.start();
            thread2.start();
            while (thread1.isAlive() || thread2.isAlive()) {
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
        try {
            DBF reader = new DBF("testfiles/concurr.dbf");
            Assert.assertEquals((int)reader.getRecordCount(), (int)99);
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    private class ConcurrInsert
    extends Thread {
        private int threadIndex = -1;
        private DBF writer = new DBF("testfiles/concurr.dbf");

        public ConcurrInsert(int threadIndex) throws Exception {
            this.threadIndex = threadIndex;
        }

        public void run() {
            try {
                Field str_field = this.writer.getField(1);
                Field int_field = this.writer.getField(2);
                int i = 0;
                while (i < 49) {
                    int_field.put(String.valueOf(i));
                    str_field.put("Thread" + this.threadIndex);
                    int_field.put("" + i);
                    this.writer.write(true);
                    Thread.sleep(10 * this.threadIndex);
                    System.out.println("Thread " + this.threadIndex + " has inserted " + i + " row");
                    ++i;
                }
                this.writer.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

