/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.creator.tools.cleanups;

import java.io.IOException;
import org.javaldap.btree.BTree;
import org.xBaseJ.DBF;
import org.xBaseJ.fields.Field;
import org.xBaseJ.xBaseJException;
import rs.pezar.creator.tools.cleanups.CleanUp;
import rs.pezar.creator.tools.cleanups.Util;
import rs.pezar.creator.tools.migration.progress.MigrationMonitor;

public class ArtikalCleanUp
implements CleanUp {
    @Override
    public void clean(String dirPath, String yy, MigrationMonitor monitor) throws xBaseJException, IOException {
        BTree modelKeyz = Util.loadKeys(String.valueOf(dirPath) + "MODELI.dbf", "TIP_VOZILA");
        BTree rgrKeyz = Util.loadKeys(String.valueOf(dirPath) + "RGRUPA.dbf", "RGR_RGRUP");
        BTree komKeyz = Util.loadKeys(String.valueOf(dirPath) + String.format("KUPCI%s.dbf", yy), "KUP_SIF");
        DBF artikli = new DBF(String.valueOf(dirPath) + String.format("DEO%s.dbf", yy));
        Field oznModelA = artikli.getField("DEO_OMOD");
        Field oznRgr = artikli.getField("DEO_RGRUP");
        Field oznPr = artikli.getField("DEO_PROIZV");
        Field oznDob = artikli.getField("DEO_DOBAV");
        int ac = 0;
        while (ac < artikli.getRecordCount()) {
            artikli.read();
            boolean updated = false;
            if (!artikli.deleted()) {
                if (!modelKeyz.containsKey(oznModelA.get().trim())) {
                    oznModelA.put("");
                    updated = true;
                }
                if (!rgrKeyz.containsKey(oznRgr.get().trim())) {
                    oznRgr.put(this.fixRgr(oznRgr.get().trim(), rgrKeyz));
                    updated = true;
                }
                if (!komKeyz.containsKey(oznDob.get().trim())) {
                    oznDob.put("");
                    updated = true;
                }
                if (!komKeyz.containsKey(oznPr.get().trim())) {
                    oznPr.put("");
                    updated = true;
                }
                if (updated) {
                    artikli.update();
                }
            }
            monitor.setProgress(ac);
            ++ac;
        }
        artikli.close();
    }

    private String fixRgr(String arg, BTree rgrKeyz) {
        String firstKey = null;
        if (rgrKeyz.keys() != null && rgrKeyz.keys().hasMoreElements()) {
            firstKey = (String)rgrKeyz.values().nextElement();
        }
        return firstKey;
    }
}

