/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.builder.xml.dynamic;

import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.ognl.OgnlException;
import org.apache.ibatis.ognl.OgnlRuntime;
import org.apache.ibatis.ognl.PropertyAccessor;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicContext {
    public static final String PARAMETER_OBJECT_KEY = "_parameter";
    private final ContextMap bindings = new ContextMap();
    private final StringBuilder sqlBuilder = new StringBuilder();
    private int uniqueNumber = 0;

    public DynamicContext(Configuration configuration, Object parameterObject) {
        if (parameterObject != null && !(parameterObject instanceof Map)) {
            String[] names;
            MetaObject metaObject = configuration.newMetaObject(parameterObject);
            for (String name : names = metaObject.getGetterNames()) {
                this.bindings.put(name, metaObject.getValue(name));
            }
        }
        this.bindings.put(PARAMETER_OBJECT_KEY, parameterObject);
    }

    public Map<String, Object> getBindings() {
        return this.bindings;
    }

    public void bind(String name, Object value) {
        this.bindings.put(name, value);
    }

    public void appendSql(String sql) {
        this.sqlBuilder.append(sql);
        this.sqlBuilder.append(" ");
    }

    public String getSql() {
        return this.sqlBuilder.toString().trim();
    }

    public int getUniqueNumber() {
        return this.uniqueNumber++;
    }

    static {
        OgnlRuntime.setPropertyAccessor(ContextMap.class, new ContextAccessor());
    }

    static class ContextAccessor
    implements PropertyAccessor {
        ContextAccessor() {
        }

        public Object getProperty(Map context, Object target, Object name) throws OgnlException {
            Map map = (Map)target;
            Object result = map.get(name);
            if (result != null) {
                return result;
            }
            Object parameterObject = map.get(DynamicContext.PARAMETER_OBJECT_KEY);
            if (parameterObject instanceof Map) {
                return ((Map)parameterObject).get(name);
            }
            return null;
        }

        public void setProperty(Map context, Object target, Object name, Object value) throws OgnlException {
            Map map = (Map)target;
            map.put(name, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ContextMap
    extends HashMap<String, Object> {
        ContextMap() {
        }
    }
}

