/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor;

import java.lang.reflect.Array;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.cache.impl.PerpetualCache;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.executor.ExecutionPlaceholder;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.transaction.Transaction;
import org.apache.ibatis.type.TypeHandlerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseExecutor
implements Executor {
    protected Transaction transaction;
    protected List<DeferredLoad> deferredLoads;
    protected PerpetualCache localCache;
    protected Configuration configuration;
    protected int queryStack = 0;
    protected List<BatchResult> batchResults = new ArrayList<BatchResult>();
    private boolean closed;

    protected BaseExecutor(Configuration configuration, Transaction transaction) {
        this.transaction = transaction;
        this.deferredLoads = new ArrayList<DeferredLoad>();
        this.localCache = new PerpetualCache("LocalCache");
        this.closed = false;
        this.configuration = configuration;
    }

    @Override
    public Transaction getTransaction() {
        if (this.closed) {
            throw new ExecutorException("Executor was closed.");
        }
        return this.transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.transaction != null) {
                this.transaction.close();
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.transaction = null;
            this.deferredLoads = null;
            this.localCache = null;
            this.batchResults = null;
            this.closed = true;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public int update(MappedStatement ms, Object parameter) throws SQLException {
        ErrorContext.instance().resource(ms.getResource()).activity("executing an update").object(ms.getId());
        if (this.closed) {
            throw new ExecutorException("Executor was closed.");
        }
        this.clearLocalCache();
        return this.doUpdate(ms, parameter);
    }

    public List flushStatements() throws SQLException {
        if (this.closed) {
            throw new ExecutorException("Executor was closed.");
        }
        this.batchResults.addAll(this.doFlushStatements());
        return this.batchResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List query(MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler) throws SQLException {
        List list;
        block10: {
            ErrorContext.instance().resource(ms.getResource()).activity("executing a query").object(ms.getId());
            if (this.closed) {
                throw new ExecutorException("Executor was closed.");
            }
            try {
                ++this.queryStack;
                CacheKey key = this.createCacheKey(ms, parameter, rowBounds);
                List cachedList = (List)this.localCache.getObject(key);
                if (cachedList != null) {
                    list = cachedList;
                    break block10;
                }
                this.localCache.putObject(key, (Object)ExecutionPlaceholder.EXECUTION_PLACEHOLDER);
                try {
                    list = this.doQuery(ms, parameter, rowBounds, resultHandler);
                }
                finally {
                    this.localCache.removeObject(key);
                }
                this.localCache.putObject(key, list);
            }
            finally {
                --this.queryStack;
            }
        }
        if (this.queryStack == 0) {
            for (DeferredLoad deferredLoad : this.deferredLoads) {
                deferredLoad.load();
            }
        }
        return list;
    }

    @Override
    public void deferLoad(MappedStatement ms, MetaObject resultObject, String property, CacheKey key) {
        if (this.closed) {
            throw new ExecutorException("Executor was closed.");
        }
        this.deferredLoads.add(new DeferredLoad(ms, resultObject, property, key));
    }

    @Override
    public CacheKey createCacheKey(MappedStatement ms, Object parameterObject, RowBounds rowBounds) {
        if (this.closed) {
            throw new ExecutorException("Executor was closed.");
        }
        BoundSql boundSql = ms.getBoundSql(parameterObject);
        CacheKey cacheKey = new CacheKey();
        cacheKey.update(ms.getId());
        cacheKey.update(rowBounds.getOffset());
        cacheKey.update(rowBounds.getLimit());
        cacheKey.update(boundSql.getSql());
        List<ParameterMapping> parameterMappings = boundSql.getParameterMappings();
        if (parameterMappings.size() > 0 && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = ms.getConfiguration().getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                cacheKey.update(parameterObject);
            } else {
                MetaObject metaObject = this.configuration.newMetaObject(parameterObject);
                for (ParameterMapping parameterMapping : parameterMappings) {
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter(propertyName)) {
                        cacheKey.update(metaObject.getValue(propertyName));
                        continue;
                    }
                    if (!boundSql.hasAdditionalParameter(propertyName)) continue;
                    cacheKey.update(boundSql.getAdditionalParameter(propertyName));
                }
            }
        }
        return cacheKey;
    }

    @Override
    public boolean isCached(MappedStatement ms, CacheKey key) {
        return this.localCache.getObject(key) != null;
    }

    @Override
    public void commit(boolean required) throws SQLException {
        if (this.closed) {
            throw new ExecutorException("Cannot commit, transaction is already closed");
        }
        this.clearLocalCache();
        this.flushStatements();
        if (required) {
            this.transaction.commit();
        }
    }

    @Override
    public void rollback(boolean required) throws SQLException {
        if (!this.closed) {
            this.clearLocalCache();
            if (required) {
                this.transaction.rollback();
            }
        }
    }

    @Override
    public void clearLocalCache() {
        if (!this.closed) {
            this.localCache.clear();
        }
    }

    protected abstract int doUpdate(MappedStatement var1, Object var2) throws SQLException;

    protected abstract List<BatchResult> doFlushStatements() throws SQLException;

    protected abstract List doQuery(MappedStatement var1, Object var2, RowBounds var3, ResultHandler var4) throws SQLException;

    protected void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private class DeferredLoad {
        MappedStatement mappedStatement;
        private MetaObject resultObject;
        private String property;
        private CacheKey key;

        public DeferredLoad(MappedStatement mappedStatement, MetaObject resultObject, String property, CacheKey key) {
            this.mappedStatement = mappedStatement;
            this.resultObject = resultObject;
            this.property = property;
            this.key = key;
        }

        public void load() {
            Object value = null;
            List list = (List)BaseExecutor.this.localCache.getObject(this.key);
            Class targetType = this.resultObject.getSetterType(this.property);
            if (Set.class.isAssignableFrom(targetType)) {
                value = new HashSet(list);
            } else if (Collection.class.isAssignableFrom(targetType)) {
                value = list;
            } else if (targetType.isArray()) {
                Object array = Array.newInstance(targetType.getComponentType(), list.size());
                value = list.toArray((Object[])array);
            } else {
                if (list != null && list.size() > 1) {
                    throw new ExecutorException("Statement returned more than one row, where no more than one was expected.");
                }
                if (list != null && list.size() == 1) {
                    value = list.get(0);
                }
            }
            this.resultObject.setValue(this.property, value);
        }
    }
}

