/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.type;

import java.io.Reader;
import java.io.StringReader;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class ClobTypeHandler
extends BaseTypeHandler {
    public void setNonNullParameter(PreparedStatement ps, int i, Object parameter, JdbcType jdbcType) throws SQLException {
        String s = (String)parameter;
        StringReader reader = new StringReader(s);
        ps.setCharacterStream(i, (Reader)reader, s.length());
    }

    public Object getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String value = "";
        Clob clob = rs.getClob(columnName);
        if (clob != null) {
            int size = (int)clob.length();
            value = clob.getSubString(1L, size);
        }
        return value;
    }

    public Object getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String value = "";
        Clob clob = cs.getClob(columnIndex);
        if (clob != null) {
            int size = (int)clob.length();
            value = clob.getSubString(1L, size);
        }
        return value;
    }
}

