/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.indexes;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import org.xBaseJ.DBF;
import org.xBaseJ.Util;
import org.xBaseJ.indexes.NodeKey;
import org.xBaseJ.xBaseJException;

public class Node
implements Cloneable {
    public RandomAccessFile nfile;
    public int pos = 0;
    public int keys_in_a_Node = 0;
    public int keys_in_this_Node = 0;
    public int key_expression_size = 0;
    public int record_number = 0;
    public char keyType = (char)67;
    public byte[] key_buffer;
    public int[] lower_level;
    public int[] key_record_number;
    public NodeKey[] key_expression;
    public Node prev = null;
    public Node next = null;
    public boolean branch = false;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public Node(RandomAccessFile file, int keys_in, int key_size, char keyType, int rn, boolean iBranch) {
        this.nfile = file;
        this.keys_in_a_Node = keys_in;
        this.key_expression_size = key_size;
        this.keys_in_this_Node = 0;
        this.keyType = keyType;
        this.record_number = rn;
        this.branch = iBranch;
        this.key_buffer = new byte[key_size];
        this.key_expression = new NodeKey[keys_in + 2];
        this.key_record_number = new int[keys_in + 2];
        this.lower_level = new int[keys_in + 2];
        int i = 0;
        while (i < keys_in) {
            this.key_record_number[i] = 0;
            this.lower_level[i] = 0;
            ++i;
        }
        this.prev = null;
        this.next = null;
    }

    public void set_pos(int ipos) {
        this.pos = ipos;
    }

    public void set_key_expression_size(int l) {
        this.key_expression_size = l;
    }

    public int pos_up() {
        return ++this.pos;
    }

    public void set_record_number(int r) throws xBaseJException {
        if (r == 0) {
            throw new xBaseJException("Invalid record number in set");
        }
        this.record_number = r;
    }

    public int get_record_number() {
        return this.record_number;
    }

    public int pos_down() {
        return --this.pos;
    }

    public int get_pos() {
        return this.pos;
    }

    public void set_key_record_number(int r) {
        this.key_record_number[this.pos] = r;
    }

    public int get_key_record_number() {
        return this.key_record_number[this.pos];
    }

    public void set_lower_level(int level) {
        this.lower_level[this.pos] = level;
    }

    public int get_lower_level() {
        return this.lower_level[this.pos];
    }

    public void set_keys_in_this_Node(int c) {
        this.keys_in_this_Node = c;
    }

    public int get_keys_in_this_Node() {
        return this.keys_in_this_Node;
    }

    public void set_key_value(NodeKey key) {
        this.key_expression[this.pos] = key;
    }

    public void set_key_value(String key) {
        this.key_expression[this.pos] = new NodeKey(key);
    }

    public void set_key_value(double key) {
        this.key_expression[this.pos] = new NodeKey(new Double(key));
    }

    public NodeKey get_key_value() {
        return this.key_expression[this.pos];
    }

    public void read() throws IOException {
        long longrecn = this.record_number;
        this.nfile.seek(longrecn * 512L);
        this.keys_in_this_Node = Util.x86(this.nfile.readInt());
        int i = 0;
        while (i < this.keys_in_a_Node) {
            int k;
            this.lower_level[i] = Util.x86(this.nfile.readInt());
            this.key_record_number[i] = Util.x86(this.nfile.readInt());
            if (this.keyType == 'N') {
                this.key_expression[i] = new NodeKey(new Double(Double.longBitsToDouble(this.nfile.readLong())));
            } else {
                this.nfile.readFully(this.key_buffer, 0, this.key_expression_size);
                k = 0;
                while (k < this.key_expression_size && this.key_buffer[k] != 0) {
                    ++k;
                }
                try {
                    this.key_expression[i] = new NodeKey(new String(this.key_buffer, 0, k, DBF.encodedType));
                }
                catch (UnsupportedEncodingException UEE) {
                    this.key_expression[i] = new NodeKey(new String(this.key_buffer, 0, k));
                }
            }
            int j = this.key_expression_size % 4;
            if (j > 0) {
                j = 4 - j;
            }
            k = 0;
            while (k < j) {
                this.nfile.readByte();
                ++k;
            }
            ++i;
        }
        this.branch = this.lower_level[0] > 0;
        this.lower_level[i] = Util.x86(this.nfile.readInt());
    }

    public void write() throws IOException, xBaseJException {
        int ll = 512;
        if (this.record_number == 0) {
            throw new xBaseJException("Invalid record number in write");
        }
        long longrecn = this.record_number;
        this.nfile.seek(longrecn * 512L);
        this.nfile.writeInt(Util.x86(this.keys_in_this_Node));
        ll -= 4;
        int i = 0;
        while (i < this.keys_in_this_Node && i < this.keys_in_a_Node && this.key_expression[i] != null) {
            if (this.key_expression[i] == null) {
                throw new xBaseJException("Missing node key expression at " + i);
            }
            if (this.lower_level[0] == 0 && this.key_record_number[i] == 0) {
                throw new xBaseJException("Logic mismatch, both pointers are zero");
            }
            this.nfile.writeInt(Util.x86(this.lower_level[i]));
            ll -= 4;
            this.nfile.writeInt(Util.x86(this.key_record_number[i]));
            ll -= 4;
            if (this.key_expression[i].getType() == 'N') {
                double d = this.key_expression[i].toDouble();
                this.nfile.writeLong(Double.doubleToLongBits(d));
            }
            if (this.key_expression[i].getType() == 'C') {
                byte[] bytebuffer;
                try {
                    bytebuffer = this.key_expression[i].toString().getBytes(DBF.encodedType);
                }
                catch (UnsupportedEncodingException UEE) {
                    bytebuffer = this.key_expression[i].toString().getBytes();
                }
                int x = 0;
                while (x < bytebuffer.length) {
                    this.key_buffer[x] = bytebuffer[x];
                    ++x;
                }
                while (x < this.key_expression_size) {
                    this.key_buffer[x] = 0;
                    ++x;
                }
                this.nfile.write(this.key_buffer, 0, this.key_expression_size);
            }
            ll -= this.key_expression_size;
            int j = this.key_expression_size % 4;
            if (j > 0) {
                j = 4 - j;
            }
            this.key_buffer[0] = 0;
            int k = 0;
            while (k < j) {
                this.nfile.write(this.key_buffer[0]);
                --ll;
                ++k;
            }
            ++i;
        }
        if (this.branch && this.lower_level[i] == 0) {
            throw new xBaseJException("Logic mismatch, lower level pointer is zero");
        }
        this.nfile.writeInt(Util.x86(this.lower_level[i]));
        if ((ll -= 4) > 0) {
            byte[] temp = new byte[ll];
            this.nfile.write(temp, 0, ll);
        }
    }

    public void set_next(Node nxt) {
        this.next = nxt;
    }

    public void set_prev(Node prv) {
        this.prev = prv;
    }

    public Node get_next() {
        return this.next;
    }

    public Node get_prev() {
        return this.prev;
    }

    public void set_prev_page(int t) throws xBaseJException {
        throw new xBaseJException("method not available");
    }

    public boolean isBranch() {
        return this.branch;
    }
}

