CREATE TABLE Shema (
	tipDok VARCHAR ( 40 ) NOT NULL,
	podTipDok VARCHAR ( 40 ) NOT NULL,
	tipRJ VARCHAR ( 1 ) NOT NULL,
	pTipRj VARCHAR ( 1 ) NOT NULL,
	ppTipRj VARCHAR ( 1 ) NOT NULL,
	oznRj VARCHAR ( 10 ) NOT NULL,
	oznOgranak VARCHAR ( 10 ) NOT NULL,
	opis VARCHAR ( 255 ),
	zatvori SMALLINT NOT NULL,
	rBroj INTEGER NOT NULL,
	opisKnjizenja VARCHAR ( 255 ),
	abstrakt SMALLINT NOT NULL,
	cena VARCHAR ( 10 ),
	CONSTRAINT PK_Shema814 PRIMARY KEY (tipDok, tipRJ, podTipDok, pTipRj, ppTipRj, oznRj, oznOgranak)
	);
CREATE TABLE AKonsTaksa (
	idDok INTEGER NOT NULL,
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	rBroj INTEGER NOT NULL,
	oznTarGr VARCHAR ( 20 ) NOT NULL,
	oznVrstaTG VARCHAR ( 20 ) NOT NULL,
	stopa DOUBLE PRECISION NOT NULL,
	opis VARCHAR ( 100 ) NOT NULL,
	CONSTRAINT PK_AKonsTaksa12 PRIMARY KEY (sfrProizvod, idDok, rBroj, oznTarGr)
	);
CREATE TABLE VrstaTG (
	oznVrstaTG VARCHAR ( 20 ) NOT NULL,
	opis VARCHAR ( 100 ),
	CONSTRAINT PK_VrstaTG3 PRIMARY KEY (oznVrstaTG)
	);
CREATE TABLE Trosak (
	idDok INTEGER NOT NULL,
	kalkulacija INTEGER NOT NULL,
	tip VARCHAR ( 255 ) NOT NULL,
	podTip VARCHAR ( 20 ),
	datFakture DATE NOT NULL,
	datDPO DATE NOT NULL,
	datValute DATE NOT NULL,
	oznDokumenta VARCHAR ( 255 ) NOT NULL,
	osnovica DECIMAL ( 20, 2 ) NOT NULL,
	pdv DECIMAL ( 20, 2 ),
	bezPrava DECIMAL ( 20, 2 ) NOT NULL,
	oslobodjeno DECIMAL ( 20, 2 ) NOT NULL,
	pravo VARCHAR ( 255 ),
	sfrKomitent VARCHAR ( 20 ),
	iznos DECIMAL ( 20, 2 ),
	original INTEGER,
	uplata DECIMAL ( 20, 2 ),
	stornoIznos DECIMAL ( 20, 2 ),
	CONSTRAINT PK_Trosak61 PRIMARY KEY (idDok)
	);
CREATE INDEX TC_Trosak2044 ON Trosak (sfrKomitent );
CREATE TABLE Kurs (
	datum DATE NOT NULL,
	srednji DECIMAL ( 20, 4 ) NOT NULL,
	auto SMALLINT DEFAULT 0 NOT NULL,
	oznValuta VARCHAR ( 10 ) NOT NULL,
	jedinica INTEGER NOT NULL,
	kupovni DECIMAL ( 20, 4 ),
	prodajni DECIMAL ( 20, 4 ),
	CONSTRAINT PK_Kurs748 PRIMARY KEY (oznValuta, datum)
	);
CREATE TABLE ADTaksa (
	idDok INTEGER NOT NULL,
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	rBroj INTEGER NOT NULL,
	oznTarGr VARCHAR ( 20 ) NOT NULL,
	stopa DOUBLE PRECISION NOT NULL,
	oznVrstaTG VARCHAR ( 20 ) NOT NULL,
	opis VARCHAR ( 100 ) NOT NULL,
	CONSTRAINT PK_ADTaksa13 PRIMARY KEY (idDok, sfrProizvod, rBroj, oznTarGr)
	);
CREATE TABLE Brojac (
	tip VARCHAR ( 45 ) NOT NULL,
	rBroj INTEGER NOT NULL,
	version INTEGER NOT NULL,
	CONSTRAINT PK_Brojac813 PRIMARY KEY (tip)
	);
CREATE TABLE StavkaZahteva (
	idPoruzbine INTEGER NOT NULL,
	idZahteva INTEGER NOT NULL,
	naziv VARCHAR ( 30 ) NOT NULL,
	vrednost VARCHAR ( 255 ) NOT NULL,
	CONSTRAINT PK_StavkaZahteva74 PRIMARY KEY (idPoruzbine, idZahteva, naziv)
	);
CREATE TABLE PzUserInfo (
	pzusername VARCHAR ( 20 ) NOT NULL,
	ime VARCHAR ( 30 ),
	prezime VARCHAR ( 30 ),
	jmbg VARCHAR ( 30 ),
	brlk VARCHAR ( 20 ),
	lkIzdao VARCHAR ( 200 ),
	adresa VARCHAR ( 255 ),
	mesto VARCHAR ( 255 ),
	postBroj VARCHAR ( 10 ),
	slika VARCHAR ( 300 ),
	datRodj DATE,
	datPocetka DATE,
	datKraja DATE,
	pol SMALLINT,
	bStatus SMALLINT,
	zabeleska VARCHAR,
	CONSTRAINT PK_PzUserInfo82 PRIMARY KEY (pzusername)
	);
CREATE TABLE StavkaPorudzbine (
	rBroj INTEGER NOT NULL,
	idDok INTEGER NOT NULL,
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	kolPorucena DECIMAL ( 20, 3 ) NOT NULL,
	cenaPorucena DECIMAL ( 20, 2 ) NOT NULL,
	kons VARCHAR ( 5 ),
	kolKons DECIMAL ( 20, 3 ),
	oznOgranak VARCHAR ( 255 ) NOT NULL,
	oznRj VARCHAR ( 255 ) NOT NULL,
	CONSTRAINT PK_StavkaPorudzbine58 PRIMARY KEY (oznOgranak, oznRj, idDok, rBroj)
	);
CREATE TABLE ArtikalTemp (
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	naziv VARCHAR ( 100 ),
	bliziOpis VARCHAR ( 1000 ),
	CONSTRAINT PK_ArtikalTemp50 PRIMARY KEY (sfrProizvod)
	);
CREATE TABLE Stanje (
	kolicina DOUBLE PRECISION NOT NULL,
	oznOgranak VARCHAR ( 255 ) NOT NULL,
	oznRj VARCHAR ( 255 ) NOT NULL,
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	alocKolicina DOUBLE PRECISION NOT NULL,
	prodCena DECIMAL ( 20, 2 ) NOT NULL,
	zadNabCena DECIMAL ( 20, 2 ) NOT NULL,
	prosNabCena DECIMAL ( 20, 4 ) NOT NULL,
	pocStanje DECIMAL ( 20, 2 ) DEFAULT 0,
	cenaNaPS DECIMAL ( 20, 2 ) NOT NULL,
	kumUlaza DOUBLE PRECISION NOT NULL,
	datZadUlaza DATE,
	kumIzlaza DOUBLE PRECISION NOT NULL,
	datZadIzlaza DATE,
	kumProdaje DECIMAL ( 20, 3 ),
	stalaza VARCHAR ( 1 ),
	nivo VARCHAR ( 1 ),
	paleta VARCHAR ( 1 ),
	nabVrednost DOUBLE PRECISION,
	kolPop DOUBLE PRECISION NOT NULL,
	datPop DATE,
	stokMin DOUBLE PRECISION,
	stokMax DOUBLE PRECISION,
	version INTEGER DEFAULT 0 NOT NULL,
	CONSTRAINT PK_Stanje786 PRIMARY KEY (sfrProizvod, oznOgranak, oznRj)
	);
CREATE TABLE SFUTaksa (
	rBroj INTEGER NOT NULL,
	oznTarGr VARCHAR ( 20 ) NOT NULL,
	oznVrstaTG VARCHAR ( 20 ) NOT NULL,
	stopa DOUBLE PRECISION NOT NULL,
	opis VARCHAR ( 100 ) NOT NULL,
	idDok INTEGER NOT NULL,
	CONSTRAINT PK_SFUTaksa9 PRIMARY KEY (idDok, rBroj, oznTarGr)
	);
CREATE TABLE NalogPrijem (
	oznNalogPrijem INTEGER NOT NULL,
	datNaloga DATE,
	datPakovanja DATE,
	magacini VARCHAR ( 255 ),
	potpis VARCHAR ( 255 ),
	status INTEGER NOT NULL,
	spakovano INTEGER NOT NULL,
	idDok INTEGER,
	pzusername VARCHAR ( 20 ) NOT NULL,
	napomena VARCHAR,
	oznOgranak VARCHAR ( 255 ),
	oznRj VARCHAR ( 255 ),
	CONSTRAINT PK_NalogPrijem59 PRIMARY KEY (oznNalogPrijem)
	);
CREATE TABLE KamatnaStopa (
	mesec INTEGER NOT NULL,
	godina INTEGER NOT NULL,
	pocetni INTEGER NOT NULL,
	krajnji INTEGER NOT NULL,
	stopa DOUBLE PRECISION NOT NULL,
	CONSTRAINT PK_KamatnaStopa808 PRIMARY KEY (mesec, godina, pocetni, krajnji)
	);
CREATE TABLE Konto (
	oznKonto VARCHAR ( 6 ) NOT NULL,
	analitika VARCHAR ( 25 ) NOT NULL,
	naziv VARCHAR ( 255 ) NOT NULL,
	tipAnalitike VARCHAR ( 255 ),
	pdug DECIMAL ( 20, 2 ) DEFAULT 0,
	ppot DECIMAL ( 20, 2 ) DEFAULT 0,
	pdat DATE,
	dug DECIMAL ( 20, 2 ) DEFAULT 0,
	pot DECIMAL ( 20, 2 ) DEFAULT 0,
	sdug DECIMAL ( 20, 2 ) DEFAULT 0,
	spot DECIMAL ( 20, 2 ) DEFAULT 0,
	zdug DECIMAL ( 20, 2 ) DEFAULT 0,
	zpot DECIMAL ( 20, 2 ) DEFAULT 0,
	datum DATE,
	CONSTRAINT PK_Konto742 PRIMARY KEY (oznKonto, analitika)
	);
CREATE TABLE Zamena (
	artikal VARCHAR ( 255 ) NOT NULL,
	zamena VARCHAR ( 255 ) NOT NULL,
	CONSTRAINT PK_Zamena797 PRIMARY KEY (zamena, artikal)
	);
CREATE TABLE StavkaFaktureUsl (
	idDok INTEGER NOT NULL,
	sfrProizvod VARCHAR ( 255 ),
	rBroj INTEGER NOT NULL,
	naziv VARCHAR NOT NULL,
	cena DOUBLE PRECISION NOT NULL,
	kolicina DECIMAL ( 20, 2 ),
	sort INTEGER,
	CONSTRAINT PK_StavkaFaktureUsl763 PRIMARY KEY (idDok, rBroj)
	);
CREATE TABLE ArtikalOpstiDokument (
	idDok INTEGER NOT NULL,
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	rBroj INTEGER NOT NULL,
	naziv VARCHAR ( 255 ) NOT NULL,
	bliziOpis VARCHAR ( 1000 ),
	jm VARCHAR ( 255 ) NOT NULL,
	kolicina DOUBLE PRECISION NOT NULL,
	cenaBezPoreza DOUBLE PRECISION NOT NULL,
	procRabata DOUBLE PRECISION,
	cenaSaPorezom DOUBLE PRECISION NOT NULL,
	kolicinaBaza DOUBLE PRECISION,
	lokacija VARCHAR ( 40 ),
	par_idDok INTEGER,
	par_sfrProizvod VARCHAR ( 255 ),
	par_rBroj INTEGER,
	int1 INTEGER,
	int2 INTEGER,
	dbl1 DOUBLE PRECISION,
	dbl2 DOUBLE PRECISION,
	str1 VARCHAR ( 255 ),
	str2 VARCHAR ( 255 ),
	str3 VARCHAR ( 255 ),
	dat1 DATE,
	dat2 DATE,
	discriminator VARCHAR ( 255 ),
	prodCena DECIMAL ( 20, 2 ),
	prosNabCena DECIMAL ( 20, 2 ),
	indk SMALLINT,
	dobSifra VARCHAR ( 30 ),
	int3 INTEGER,
	int4 INTEGER,
	sort INTEGER,
	CONSTRAINT PK_ArtikalOstaliDokumenti20 PRIMARY KEY (idDok, sfrProizvod, rBroj),
	CONSTRAINT TC_ArtikalOpstiDokument178 UNIQUE (par_idDok, par_sfrProizvod, par_rBroj)
	);
CREATE TABLE Porudzbina (
	idPoruzbine INTEGER NOT NULL,
	vreme INTEGER NOT NULL,
	napomena VARCHAR ( 1000 ),
	rBroj INTEGER NOT NULL,
	status VARCHAR ( 20 ),
	sfrKomitent VARCHAR ( 255 ) NOT NULL,
	idDok INTEGER,
	CONSTRAINT PK_Porudzbina72 PRIMARY KEY (idPoruzbine)
	);
CREATE TABLE Komitent (
	sfrKomitent VARCHAR ( 20 ) NOT NULL,
	naziv VARCHAR ( 255 ) NOT NULL,
	adresa VARCHAR ( 255 ),
	postBroj VARCHAR ( 255 ),
	grad VARCHAR ( 255 ),
	telefoni VARCHAR ( 255 ),
	opis VARCHAR ( 3000 ),
	brFaxa VARCHAR ( 255 ),
	sifDelatnosti VARCHAR ( 255 ),
	matBroj VARCHAR ( 255 ),
	regBroj VARCHAR ( 255 ),
	pib VARCHAR ( 255 ) NOT NULL,
	email VARCHAR ( 255 ),
	kontakt VARCHAR ( 255 ),
	obveznikPDV SMALLINT,
	brojPDV VARCHAR ( 255 ),
	domaciKomitent SMALLINT,
	zemljaKomitenta VARCHAR ( 255 ),
	srbija SMALLINT,
	povPravnoLice SMALLINT,
	tip INTEGER DEFAULT 0,
	novcaniLimit DECIMAL ( 20, 2 ),
	valutniLimit INTEGER,
	CONSTRAINT PK_Komitent740 PRIMARY KEY (sfrKomitent)
	);
CREATE TABLE Racunopolagac (
	idRacunopolagac INTEGER NOT NULL,
	naziv VARCHAR ( 100 ) NOT NULL,
	CONSTRAINT PK_Racunopolagac103 PRIMARY KEY (idRacunopolagac),
	CONSTRAINT TC_Racunopolagac511 UNIQUE (idRacunopolagac)
	);
CREATE TABLE ArtikalInterniRacun (
	idDok INTEGER NOT NULL,
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	rBroj INTEGER NOT NULL,
	naziv VARCHAR ( 255 ) NOT NULL,
	bliziOpis VARCHAR ( 1000 ),
	jm VARCHAR ( 255 ) NOT NULL,
	kolicina DOUBLE PRECISION NOT NULL,
	izlCena DOUBLE PRECISION NOT NULL,
	ulCena DOUBLE PRECISION NOT NULL,
	procRabata DOUBLE PRECISION NOT NULL,
	procMarze DOUBLE PRECISION NOT NULL,
	cvProdajnaIznos DOUBLE PRECISION,
	temp DOUBLE PRECISION,
	ulProdCena DECIMAL ( 20, 2 ),
	izlProdCena DECIMAL ( 20, 2 ),
	ulProsNabCena DECIMAL ( 20, 4 ),
	izlProsNabCena DECIMAL ( 20, 4 ),
	sort INTEGER,
	CONSTRAINT PK_ArtikalInterniRacun758 PRIMARY KEY (sfrProizvod, idDok, rBroj)
	);
CREATE TABLE Blagajna (
	oznBlagajna VARCHAR ( 255 ) NOT NULL,
	opis VARCHAR ( 255 ) NOT NULL,
	oznKonto VARCHAR ( 6 ) NOT NULL,
	analitika VARCHAR ( 25 ) NOT NULL,
	CONSTRAINT PK_Blagajna747 PRIMARY KEY (oznBlagajna)
	);
CREATE INDEX TC_Blagajna2034 ON Blagajna (oznKonto );
CREATE TABLE StavkaNZK (
	rBroj INTEGER NOT NULL,
	idNalog INTEGER NOT NULL,
	oznKonto VARCHAR ( 6 ) NOT NULL,
	analitika VARCHAR ( 25 ) NOT NULL,
	idDok INTEGER,
	oznOgranak VARCHAR ( 255 ),
	oznRj VARCHAR ( 255 ),
	sfrKomitent VARCHAR ( 20 ),
	brDokumenta VARCHAR ( 255 ),
	duguje DECIMAL ( 20, 2 ) NOT NULL,
	potrazuje DECIMAL ( 20, 2 ) NOT NULL,
	saldo DECIMAL ( 20, 2 ) NOT NULL,
	opis VARCHAR ( 255 ) NOT NULL,
	datDokumenta DATE,
	nazivKonta VARCHAR ( 255 ) NOT NULL,
	datKnjizenja DATE,
	sfrKnjizenja INTEGER,
	nazivAnalitike VARCHAR ( 255 ),
	CONSTRAINT PK_StavkaGlavneKnjige767 PRIMARY KEY (oznKonto, analitika, idNalog, rBroj)
	);
CREATE TABLE RadnoMesto (
	idRadnoMesto INTEGER NOT NULL,
	naziv VARCHAR ( 255 ) NOT NULL,
	CONSTRAINT PK_RadnoMesto85 PRIMARY KEY (idRadnoMesto)
	);
CREATE TABLE StavkaKEPU (
	rBroj INTEGER NOT NULL,
	datum DATE NOT NULL,
	opisKnjizenja VARCHAR ( 255 ) NOT NULL,
	zaduzenje DOUBLE PRECISION NOT NULL,
	razduzenje DOUBLE PRECISION NOT NULL,
	uplata DATE NOT NULL,
	CONSTRAINT PK_StavkaKEPU768 PRIMARY KEY (rBroj)
	);
CREATE TABLE Dokument (
	idDok INTEGER NOT NULL,
	oznDokumenta VARCHAR ( 30 ),
	tip VARCHAR ( 30 ) NOT NULL,
	podTip VARCHAR ( 50 ),
	datum DATE,
	datArh DATE,
	datValute DATE,
	datPrometa DATE,
	arhiviran SMALLINT NOT NULL,
	proknjizen SMALLINT NOT NULL,
	kepu SMALLINT,
	rBroj INTEGER NOT NULL,
	rbrDok INTEGER,
	rbrKepu INTEGER,
	rbrKpr INTEGER,
	opis VARCHAR ( 2000 ),
	storno INTEGER NOT NULL,
	iznos DECIMAL ( 20, 2 ) DEFAULT 0,
	stornoIznos DECIMAL ( 20, 2 ) DEFAULT 0,
	uplata DECIMAL ( 20, 2 ) DEFAULT 0,
	zaduzenje DECIMAL ( 20, 2 ) DEFAULT 0,
	razduzenje DECIMAL ( 20, 2 ) DEFAULT 0,
	usernamePoc VARCHAR ( 20 ) NOT NULL,
	usernameKraj VARCHAR ( 20 ) NOT NULL,
	oznOgranak VARCHAR ( 255 ),
	oznRj VARCHAR ( 255 ),
	sfrKomitent VARCHAR ( 255 ),
	original INTEGER,
	vrsta VARCHAR ( 1 ) NOT NULL,
	cvProdajna SMALLINT NOT NULL,
	vrednostRobe DECIMAL ( 20, 2 ),
	vrednostUsluga DECIMAL ( 20, 2 ),
	vrstaDuga VARCHAR ( 10 ),
	CONSTRAINT PK_Dokument0 PRIMARY KEY (idDok)
	);
CREATE TABLE ArtikalNalog (
	oznNalogMagacinu INTEGER NOT NULL,
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	rBroj INTEGER NOT NULL,
	naziv VARCHAR ( 255 ) NOT NULL,
	bliziOpis VARCHAR ( 1000 ),
	jm VARCHAR ( 255 ) NOT NULL,
	kolicina DOUBLE PRECISION NOT NULL,
	dobSifra VARCHAR ( 255 ),
	stalaza VARCHAR ( 10 ) NOT NULL,
	nivo VARCHAR ( 10 ) NOT NULL,
	paleta VARCHAR ( 10 ) NOT NULL,
	sort INTEGER,
	kbr VARCHAR ( 30 ),
	dat VARCHAR ( 20 ),
	CONSTRAINT PK_ArtikalNalog795 PRIMARY KEY (oznNalogMagacinu, sfrProizvod, rBroj)
	);
CREATE TABLE DokumentPotvrda (
	tip VARCHAR ( 20 ) NOT NULL,
	idDok INTEGER NOT NULL,
	pzusername VARCHAR ( 30 ) NOT NULL,
	status INTEGER NOT NULL,
	CONSTRAINT PK_DokumentPotvrda93 PRIMARY KEY (tip, idDok)
	);
CREATE TABLE Ambalaza (
	oznAmbalaza VARCHAR ( 255 ) NOT NULL,
	naziv VARCHAR ( 255 ) NOT NULL,
	jedMere VARCHAR ( 255 ) NOT NULL,
	cena DOUBLE PRECISION NOT NULL,
	CONSTRAINT PK_Ambalaza746 PRIMARY KEY (oznAmbalaza)
	);
CREATE TABLE SlobodnaAnalitika (
	oznAnalitika VARCHAR ( 10 ) NOT NULL,
	naziv VARCHAR ( 100 ) NOT NULL,
	CONSTRAINT PK_SlobodnaAnalitika47 PRIMARY KEY (oznAnalitika)
	);
CREATE TABLE KomitentGrupa (
	idKomitentGrupa INTEGER NOT NULL,
	naziv VARCHAR ( 255 ) NOT NULL,
	pzusername VARCHAR ( 20 ),
	tip VARCHAR ( 10 ),
	provizija DOUBLE PRECISION DEFAULT 0,
	CONSTRAINT PK_KomitentGrupa87 PRIMARY KEY (idKomitentGrupa)
	);
CREATE TABLE AKTaksa (
	idDok INTEGER NOT NULL,
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	rBroj INTEGER NOT NULL,
	oznTarGr VARCHAR ( 20 ) NOT NULL,
	oznVrstaTG VARCHAR ( 20 ) NOT NULL,
	stopa DOUBLE PRECISION NOT NULL,
	opis VARCHAR ( 100 ) NOT NULL,
	CONSTRAINT PK_AKTaksa11 PRIMARY KEY (sfrProizvod, idDok, rBroj, oznTarGr)
	);
CREATE TABLE KalkulacijaZapisnik (
	kalkulacija INTEGER NOT NULL,
	zapisnik INTEGER NOT NULL,
	fakturisano DECIMAL ( 20, 2 ) NOT NULL,
	stornirano DECIMAL ( 20, 2 ),
	porez VARCHAR ( 10 ),
	CONSTRAINT PK_KalkulacijaZapisnik35 PRIMARY KEY (zapisnik, kalkulacija)
	);
CREATE TABLE FakturaParameter (
	idDok INTEGER NOT NULL,
	name VARCHAR ( 20 ) NOT NULL,
	value VARCHAR NOT NULL,
	description VARCHAR ( 255 ),
	CONSTRAINT PK_FakturaParameter92 PRIMARY KEY (idDok, name)
	);
CREATE TABLE TipEmaila (
	idTipEmaila INTEGER NOT NULL,
	naziv VARCHAR ( 255 ) NOT NULL,
	predefinisan SMALLINT NOT NULL,
	CONSTRAINT PK_TipEmaila84 PRIMARY KEY (idTipEmaila)
	);
CREATE TABLE Proizvod (
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	CONSTRAINT PK_Proizvod753 PRIMARY KEY (sfrProizvod)
	);
CREATE TABLE PFRTaksa (
	idDok INTEGER NOT NULL,
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	rBroj INTEGER NOT NULL,
	oznTarGr VARCHAR ( 20 ) NOT NULL,
	oznVrstaTG VARCHAR ( 20 ) NOT NULL,
	stopa DOUBLE PRECISION NOT NULL,
	opis VARCHAR ( 100 ) NOT NULL,
	CONSTRAINT PK_PFRTaksa57 PRIMARY KEY (idDok, sfrProizvod, rBroj, oznTarGr)
	);
CREATE TABLE InterniRacun (
	idDok INTEGER NOT NULL,
	idDok1 INTEGER NOT NULL,
	oznDokumenta VARCHAR ( 255 ),
	datum DATE NOT NULL,
	datArh DATE,
	tip VARCHAR ( 255 ) NOT NULL,
	podTip VARCHAR ( 30 ),
	vredNaUlazu DECIMAL ( 20, 2 ) DEFAULT 0,
	procRabata DOUBLE PRECISION NOT NULL,
	arhiviran SMALLINT NOT NULL,
	proknjizen SMALLINT NOT NULL,
	storno INTEGER NOT NULL,
	ulaznaRJ VARCHAR ( 255 ) NOT NULL,
	izlaznaRJ VARCHAR ( 255 ) NOT NULL,
	usernamePoc VARCHAR ( 20 ) NOT NULL,
	usernameKraj VARCHAR ( 20 ) NOT NULL,
	ulazniOgranak VARCHAR ( 255 ) NOT NULL,
	izlazniOgranak VARCHAR ( 255 ) NOT NULL,
	vredNaIzlazu DECIMAL ( 20, 2 ) DEFAULT 0,
	pdvIznos DECIMAL ( 20, 2 ) DEFAULT 0,
	pdvIznos2 DECIMAL ( 20, 2 ) DEFAULT 0,
	rjUlaz VARCHAR ( 255 ) NOT NULL,
	rjIzlaz VARCHAR ( 255 ) NOT NULL,
	rBroj INTEGER NOT NULL,
	rbrDok INTEGER NOT NULL,
	poruka VARCHAR ( 5000 ),
	cvProdajna SMALLINT NOT NULL,
	cvProdajnaUkupno DECIMAL ( 20, 2 ) DEFAULT 0,
	razlika DECIMAL ( 20, 2 ) DEFAULT 0,
	stornoIznos DECIMAL ( 20, 2 ) DEFAULT 0,
	CONSTRAINT PK_InterniRacun804 PRIMARY KEY (idDok),
	CONSTRAINT TC_InterniRacun83 UNIQUE (idDok1)
	);
CREATE INDEX TC_InterniRacun2047 ON InterniRacun (ulazniOgranak , ulaznaRJ );
CREATE INDEX TC_InterniRacun2046 ON InterniRacun (usernameKraj );
CREATE INDEX TC_InterniRacun2045 ON InterniRacun (izlazniOgranak , izlaznaRJ );
CREATE TABLE Firma (
	oznFirma INTEGER NOT NULL,
	naziv VARCHAR ( 255 ) NOT NULL,
	adresa VARCHAR ( 255 ) NOT NULL,
	postBroj VARCHAR ( 255 ) NOT NULL,
	grad VARCHAR ( 255 ) NOT NULL,
	telefoni VARCHAR ( 255 ) NOT NULL,
	fax VARCHAR ( 255 ) NOT NULL,
	email VARCHAR ( 255 ) NOT NULL,
	pib VARCHAR ( 255 ) NOT NULL,
	matBroj VARCHAR ( 255 ) NOT NULL,
	regBroj VARCHAR ( 255 ) NOT NULL,
	sifDelatnosti VARCHAR ( 255 ) NOT NULL,
	mestoReg VARCHAR ( 255 ) NOT NULL,
	pdvObveznik SMALLINT NOT NULL,
	CONSTRAINT PK_Firma756 PRIMARY KEY (oznFirma)
	);
CREATE TABLE ArtikalAkcija (
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	naziv VARCHAR ( 100 ) NOT NULL,
	cena DOUBLE PRECISION NOT NULL,
	pzusername VARCHAR ( 20 ) NOT NULL,
	CONSTRAINT PK_ArtikalAkcija64 PRIMARY KEY (pzusername, sfrProizvod)
	);
CREATE TABLE AIRTaksa (
	idDok INTEGER NOT NULL,
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	rBroj INTEGER NOT NULL,
	oznTarGr VARCHAR ( 20 ) NOT NULL,
	oznVrstaTG VARCHAR ( 20 ) NOT NULL,
	stopa DOUBLE PRECISION NOT NULL,
	opis VARCHAR ( 100 ) NOT NULL,
	CONSTRAINT PK_AIRTaksa10 PRIMARY KEY (sfrProizvod, idDok, rBroj, oznTarGr)
	);
CREATE TABLE KomitentParameter (
	idParameter VARCHAR ( 30 ) NOT NULL,
	sfrKomitent VARCHAR ( 20 ) NOT NULL,
	value VARCHAR NOT NULL,
	CONSTRAINT PK_KomitentParameter105 PRIMARY KEY (sfrKomitent, idParameter)
	);
CREATE TABLE Lista (
	idLista INTEGER DEFAULT 1 NOT NULL,
	naslov VARCHAR ( 100 ) NOT NULL,
	komentar VARCHAR ( 2000 ),
	datum DATE NOT NULL,
	pzusername VARCHAR ( 20 ) NOT NULL,
	arhiviran SMALLINT NOT NULL,
	counter INTEGER,
	sfrKomitent VARCHAR ( 20 ),
	rBroj INTEGER,
	tip VARCHAR ( 100 ) NOT NULL,
	CONSTRAINT PK_Lista33 PRIMARY KEY (idLista)
	);
CREATE TABLE DTaksa (
	idDok INTEGER NOT NULL,
	oznTarGr VARCHAR ( 255 ) NOT NULL,
	tip VARCHAR ( 15 ) NOT NULL,
	osnovica DECIMAL ( 20, 2 ) NOT NULL,
	iznos DECIMAL ( 20, 2 ) NOT NULL,
	vrsta VARCHAR ( 20 ) NOT NULL,
	CONSTRAINT PK_DTGR2 PRIMARY KEY (oznTarGr, idDok, tip)
	);
CREATE TABLE ProizvodFiskalniRacun (
	idDok INTEGER NOT NULL,
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	rBroj INTEGER NOT NULL,
	naziv VARCHAR ( 255 ) NOT NULL,
	bliziOpis VARCHAR ( 1000 ),
	jm VARCHAR ( 255 ),
	kolicina DOUBLE PRECISION NOT NULL,
	cena DOUBLE PRECISION NOT NULL,
	procRabata DOUBLE PRECISION NOT NULL,
	indk SMALLINT,
	dobSifra VARCHAR ( 30 ),
	sort INTEGER,
	CONSTRAINT PK_ProizvodFiskalniRacun55 PRIMARY KEY (idDok, sfrProizvod, rBroj)
	);
CREATE TABLE PDVObracun (
	datOD DATE NOT NULL,
	datDO DATE NOT NULL,
	oslobSaOdb DOUBLE PRECISION NOT NULL,
	oslobBezOdb DOUBLE PRECISION NOT NULL,
	poOpstoj DOUBLE PRECISION NOT NULL,
	poPosebnoj DOUBLE PRECISION NOT NULL,
	uvoz DOUBLE PRECISION NOT NULL,
	naknadaPoljop DOUBLE PRECISION NOT NULL,
	ostalo DOUBLE PRECISION NOT NULL,
	povracaj DOUBLE PRECISION NOT NULL,
	pzusername VARCHAR ( 20 ) NOT NULL,
	CONSTRAINT PK_PDVObracun764 PRIMARY KEY (datOD, datDO)
	);
CREATE INDEX TC_PDVObracun2060 ON PDVObracun (pzusername );
CREATE TABLE FakturaOpstiDokument (
	opstiDokument INTEGER NOT NULL,
	faktura INTEGER NOT NULL,
	iznos DECIMAL ( 20, 2 ) NOT NULL,
	porez VARCHAR ( 20 ) NOT NULL,
	saPravom VARCHAR ( 20 ) NOT NULL,
	CONSTRAINT PK_FakturaOpstiDokument45 PRIMARY KEY (faktura, opstiDokument)
	);
CREATE TABLE NalogMagacinu (
	oznNalogMagacinu INTEGER NOT NULL,
	adrTel VARCHAR ( 255 ) NOT NULL,
	datum DATE NOT NULL,
	info INTEGER NOT NULL,
	brTure INTEGER,
	rbrPalete INTEGER,
	vremePreuzimanja VARCHAR ( 10 ),
	robuPreuzima VARCHAR ( 255 ),
	redniBroj INTEGER NOT NULL,
	brojKopije INTEGER NOT NULL,
	koVozi VARCHAR ( 20 ) NOT NULL,
	poslaoUser VARCHAR ( 100 ),
	napomena VARCHAR,
	idDok INTEGER,
	oznOgranak VARCHAR ( 255 ),
	oznRj VARCHAR ( 255 ),
	CONSTRAINT PK_NalogMagacinu803 PRIMARY KEY (oznNalogMagacinu)
	);
CREATE TABLE ArtikalDokument (
	idDok INTEGER NOT NULL,
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	rBroj INTEGER NOT NULL,
	naziv VARCHAR ( 100 ) NOT NULL,
	bliziOpis VARCHAR ( 1000 ),
	kolicina DOUBLE PRECISION NOT NULL,
	jm VARCHAR ( 10 ),
	cena DOUBLE PRECISION NOT NULL,
	procRabata DOUBLE PRECISION,
	vrsta VARCHAR ( 1 ) NOT NULL,
	vrstaPromene VARCHAR ( 10 ),
	vrednost DECIMAL ( 20, 2 ),
	prodCena DECIMAL ( 20, 2 ),
	prosNabCena DECIMAL ( 20, 4 ),
	nabCena DECIMAL ( 20, 2 ),
	sort INTEGER,
	sfrSort VARCHAR ( 255 ),
	CONSTRAINT PK_ArtikalDokument1 PRIMARY KEY (idDok, sfrProizvod, rBroj)
	);
CREATE TABLE ArtikalKonsignacija (
	idDok INTEGER NOT NULL,
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	rBroj INTEGER NOT NULL,
	naziv VARCHAR ( 255 ) NOT NULL,
	bliziOpis VARCHAR ( 1000 ),
	jm VARCHAR ( 255 ) NOT NULL,
	kolicina DOUBLE PRECISION NOT NULL,
	cenaBezPoreza DOUBLE PRECISION NOT NULL,
	procRabata DOUBLE PRECISION NOT NULL,
	cenaSaPorezom DOUBLE PRECISION NOT NULL,
	lokacija VARCHAR ( 40 ),
	sort INTEGER,
	CONSTRAINT PK_ArtikalKonsignacija811 PRIMARY KEY (sfrProizvod, idDok, rBroj)
	);
CREATE TABLE BrzaPosta (
	oznBP INTEGER NOT NULL,
	naziv VARCHAR ( 255 ) NOT NULL,
	CONSTRAINT PK_BrzaPosta791 PRIMARY KEY (oznBP)
	);
CREATE TABLE ID_GEN (
	ID_NAME VARCHAR ( 45 ) NOT NULL,
	ID_VAL INTEGER DEFAULT 0 NOT NULL,
	version INTEGER DEFAULT 0,
	CONSTRAINT PK_ID_GEN807 PRIMARY KEY (ID_NAME)
	);
CREATE TABLE TaksaOpstiDokument (
	idDok INTEGER NOT NULL,
	oznTarGr VARCHAR ( 255 ) NOT NULL,
	tip VARCHAR ( 10 ) NOT NULL,
	vrsta VARCHAR ( 20 ) NOT NULL,
	iznos DECIMAL ( 20, 2 ) NOT NULL,
	osnovica DECIMAL ( 20, 2 ) NOT NULL,
	CONSTRAINT PK_TaksaOpstiDokument31 PRIMARY KEY (oznTarGr, idDok, tip)
	);
CREATE TABLE FiskalniRacun (
	idDok INTEGER NOT NULL,
	rBroj INTEGER NOT NULL,
	oznDokumenta VARCHAR ( 30 ),
	vreme TIMESTAMP NOT NULL,
	arhiviran SMALLINT NOT NULL,
	poruka VARCHAR ( 5000 ),
	storno INTEGER NOT NULL,
	iznos DECIMAL ( 20, 2 ) DEFAULT 0,
	stornoIznos DECIMAL ( 20, 2 ) DEFAULT 0,
	oznOgranak VARCHAR ( 255 ) NOT NULL,
	oznRj VARCHAR ( 255 ) NOT NULL,
	pzusername VARCHAR ( 20 ) NOT NULL,
	sfrKomitent VARCHAR ( 20 ),
	nazivKupca VARCHAR ( 255 ),
	adresa VARCHAR ( 255 ),
	grad VARCHAR ( 255 ),
	pib VARCHAR ( 255 ),
	brFiskalnogIsecka VARCHAR ( 15 ),
	gotovina DECIMAL ( 20, 2 ),
	cekovi DECIMAL ( 20, 2 ),
	kartice DECIMAL ( 20, 2 ),
	original INTEGER,
	vrednostRobe DECIMAL ( 20, 2 ),
	vrednostUsluga DECIMAL ( 20, 2 ),
	CONSTRAINT PK_FiskalniRacun56 PRIMARY KEY (idDok)
	);
CREATE TABLE ANTaksa (
	idDok INTEGER NOT NULL,
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	rBroj INTEGER NOT NULL,
	oznTarGr VARCHAR ( 20 ) NOT NULL,
	oznVrstaTG VARCHAR ( 20 ) NOT NULL,
	stopa DOUBLE PRECISION NOT NULL,
	opis VARCHAR ( 100 ) NOT NULL,
	CONSTRAINT PK_ANTaksa14 PRIMARY KEY (sfrProizvod, idDok, rBroj, oznTarGr)
	);
CREATE TABLE KoPlaca (
	oznNalogMagacinu INTEGER NOT NULL,
	oznBP INTEGER NOT NULL,
	placaProdavac SMALLINT NOT NULL,
	procenat DOUBLE PRECISION,
	CONSTRAINT PK_KoVozi794 PRIMARY KEY (oznNalogMagacinu, oznBP)
	);
CREATE TABLE UslugaDokument (
	idDok INTEGER NOT NULL,
	rBroj INTEGER NOT NULL,
	sfrProizvod VARCHAR ( 255 ),
	naziv VARCHAR NOT NULL,
	kolicina DOUBLE PRECISION NOT NULL,
	cena DOUBLE PRECISION NOT NULL,
	brNormaSati DOUBLE PRECISION NOT NULL,
	sort INTEGER,
	CONSTRAINT PK_UslugaDokument51 PRIMARY KEY (idDok, rBroj)
	);
CREATE TABLE Parameters (
	id INTEGER NOT NULL,
	dvojnoKnjigovodstvo SMALLINT,
	evro SMALLINT,
	minus SMALLINT,
	rbruKepu SMALLINT,
	razduzenje VARCHAR ( 45 ),
	intNalFormAloc SMALLINT,
	stampaSveRacune SMALLINT,
	rabatnaSkala SMALLINT,
	cvProdajna SMALLINT,
	cPRNC SMALLINT,
	csPlanska SMALLINT,
	cSlikaCena VARCHAR ( 40 ),
	cSlikaNabavna VARCHAR ( 40 ),
	cSlikaPRNC VARCHAR ( 40 ),
	brfAutomatski SMALLINT,
	broAutomatski SMALLINT,
	CONSTRAINT PK_Parameters790 PRIMARY KEY (id)
	);
CREATE TABLE OsobinaArtikla (
	oznOsobinaArtikla VARCHAR ( 30 ) NOT NULL,
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	oznOgranak VARCHAR ( 255 ) NOT NULL,
	oznRj VARCHAR ( 255 ) NOT NULL,
	osobina1 VARCHAR,
	osobina2 VARCHAR,
	osobina3 VARCHAR,
	version INTEGER DEFAULT 0 NOT NULL,
	discriminator VARCHAR ( 20 ),
	kolicina DOUBLE PRECISION NOT NULL,
	CONSTRAINT PK_Osobina94 PRIMARY KEY (sfrProizvod, oznOgranak, oznRj, oznOsobinaArtikla)
	);
CREATE TABLE KomercijalnaPolitika (
	idKomercijalnaPolitika INTEGER NOT NULL,
	aktivna SMALLINT NOT NULL,
	idKondGrupaArtikli INTEGER,
	idKondGrupaKomitenti INTEGER,
	tip INTEGER NOT NULL,
	vrednost VARCHAR ( 100 ) NOT NULL,
	datOd DATE,
	datDo DATE,
	opis VARCHAR ( 255 ) NOT NULL,
	pzusername VARCHAR ( 20 ) NOT NULL,
	discriminator VARCHAR ( 10 ) NOT NULL,
	CONSTRAINT PK_RabatnaPolitika68 PRIMARY KEY (idKomercijalnaPolitika)
	);
CREATE TABLE StavkaSheme (
	rBroj INTEGER NOT NULL,
	tipDok VARCHAR ( 40 ) NOT NULL,
	tipRJ VARCHAR ( 1 ) NOT NULL,
	podTipDok VARCHAR ( 40 ) NOT NULL,
	pTipRj VARCHAR ( 1 ) NOT NULL,
	ppTipRj VARCHAR ( 1 ) NOT NULL,
	oznRj VARCHAR ( 10 ) NOT NULL,
	oznOgranak VARCHAR ( 10 ) NOT NULL,
	oznKonto VARCHAR ( 6 ) NOT NULL,
	izraz VARCHAR ( 1000 ) NOT NULL,
	strana SMALLINT NOT NULL,
	indikator VARCHAR ( 1 ) NOT NULL,
	opis VARCHAR ( 255 ),
	tipAnalitike VARCHAR ( 10 ),
	nazivKonta VARCHAR ( 255 ) NOT NULL,
	uslov VARCHAR ( 1000 ),
	CONSTRAINT PK_ShemaRed815 PRIMARY KEY (tipDok, tipRJ, podTipDok, pTipRj, ppTipRj, oznRj, oznOgranak, rBroj)
	);
CREATE TABLE AOEM (
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	oem VARCHAR ( 40 ) NOT NULL,
	CONSTRAINT PK_AOEM23 PRIMARY KEY (oem, sfrProizvod)
	);
CREATE TABLE ArtikalParameter (
	idParameter VARCHAR ( 30 ) NOT NULL,
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	value VARCHAR ( 50 ) NOT NULL,
	CONSTRAINT PK_ArtikalParameter104 PRIMARY KEY (sfrProizvod, idParameter)
	);
CREATE TABLE TaksaInterniRacun (
	idDok INTEGER NOT NULL,
	oznTarGr VARCHAR ( 255 ) NOT NULL,
	tip VARCHAR ( 10 ) NOT NULL,
	vrsta VARCHAR ( 20 ) NOT NULL,
	osnovica DECIMAL ( 20, 2 ) NOT NULL,
	iznos DECIMAL ( 20, 2 ) NOT NULL,
	CONSTRAINT PK_TaksaInterniRacun43 PRIMARY KEY (oznTarGr, idDok, tip)
	);
CREATE TABLE ArtikalSlika (
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	fileName VARCHAR ( 100 ) NOT NULL,
	CONSTRAINT PK_ArtikalSlika16 PRIMARY KEY (fileName, sfrProizvod)
	);
CREATE TABLE UDTaksa (
	idDok INTEGER NOT NULL,
	rBroj INTEGER NOT NULL,
	oznTarGr VARCHAR ( 20 ) NOT NULL,
	stopa DOUBLE PRECISION NOT NULL,
	oznVrstaTG VARCHAR ( 20 ) NOT NULL,
	opis VARCHAR ( 255 ) NOT NULL,
	CONSTRAINT PK_UDTaksa52 PRIMARY KEY (idDok, rBroj, oznTarGr)
	);
CREATE TABLE Aop (
	oznaka VARCHAR ( 3 ) NOT NULL,
	izraz VARCHAR ( 255 ) NOT NULL,
	CONSTRAINT PK_AOP100 PRIMARY KEY (oznaka)
	);
CREATE TABLE ArtikalNivelacija (
	idDok INTEGER NOT NULL,
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	rBroj INTEGER NOT NULL,
	naziv VARCHAR ( 255 ) NOT NULL,
	bliziOpis VARCHAR ( 1000 ),
	jm VARCHAR ( 255 ) NOT NULL,
	kolicina DOUBLE PRECISION NOT NULL,
	cenaStara DOUBLE PRECISION NOT NULL,
	cenaNova DOUBLE PRECISION NOT NULL,
	vrednost DECIMAL ( 20, 2 ),
	sort INTEGER,
	CONSTRAINT PK_ArtikalNivelacija760 PRIMARY KEY (sfrProizvod, idDok, rBroj)
	);
CREATE TABLE Kalkulacija (
	idDok INTEGER NOT NULL,
	oznDokumenta VARCHAR ( 255 ),
	tip VARCHAR ( 45 ) NOT NULL,
	podTip VARCHAR ( 30 ),
	datum DATE NOT NULL,
	datFakture DATE NOT NULL,
	datDPO DATE NOT NULL,
	datArh DATE,
	datValute DATE NOT NULL,
	iznos DECIMAL ( 20, 2 ) DEFAULT 0,
	procRabata DOUBLE PRECISION NOT NULL,
	arhiviran SMALLINT NOT NULL,
	proknjizen SMALLINT NOT NULL,
	storno INTEGER,
	tipKalkulacije VARCHAR ( 255 ),
	trosakBezPdv DECIMAL ( 20, 2 ) DEFAULT 0,
	kurs DOUBLE PRECISION,
	sfrKomitent VARCHAR ( 255 ),
	oznRj VARCHAR ( 255 ),
	oznOgranak VARCHAR ( 255 ),
	usernamePoc VARCHAR ( 20 ) NOT NULL,
	usernameKraj VARCHAR ( 20 ) NOT NULL,
	original INTEGER,
	rBroj INTEGER,
	rbrDok INTEGER,
	pdv VARCHAR ( 255 ) NOT NULL,
	poruka VARCHAR ( 2000 ) NOT NULL,
	uplata DECIMAL ( 20, 2 ) DEFAULT 0,
	prodVrednost DECIMAL ( 20, 2 ) DEFAULT 0,
	cvProdajna SMALLINT NOT NULL,
	stornoIznos DECIMAL ( 20, 2 ) DEFAULT 0,
	ukupnoFakturisano DECIMAL ( 20, 2 ) DEFAULT 0,
	troskoviInterni DECIMAL ( 20, 2 ) DEFAULT 0,
	troskoviEksterni DECIMAL ( 20, 2 ) DEFAULT 0,
	troskoviCarina DECIMAL ( 20, 2 ) DEFAULT 0,
	vrednostRobe DECIMAL ( 20, 2 ) DEFAULT 0,
	nabavnaVrednost DECIMAL ( 20, 2 ) DEFAULT 0,
	razlUCeni DECIMAL ( 20, 2 ),
	zaokruzenje DECIMAL ( 20, 2 ),
	discriminator VARCHAR ( 30 ),
	osnovica DECIMAL ( 20, 2 ),
	bezPrava DECIMAL ( 20, 2 ),
	oslobodjeno DECIMAL ( 20, 2 ),
	idKalkulacija INTEGER,
	CONSTRAINT PK_Kalkulacija805 PRIMARY KEY (idDok)
	);
CREATE INDEX TC_Kalkulacija2039 ON Kalkulacija (sfrKomitent );
CREATE INDEX TC_Kalkulacija2040 ON Kalkulacija (usernameKraj );
CREATE INDEX TC_Kalkulacija2041 ON Kalkulacija (oznOgranak , oznRj );
CREATE TABLE TipTelefona (
	idTipTelefona INTEGER NOT NULL,
	naziv VARCHAR ( 50 ) NOT NULL,
	predefinisan SMALLINT NOT NULL,
	CONSTRAINT PK_TipTelefona36 PRIMARY KEY (idTipTelefona)
	);
CREATE TABLE TGKonto (
	vrsta VARCHAR ( 100 ) NOT NULL,
	oznKonto VARCHAR ( 6 ) NOT NULL,
	analitika VARCHAR ( 25 ) NOT NULL,
	oznTarGr VARCHAR ( 255 ) NOT NULL,
	CONSTRAINT PK_TGKonto4 PRIMARY KEY (oznTarGr, vrsta)
	);
CREATE TABLE BrojacRJ (
	oznOgranak VARCHAR ( 255 ) NOT NULL,
	oznRj VARCHAR ( 255 ) NOT NULL,
	rBroj INTEGER NOT NULL,
	tip VARCHAR ( 50 ) NOT NULL,
	arhiviran SMALLINT NOT NULL,
	version INTEGER NOT NULL,
	CONSTRAINT PK_Brojac788 PRIMARY KEY (oznOgranak, oznRj, tip, arhiviran)
	);
CREATE TABLE PzUser (
	pzusername VARCHAR ( 20 ) NOT NULL,
	password VARCHAR ( 20 ) NOT NULL,
	privilegije VARCHAR,
	oznMagacin VARCHAR ( 30 ),
	nadredjeni VARCHAR ( 20 ),
	idRadnoMesto INTEGER,
	status SMALLINT DEFAULT 1,
	CONSTRAINT PK_User750 PRIMARY KEY (pzusername)
	);
CREATE TABLE SifraKnjizenja (
	sfrSifKnjiz VARCHAR ( 255 ) NOT NULL,
	naziv VARCHAR ( 255 ) NOT NULL,
	CONSTRAINT PK_SifraKnjizenja743 PRIMARY KEY (sfrSifKnjiz)
	);
CREATE TABLE FakturaServisa (
	idDok INTEGER NOT NULL,
	vrednostUsluga DECIMAL ( 20, 2 ),
	sredstvoNaziv VARCHAR ( 255 ),
	sredstvoFabrickiBroj VARCHAR ( 100 ),
	sredstvoKarakteristika VARCHAR ( 255 ),
	CONSTRAINT PK_FakturaServisa40 PRIMARY KEY (idDok)
	);
CREATE TABLE Dislokacija (
	oznDislokacija VARCHAR ( 20 ) NOT NULL,
	tip VARCHAR ( 20 ) NOT NULL,
	naziv VARCHAR ( 50 ) NOT NULL,
	CONSTRAINT PK_Dislokacija96 PRIMARY KEY (oznDislokacija)
	);
CREATE TABLE UserNalogMagacinu (
	oznNalogMagacinu INTEGER NOT NULL,
	pzusername VARCHAR ( 20 ) NOT NULL,
	CONSTRAINT PK_UserNalogMagacinu38 PRIMARY KEY (pzusername, oznNalogMagacinu)
	);
CREATE TABLE RadnaJedinica (
	oznRj VARCHAR ( 255 ) NOT NULL,
	oznOgranak VARCHAR ( 255 ) NOT NULL,
	sfrKomitent VARCHAR ( 255 ),
	naziv VARCHAR ( 255 ) NOT NULL,
	mesto VARCHAR ( 255 ) NOT NULL,
	adresa VARCHAR ( 255 ) NOT NULL,
	grupaMagacina VARCHAR ( 255 ),
	gTip CHAR ( 1 ) NOT NULL,
	pTip CHAR ( 1 ),
	ppTip CHAR ( 1 ),
	nacinVodjenja VARCHAR ( 20 ) DEFAULT 'PRODAJNA',
	minusKolicine VARCHAR ( 20 ) DEFAULT 'ZABRANJEN',
	preuzimanjeSaKons SMALLINT DEFAULT 0,
	oznDislokacija VARCHAR ( 20 ),
	refOgranak VARCHAR ( 255 ),
	refRj VARCHAR ( 255 ),
	CONSTRAINT PK_RadnaJedinica744 PRIMARY KEY (oznOgranak, oznRj)
	);
CREATE INDEX TC_RadnaJedinica2027 ON RadnaJedinica (oznOgranak );
CREATE INDEX TC_RadnaJedinica2028 ON RadnaJedinica (sfrKomitent );
CREATE TABLE TarifnaGrupa (
	oznTarGr VARCHAR ( 255 ) NOT NULL,
	sfrTarGr VARCHAR ( 255 ),
	stopa DOUBLE PRECISION NOT NULL,
	uplRacun VARCHAR ( 255 ),
	grupaPDV VARCHAR ( 255 ),
	porezNaUsluge SMALLINT,
	oznVrstaTG VARCHAR ( 20 ) NOT NULL,
	CONSTRAINT PK_TarifnaGrupa739 PRIMARY KEY (oznTarGr)
	);
CREATE TABLE ArtikalFakturaParameter (
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	idDok INTEGER NOT NULL,
	rBroj INTEGER NOT NULL,
	name VARCHAR ( 20 ) NOT NULL,
	value VARCHAR NOT NULL,
	description VARCHAR ( 255 ),
	CONSTRAINT PK_ArtikalFakturaParameter98 PRIMARY KEY (sfrProizvod, idDok, rBroj, name)
	);
CREATE TABLE RadniNalog (
	oznRadniNalog VARCHAR ( 255 ) NOT NULL,
	datumOtvaranja DATE NOT NULL,
	status SMALLINT,
	opis VARCHAR ( 255 ),
	direktanRad DECIMAL ( 20, 2 ),
	direktanMaterijal DECIMAL ( 20, 2 ),
	indirektanRad DECIMAL ( 20, 2 ),
	indirektanMaterijal DECIMAL ( 20, 2 ),
	energija DECIMAL ( 20, 2 ),
	amortizacija DECIMAL ( 20, 2 ),
	ostalo DECIMAL ( 20, 2 ),
	sfrKomitent VARCHAR ( 20 ),
	CONSTRAINT PK_RadniNalog99 PRIMARY KEY (oznRadniNalog)
	);
CREATE TABLE OEBroj (
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	oem VARCHAR ( 50 ) NOT NULL,
	proizvodjac VARCHAR ( 50 ) NOT NULL,
	oemStripped VARCHAR ( 50 ) NOT NULL,
	CONSTRAINT PK_OEBroj62 PRIMARY KEY (sfrProizvod, oem, proizvodjac)
	);
CREATE TABLE Faktura (
	idDok INTEGER NOT NULL,
	oznDokumenta VARCHAR ( 255 ),
	datum DATE NOT NULL,
	datPrometa DATE,
	datValute DATE,
	datArh DATE,
	tip VARCHAR ( 255 ) NOT NULL,
	podTip VARCHAR ( 30 ),
	iznos DECIMAL ( 20, 2 ) DEFAULT 0,
	iznosBezPoreza DECIMAL ( 20, 2 ) DEFAULT 0,
	arhiviran SMALLINT NOT NULL,
	proknjizen SMALLINT NOT NULL,
	procRabata DOUBLE PRECISION,
	kurs DOUBLE PRECISION,
	rBroj INTEGER NOT NULL,
	rbrDok INTEGER NOT NULL,
	sfrKomitent VARCHAR ( 255 ),
	oznRj VARCHAR ( 255 ),
	oznOgranak VARCHAR ( 255 ),
	usernamePoc VARCHAR ( 20 ) NOT NULL,
	usernameKraj VARCHAR ( 20 ) NOT NULL,
	faktura INTEGER,
	storno INTEGER NOT NULL,
	uplata DECIMAL ( 20, 2 ) DEFAULT 0,
	poruka VARCHAR ( 5000 ),
	zaOtpremnice SMALLINT,
	zauzeto VARCHAR ( 100 ),
	saPorezom SMALLINT,
	saPravomNaOdbitak SMALLINT,
	robuIzdao VARCHAR ( 30 ),
	robuPrimio VARCHAR ( 30 ),
	licnaKarta VARCHAR ( 30 ),
	komercijalista VARCHAR ( 20 ),
	tekuciRacun VARCHAR ( 100 ),
	cvProdajna SMALLINT NOT NULL,
	rabatUkupno DECIMAL ( 20, 2 ) DEFAULT 0,
	nabavnaUkupno DECIMAL ( 20, 2 ) DEFAULT 0,
	stornoIznos DECIMAL ( 20, 2 ) DEFAULT 0,
	original INTEGER,
	nalogMagacinu VARCHAR ( 255 ),
	discriminator VARCHAR ( 100 ),
	vrednostRobe DECIMAL ( 20, 2 ),
	nacinOtpreme VARCHAR ( 255 ),
	potvrda VARCHAR ( 1000 ),
	pb VARCHAR ( 100 ),
	oznRadniNalog VARCHAR ( 255 ),
	vrednostUsluga DECIMAL ( 20, 2 ),
	vrednostPutTroskova DECIMAL ( 20, 2 ),
	CONSTRAINT PK_Faktura802 PRIMARY KEY (idDok)
	);
CREATE INDEX TC_Faktura2053 ON Faktura (oznOgranak , oznRj );
CREATE INDEX TC_Faktura2054 ON Faktura (sfrKomitent );
CREATE INDEX TC_Faktura2052 ON Faktura (usernameKraj );
CREATE TABLE ArtikalPorudzbina (
	idPoruzbine INTEGER NOT NULL,
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	rBroj INTEGER NOT NULL,
	naziv VARCHAR ( 255 ) NOT NULL,
	kolicina DECIMAL ( 20, 2 ) NOT NULL,
	cena DECIMAL ( 20, 2 ) NOT NULL,
	jm VARCHAR ( 255 ) NOT NULL,
	cenaFaktura DECIMAL ( 20, 2 ) NOT NULL,
	kolicinaFaktura DECIMAL ( 20, 2 ) NOT NULL,
	sfrProizvodFaktura VARCHAR ( 255 ),
	sort INTEGER,
	CONSTRAINT PK_ArtikalPorudzbina71 PRIMARY KEY (idPoruzbine, sfrProizvod, rBroj)
	);
CREATE TABLE ArtikalGarnitura (
	deo VARCHAR ( 255 ) NOT NULL,
	garnitura VARCHAR ( 255 ) NOT NULL,
	kolicina DOUBLE PRECISION NOT NULL,
	oznakaRj VARCHAR ( 255 ),
	CONSTRAINT PK_ArtikalGarnitura66 PRIMARY KEY (garnitura, deo)
	);
CREATE TABLE Usluga (
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	naziv VARCHAR ( 255 ) NOT NULL,
	cena DOUBLE PRECISION,
	brNormaSati DOUBLE PRECISION,
	CONSTRAINT PK_Usluga784 PRIMARY KEY (sfrProizvod)
	);
CREATE INDEX TC_Usluga2029 ON Usluga (sfrProizvod );
CREATE TABLE TaksaFiskalniRacun (
	idDok INTEGER NOT NULL,
	oznTarGr VARCHAR ( 255 ) NOT NULL,
	tip VARCHAR ( 30 ) NOT NULL,
	osnovica DECIMAL ( 20, 2 ) DEFAULT 0 NOT NULL,
	iznos DECIMAL ( 20, 2 ) DEFAULT 0 NOT NULL,
	vrsta VARCHAR ( 20 ) NOT NULL,
	CONSTRAINT PK_TaksaFiskalniRacun54 PRIMARY KEY (idDok, oznTarGr, tip)
	);
CREATE TABLE Log (
	oznLog INTEGER NOT NULL,
	time VARCHAR ( 255 ) NOT NULL,
	message VARCHAR ( 255 ) NOT NULL,
	pzusername VARCHAR ( 20 ) NOT NULL,
	CONSTRAINT PK_Log775 PRIMARY KEY (oznLog)
	);
CREATE INDEX TC_Log2038 ON Log (pzusername );
CREATE TABLE PrjMestoTroska (
	oznPrj VARCHAR ( 255 ) NOT NULL,
	oznMTroska VARCHAR ( 255 ) NOT NULL,
	naziv VARCHAR ( 255 ) NOT NULL,
	CONSTRAINT PK_PrjMestoTroska745 PRIMARY KEY (oznPrj, oznMTroska)
	);
CREATE TABLE EksternaSifra (
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	sfrKomitent VARCHAR ( 20 ) NOT NULL,
	sifra VARCHAR ( 30 ) NOT NULL,
	CONSTRAINT PK_EksternaSifra95 PRIMARY KEY (sfrKomitent, sfrProizvod)
	);
CREATE TABLE RobnaGrupa (
	oznRobGr VARCHAR ( 20 ) NOT NULL,
	naziv VARCHAR ( 255 ) NOT NULL,
	oznNadGrupa VARCHAR ( 20 ),
	CONSTRAINT PK_RobnaGrupa738 PRIMARY KEY (oznRobGr)
	);
CREATE TABLE ArtikalParameters (
	id INTEGER NOT NULL,
	sfrNumerik SMALLINT NOT NULL,
	lokVodiRacuna SMALLINT NOT NULL,
	kartPrikazOtpr SMALLINT NOT NULL,
	CONSTRAINT PK_ArtikalParameters789 PRIMARY KEY (id)
	);
CREATE TABLE ArtikalLista (
	idLista INTEGER NOT NULL,
	rBroj INTEGER NOT NULL,
	sfrProizvod VARCHAR ( 255 ),
	naziv VARCHAR ( 255 ),
	bliziOpis VARCHAR ( 1000 ),
	kolicina DOUBLE PRECISION,
	jm VARCHAR ( 10 ),
	cena DOUBLE PRECISION,
	dobSifra VARCHAR ( 30 ),
	prSifra VARCHAR ( 30 ),
	sfrDobavljac VARCHAR ( 30 ),
	nazivDobavljac VARCHAR ( 100 ),
	sfrProizvodjac VARCHAR ( 30 ),
	nazivProizvodjac VARCHAR ( 100 ),
	oznModel VARCHAR ( 30 ),
	nazivModel VARCHAR ( 100 ),
	oznRobGr VARCHAR ( 30 ),
	nazivRobGr VARCHAR ( 100 ),
	opis VARCHAR ( 5000 ),
	standPak DOUBLE PRECISION,
	stokMin DOUBLE PRECISION,
	stokMax DOUBLE PRECISION,
	stalaza VARCHAR ( 5 ),
	nivo VARCHAR ( 5 ),
	paleta VARCHAR ( 5 ),
	tip VARCHAR ( 30 ),
	tezina DOUBLE PRECISION,
	duzina DOUBLE PRECISION,
	sirina DOUBLE PRECISION,
	visina DOUBLE PRECISION,
	fi DOUBLE PRECISION,
	pomKolicina DOUBLE PRECISION,
	pomCena DOUBLE PRECISION,
	sort INTEGER,
	CONSTRAINT PK_ArtikalLista34 PRIMARY KEY (idLista, rBroj)
	);
CREATE TABLE TaksaTrosak (
	oznTarGr VARCHAR ( 255 ) NOT NULL,
	idDok INTEGER NOT NULL,
	vrsta VARCHAR ( 20 ) NOT NULL,
	osnovica DECIMAL ( 20, 2 ) NOT NULL,
	iznos DECIMAL ( 20, 2 ) NOT NULL,
	porezKodUvoza SMALLINT,
	CONSTRAINT PK_TaksaTrosak29 PRIMARY KEY (idDok, oznTarGr)
	);
CREATE TABLE StavkaKarticeArtikla (
	datum DATE NOT NULL,
	temelj VARCHAR ( 255 ) NOT NULL,
	ulaz DOUBLE PRECISION NOT NULL,
	izlaz DOUBLE PRECISION NOT NULL,
	stanje DOUBLE PRECISION NOT NULL,
	plCena DOUBLE PRECISION NOT NULL,
	duguje DOUBLE PRECISION NOT NULL,
	potrazuje DOUBLE PRECISION NOT NULL,
	saldo DOUBLE PRECISION NOT NULL,
	rBroj INTEGER NOT NULL,
	oznRj VARCHAR ( 255 ) NOT NULL,
	oznOgranak VARCHAR ( 255 ) NOT NULL,
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	CONSTRAINT PK_StavkaKarticeArtikla765 PRIMARY KEY (sfrProizvod, rBroj, oznOgranak, oznRj)
	);
CREATE INDEX TC_StavkaKarticeArtikla2061 ON StavkaKarticeArtikla (sfrProizvod );
CREATE INDEX TC_StavkaKarticeArtikla1989 ON StavkaKarticeArtikla (oznRj );
CREATE INDEX TC_StavkaKarticeArtikla2062 ON StavkaKarticeArtikla (oznOgranak , oznRj );
CREATE TABLE StavkaTrgovacka (
	rBroj INTEGER NOT NULL,
	datum DATE NOT NULL,
	opisKnjizenja VARCHAR ( 255 ) NOT NULL,
	zaduzenje DOUBLE PRECISION NOT NULL,
	razduzenje DOUBLE PRECISION NOT NULL,
	datUplate DATE NOT NULL,
	iznosUplate DOUBLE PRECISION NOT NULL,
	CONSTRAINT PK_StavkaTrgovacka771 PRIMARY KEY (rBroj)
	);
CREATE TABLE Lokacija (
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	oznOgranak VARCHAR ( 255 ) NOT NULL,
	oznRj VARCHAR ( 255 ) NOT NULL,
	stalaza VARCHAR ( 10 ) NOT NULL,
	nivo VARCHAR ( 10 ) NOT NULL,
	paleta VARCHAR ( 10 ) NOT NULL,
	CONSTRAINT PK_Lokacija787 PRIMARY KEY (sfrProizvod, oznOgranak, oznRj)
	);
CREATE TABLE Slika (
	fileName VARCHAR ( 100 ) NOT NULL,
	path VARCHAR ( 300 ),
	CONSTRAINT PK_Slika15 PRIMARY KEY (fileName)
	);
CREATE TABLE Nalepnica (
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	naziv VARCHAR ( 100 ) NOT NULL,
	bliziOpis VARCHAR ( 1000 ) NOT NULL,
	jedMere VARCHAR ( 5 ) NOT NULL,
	barKod VARCHAR ( 50 ),
	cena DECIMAL ( 20, 2 ),
	pomCena DECIMAL ( 20, 2 ),
	standPak DECIMAL ( 20, 2 ),
	adresa VARCHAR ( 30 ),
	brNalepnica INTEGER NOT NULL,
	proizvodjac VARCHAR ( 100 ),
	zemlja VARCHAR ( 50 ),
	uvoznik VARCHAR ( 50 ),
	distributer VARCHAR ( 50 ),
	CONSTRAINT PK_Nalepnica63 PRIMARY KEY (sfrProizvod)
	);
CREATE TABLE KomercijalnaPolitikaParam (
	idKomercijalnaPolitika INTEGER NOT NULL,
	naziv VARCHAR ( 20 ) NOT NULL,
	vrednost VARCHAR ( 255 ) NOT NULL,
	CONSTRAINT PK_RabatnaPolitikaParameter69 PRIMARY KEY (idKomercijalnaPolitika, naziv, vrednost)
	);
CREATE TABLE UFTaksa (
	idDok INTEGER NOT NULL,
	rBroj INTEGER NOT NULL,
	oznTarGr VARCHAR ( 10 ) NOT NULL,
	oznVrstaTG VARCHAR ( 10 ) NOT NULL,
	stopa DOUBLE PRECISION NOT NULL,
	opis VARCHAR ( 255 ),
	CONSTRAINT PK_UFTaksa42 PRIMARY KEY (idDok, rBroj, oznTarGr)
	);
CREATE TABLE ArtikalNalogPrijem (
	rBroj INTEGER NOT NULL,
	oznNalogPrijem INTEGER NOT NULL,
	adresa VARCHAR ( 255 ),
	barKod VARCHAR ( 255 ),
	jm VARCHAR ( 10 ) NOT NULL,
	katBroj VARCHAR ( 30 ),
	kolicina DOUBLE PRECISION NOT NULL,
	naziv VARCHAR ( 100 ) NOT NULL,
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	sort INTEGER,
	kbr VARCHAR ( 30 ),
	dat VARCHAR ( 20 ),
	CONSTRAINT PK_ArtikalNalogPrijem60 PRIMARY KEY (oznNalogPrijem, rBroj)
	);
CREATE TABLE Ogranak (
	oznOgranak VARCHAR ( 255 ) NOT NULL,
	naziv VARCHAR ( 255 ) NOT NULL,
	mesto VARCHAR ( 255 ) NOT NULL,
	adresa VARCHAR ( 255 ) NOT NULL,
	CONSTRAINT PK_Ogranak752 PRIMARY KEY (oznOgranak)
	);
CREATE TABLE StavkaKIR (
	datKnjizenja DATE NOT NULL,
	brDokumenta VARCHAR ( 255 ) NOT NULL,
	nazivKupca VARCHAR ( 255 ) NOT NULL,
	pib VARCHAR ( 255 ) NOT NULL,
	osnovicaPoOpstoj DOUBLE PRECISION NOT NULL,
	osnovicaPoPosebnoj DOUBLE PRECISION NOT NULL,
	pdvPoOpstoj DOUBLE PRECISION NOT NULL,
	pdvPoPosebnoj DOUBLE PRECISION NOT NULL,
	rBroj INTEGER NOT NULL,
	CONSTRAINT PK_StavkaKIR769 PRIMARY KEY (rBroj)
	);
CREATE TABLE PutniTrosak (
	idDok INTEGER NOT NULL,
	idPutniTrosak INTEGER NOT NULL,
	relacija VARCHAR ( 255 ) NOT NULL,
	kmTamo DECIMAL ( 20, 2 ),
	kmOvamo DECIMAL ( 20, 2 ),
	litarGoriva DECIMAL ( 20, 2 ),
	potrosnjaNa100 DECIMAL ( 20, 2 ),
	vrednost DECIMAL ( 20, 2 ),
	datum DATE NOT NULL,
	CONSTRAINT PK_PutniTrosak28 PRIMARY KEY (idDok, idPutniTrosak)
	);
CREATE TABLE AmortGrupa (
	oznAmortGrupa VARCHAR ( 20 ) NOT NULL,
	naziv VARCHAR ( 50 ) NOT NULL,
	procAmort DECIMAL ( 20, 2 ) NOT NULL,
	procAmortPP DECIMAL ( 20, 2 ),
	vek INTEGER,
	CONSTRAINT TC_AmortGrupa508 UNIQUE (oznAmortGrupa),
	CONSTRAINT PK_AmortGrupa102 PRIMARY KEY (oznAmortGrupa)
	);
CREATE TABLE OEM (
	oem VARCHAR ( 40 ) NOT NULL,
	original VARCHAR ( 255 ) NOT NULL,
	CONSTRAINT PK_OEM801 PRIMARY KEY (oem)
	);
CREATE TABLE ArtikalKalkulacija (
	idDok INTEGER NOT NULL,
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	rBroj INTEGER NOT NULL,
	naziv VARCHAR ( 255 ) NOT NULL,
	bliziOpis VARCHAR ( 1000 ),
	jm VARCHAR ( 255 ) NOT NULL,
	kolicina DOUBLE PRECISION NOT NULL,
	procMarze DOUBLE PRECISION NOT NULL,
	procRabata DOUBLE PRECISION NOT NULL,
	nabCena DOUBLE PRECISION NOT NULL,
	prodCena DECIMAL ( 20, 2 ) NOT NULL,
	zavTroskovi DOUBLE PRECISION NOT NULL,
	prosNabCena DECIMAL ( 20, 4 ),
	fakturnaCena DOUBLE PRECISION NOT NULL,
	dobSifra VARCHAR ( 30 ),
	sort INTEGER,
	CONSTRAINT PK_ArtikalKalkulacija755 PRIMARY KEY (sfrProizvod, idDok, rBroj)
	);
CREATE TABLE RabatnaSkala (
	oznRabatnaSkala INTEGER NOT NULL,
	oznRobGr VARCHAR ( 20 ),
	sfrKomitent VARCHAR ( 20 ),
	sfrProizvod VARCHAR ( 255 ),
	procenat DOUBLE PRECISION NOT NULL,
	zakljucan boolean DEFAULT false,
	CONSTRAINT PK_RabatnaSkala774 PRIMARY KEY (oznRabatnaSkala)
	);
CREATE INDEX TC_RabatnaSkala2031 ON RabatnaSkala (sfrProizvod );
CREATE INDEX TC_RabatnaSkala2033 ON RabatnaSkala (oznRobGr );
CREATE INDEX TC_RabatnaSkala2032 ON RabatnaSkala (sfrKomitent );
CREATE TABLE DokTipParameter (
	tip VARCHAR ( 50 ) NOT NULL,
	naziv VARCHAR ( 30 ) NOT NULL,
	vrednost VARCHAR NOT NULL,
	CONSTRAINT PK_DokTipParameter86 PRIMARY KEY (tip, naziv)
	);
CREATE TABLE Parameter (
	name VARCHAR ( 40 ) NOT NULL,
	value VARCHAR ( 255 ) NOT NULL,
	CONSTRAINT PK_Parameter17 PRIMARY KEY (name)
	);
CREATE TABLE StavkaKarticeKomitenta (
	nalog INTEGER NOT NULL,
	datum DATE NOT NULL,
	brDokumenta VARCHAR ( 255 ) NOT NULL,
	duguje DOUBLE PRECISION NOT NULL,
	potrazuje DOUBLE PRECISION NOT NULL,
	saldo DOUBLE PRECISION NOT NULL,
	rBroj INTEGER NOT NULL,
	sfrKomitent VARCHAR ( 20 ) NOT NULL,
	CONSTRAINT PK_StavkaKarticeKomitenta766 PRIMARY KEY (sfrKomitent, rBroj)
	);
CREATE INDEX TC_StavkaKarticeKomitenta2064 ON StavkaKarticeKomitenta (sfrKomitent );
CREATE TABLE KomitentGrupaLink (
	sfrKomitent VARCHAR ( 20 ) NOT NULL,
	idKomitentGrupa INTEGER NOT NULL,
	CONSTRAINT PK_KomitentGrupaLink88 PRIMARY KEY (idKomitentGrupa, sfrKomitent)
	);
CREATE TABLE Telefon (
	brojTelefona VARCHAR ( 25 ) NOT NULL,
	idTipTelefona INTEGER NOT NULL,
	sfrKomitent VARCHAR ( 20 ),
	pzusername VARCHAR ( 20 ),
	CONSTRAINT PK_Telefon37 PRIMARY KEY (brojTelefona)
	);
CREATE TABLE DokumentParameter (
	tipDok VARCHAR ( 50 ) NOT NULL,
	tipParam VARCHAR ( 30 ) NOT NULL,
	vrednost VARCHAR NOT NULL,
	CONSTRAINT PK_DokumentParameter81 PRIMARY KEY (tipDok, tipParam)
	);
CREATE TABLE TGArtikal (
	oznTarGr VARCHAR ( 255 ) NOT NULL,
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	CONSTRAINT PK_Taksa5 PRIMARY KEY (sfrProizvod, oznTarGr)
	);
CREATE TABLE Model (
	oznModel VARCHAR ( 255 ) NOT NULL,
	naziv VARCHAR ( 255 ) NOT NULL,
	CONSTRAINT PK_Model741 PRIMARY KEY (oznModel)
	);
CREATE TABLE Nivelacija (
	idDok INTEGER NOT NULL,
	oznDokumenta VARCHAR ( 30 ),
	tip VARCHAR ( 40 ) NOT NULL,
	podTip VARCHAR ( 30 ),
	datum DATE NOT NULL,
	datArh DATE,
	novaVrednost DECIMAL ( 20, 2 ) DEFAULT 0,
	staraVrednost DECIMAL ( 20, 2 ) DEFAULT 0,
	arhiviran SMALLINT NOT NULL,
	proknjizen SMALLINT NOT NULL,
	oznRj VARCHAR ( 255 ) NOT NULL,
	oznOgranak VARCHAR ( 255 ) NOT NULL,
	usernamePoc VARCHAR ( 20 ) NOT NULL,
	usernameKraj VARCHAR ( 20 ) NOT NULL,
	rBroj INTEGER NOT NULL,
	rbrDok INTEGER NOT NULL,
	cvProdajna SMALLINT NOT NULL,
	poruka VARCHAR ( 5000 ),
	poDok INTEGER,
	CONSTRAINT PK_Nivelacija806 PRIMARY KEY (idDok)
	);
CREATE INDEX TC_Nivelacija2049 ON Nivelacija (oznOgranak , oznRj );
CREATE INDEX TC_Nivelacija2050 ON Nivelacija (usernameKraj );
CREATE TABLE ShemaNasledjuje (
	nadTipDok VARCHAR ( 40 ) NOT NULL,
	nadTipRJ VARCHAR ( 1 ) NOT NULL,
	nadPodTipDok VARCHAR ( 40 ) NOT NULL,
	nadPTipRj VARCHAR ( 1 ) NOT NULL,
	nadPpTipRj VARCHAR ( 1 ) NOT NULL,
	nadOznRj VARCHAR ( 10 ) NOT NULL,
	nadOznOgranak VARCHAR ( 10 ) NOT NULL,
	tipDok VARCHAR ( 40 ) NOT NULL,
	tipRJ VARCHAR ( 1 ) NOT NULL,
	podTipDok VARCHAR ( 40 ) NOT NULL,
	pTipRj VARCHAR ( 1 ) NOT NULL,
	ppTipRj VARCHAR ( 1 ) NOT NULL,
	oznRj VARCHAR ( 10 ) NOT NULL,
	oznOgranak VARCHAR ( 10 ) NOT NULL,
	CONSTRAINT PK_nasledjuje49 PRIMARY KEY (tipDok, tipRJ, podTipDok, pTipRj, ppTipRj, oznRj, oznOgranak, nadTipDok, nadTipRJ, nadPodTipDok, nadPTipRj, nadPpTipRj, nadOznRj, nadOznOgranak)
	);
CREATE TABLE TaksaNivelacija (
	idDok INTEGER NOT NULL,
	oznTarGr VARCHAR ( 255 ) NOT NULL,
	tip VARCHAR ( 10 ) NOT NULL,
	vrsta VARCHAR ( 20 ) NOT NULL,
	osnovica DOUBLE PRECISION NOT NULL,
	iznos DOUBLE PRECISION NOT NULL,
	CONSTRAINT PK_TaksaNivelacija44 PRIMARY KEY (oznTarGr, idDok, tip)
	);
CREATE TABLE TaksaFaktura (
	oznTarGr VARCHAR ( 255 ) NOT NULL,
	idDok INTEGER NOT NULL,
	tip VARCHAR ( 30 ) NOT NULL,
	osnovica DECIMAL ( 20, 2 ) DEFAULT 0 NOT NULL,
	iznos DECIMAL ( 20, 2 ) DEFAULT 0 NOT NULL,
	vrsta VARCHAR ( 20 ) NOT NULL,
	CONSTRAINT PK_PDVFaktura817 PRIMARY KEY (oznTarGr, idDok, tip)
	);
CREATE TABLE TaksaKalkulacija (
	idDok INTEGER NOT NULL,
	oznTarGr VARCHAR ( 255 ) NOT NULL,
	tip VARCHAR ( 10 ) NOT NULL,
	vrsta VARCHAR ( 20 ) NOT NULL,
	iznos DECIMAL ( 20, 2 ) NOT NULL,
	osnovica DECIMAL ( 20, 2 ) NOT NULL,
	porezKodUvoza SMALLINT,
	CONSTRAINT PK_PDVKalkulacija776 PRIMARY KEY (idDok, oznTarGr, tip)
	);
CREATE INDEX TC_PDVKalkulacija1957 ON TaksaKalkulacija (oznTarGr );
CREATE TABLE Email (
	adresa VARCHAR ( 100 ) NOT NULL,
	idTipEmaila INTEGER NOT NULL,
	sfrKomitent VARCHAR ( 20 ),
	pzusername VARCHAR ( 20 ),
	CONSTRAINT PK_Email83 PRIMARY KEY (adresa)
	);
CREATE TABLE Rabat (
	id INTEGER NOT NULL,
	naziv VARCHAR ( 30 ) NOT NULL,
	procenat DOUBLE PRECISION,
	CONSTRAINT PK_Rabat97 PRIMARY KEY (id)
	);
CREATE TABLE Settings (
	pzusername VARCHAR ( 20 ) NOT NULL,
	class VARCHAR ( 300 ) NOT NULL,
	component VARCHAR ( 200 ) NOT NULL,
	parameter VARCHAR ( 100 ) NOT NULL,
	value VARCHAR ( 300 ) NOT NULL,
	CONSTRAINT PK_Settings30 PRIMARY KEY (pzusername, class, component, parameter)
	);
CREATE TABLE ArtikalFaktura (
	idDok INTEGER NOT NULL,
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	rBroj INTEGER NOT NULL,
	naziv VARCHAR ( 255 ) NOT NULL,
	bliziOpis VARCHAR ( 1000 ),
	jm VARCHAR ( 255 ) NOT NULL,
	kolicina DOUBLE PRECISION NOT NULL,
	cena DOUBLE PRECISION NOT NULL,
	procRabata DOUBLE PRECISION NOT NULL,
	tezina DOUBLE PRECISION NOT NULL,
	dobSifra VARCHAR ( 255 ),
	saOtpremnice VARCHAR ( 255 ),
	prosNabCena DECIMAL ( 20, 4 ),
	konsignacija VARCHAR ( 255 ),
	kolSaKons DOUBLE PRECISION,
	nabCena DOUBLE PRECISION,
	prodCena DECIMAL ( 20, 2 ),
	indk SMALLINT,
	indp SMALLINT,
	sort INTEGER,
	CONSTRAINT PK_ArtikalFaktura762 PRIMARY KEY (sfrProizvod, idDok, rBroj)
	);
CREATE TABLE TaksaKZ (
	kalkulacija INTEGER NOT NULL,
	oznTarGr VARCHAR ( 255 ) NOT NULL,
	vrsta VARCHAR ( 20 ) NOT NULL,
	osnovica DECIMAL ( 20, 2 ) NOT NULL,
	iznos DECIMAL ( 20, 2 ) NOT NULL,
	zapisnik INTEGER NOT NULL,
	CONSTRAINT PK_TaksaKZ48 PRIMARY KEY (oznTarGr, zapisnik, kalkulacija)
	);
CREATE TABLE StavkaKPR (
	datKnjizenja DATE NOT NULL,
	brDokumenta VARCHAR ( 255 ) NOT NULL,
	nazivDobavljaca VARCHAR ( 255 ) NOT NULL,
	pib VARCHAR ( 255 ) NOT NULL,
	nabavkeVanPDV DOUBLE PRECISION NOT NULL,
	pdvOsnovica DOUBLE PRECISION NOT NULL,
	pdvIznos DOUBLE PRECISION NOT NULL,
	rBroj INTEGER NOT NULL,
	CONSTRAINT PK_StavkaKPR770 PRIMARY KEY (rBroj)
	);
CREATE TABLE Artikal (
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	naziv VARCHAR ( 255 ) NOT NULL,
	bliziOpis VARCHAR ( 1000 ),
	jedMere VARCHAR ( 255 ) NOT NULL,
	opis VARCHAR ( 5000 ),
	tip VARCHAR ( 255 ),
	barKod VARCHAR ( 255 ),
	dobSifra VARCHAR ( 255 ),
	prSifra VARCHAR ( 30 ),
	standPak DOUBLE PRECISION,
	standPakIzlaz DOUBLE PRECISION,
	tezina DOUBLE PRECISION,
	procKala DOUBLE PRECISION,
	robPodGrupa VARCHAR ( 255 ),
	oznRobGr VARCHAR ( 20 ),
	dobavljac VARCHAR ( 20 ),
	proizvodjac VARCHAR ( 20 ),
	oznModel VARCHAR ( 255 ),
	oznAmbalaza VARCHAR ( 255 ),
	cenaPlanska DOUBLE PRECISION,
	cenaPoeni DOUBLE PRECISION,
	cenaBazna DOUBLE PRECISION,
	katBroj VARCHAR ( 30 ),
	duzina DOUBLE PRECISION,
	sirina DOUBLE PRECISION,
	visina DOUBLE PRECISION,
	fi DOUBLE PRECISION,
	oznOgranak VARCHAR ( 255 ),
	oznRj VARCHAR ( 255 ),
	stokMin DOUBLE PRECISION,
	stokMax DOUBLE PRECISION,
	status SMALLINT DEFAULT 1 NOT NULL,
	garnitura SMALLINT DEFAULT 0 NOT NULL,
	datDodavanja DATE,
	datDeaktivacije DATE,
	sfrSort VARCHAR ( 255 ),
	discriminator INTEGER DEFAULT 0 NOT NULL,
	amortGrupa VARCHAR ( 20 ),
	poreskaGrupa VARCHAR ( 20 ),
	idRacunopolagac INTEGER,
	CONSTRAINT PK_Artikal783 PRIMARY KEY (sfrProizvod)
	);
CREATE INDEX TC_Artikal2017 ON Artikal (sfrProizvod );
CREATE INDEX TC_Artikal2015 ON Artikal (oznRobGr );
CREATE INDEX TC_Artikal2019 ON Artikal (proizvodjac );
CREATE INDEX TC_Artikal2016 ON Artikal (oznAmbalaza );
CREATE INDEX TC_Artikal2013 ON Artikal (dobavljac );
CREATE INDEX TC_Artikal2018 ON Artikal (oznModel );
CREATE TABLE AFTaksa (
	idDok INTEGER NOT NULL,
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	rBroj INTEGER NOT NULL,
	oznTarGr VARCHAR ( 20 ) NOT NULL,
	oznVrstaTG VARCHAR ( 20 ) NOT NULL,
	stopa DOUBLE PRECISION NOT NULL,
	opis VARCHAR ( 100 ) NOT NULL,
	CONSTRAINT PK_AFTaksa7 PRIMARY KEY (sfrProizvod, idDok, rBroj, oznTarGr)
	);
CREATE TABLE StandardnaPoruka (
	oznPoruka INTEGER NOT NULL,
	naziv VARCHAR ( 100 ) NOT NULL,
	sadrzaj VARCHAR NOT NULL,
	tipDokumenta VARCHAR ( 30 ),
	uslov VARCHAR ( 1000 ),
	CONSTRAINT PK_StandardnaPoruka816 PRIMARY KEY (oznPoruka)
	);
CREATE TABLE TekuciRacun (
	brRacuna VARCHAR ( 255 ) NOT NULL,
	banka VARCHAR ( 255 ) NOT NULL,
	sfrKomitent VARCHAR ( 20 ),
	oznFirma INTEGER,
	podrazumevani SMALLINT DEFAULT 0 NOT NULL,
	CONSTRAINT PK_TekuciRacun751 PRIMARY KEY (brRacuna)
	);
CREATE INDEX TC_TekuciRacun2037 ON TekuciRacun (sfrKomitent );
CREATE INDEX TC_TekuciRacun2036 ON TekuciRacun (oznFirma );
CREATE TABLE AODTaksa (
	idDok INTEGER NOT NULL,
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	rBroj INTEGER NOT NULL,
	oznTarGr VARCHAR ( 20 ) NOT NULL,
	oznVrstaTG VARCHAR ( 20 ) NOT NULL,
	stopa DOUBLE PRECISION NOT NULL,
	opis VARCHAR ( 100 ) NOT NULL,
	CONSTRAINT PK_AODTaksa21 PRIMARY KEY (idDok, sfrProizvod, rBroj, oznTarGr)
	);
CREATE TABLE NZK (
	idNalog INTEGER NOT NULL,
	pzusername VARCHAR ( 20 ) NOT NULL,
	datum DATE,
	arhiviran SMALLINT NOT NULL,
	duguje DECIMAL ( 20, 2 ) NOT NULL,
	potrazuje DECIMAL ( 20, 2 ) NOT NULL,
	brojac INTEGER NOT NULL,
	brSheme INTEGER NOT NULL,
	oznOgranak VARCHAR ( 255 ),
	oznRj VARCHAR ( 255 ),
	CONSTRAINT PK_NZK812 PRIMARY KEY (idNalog)
	);
CREATE TABLE KondGrupa (
	idKondGrupa INTEGER NOT NULL,
	uslov VARCHAR NOT NULL,
	tip VARCHAR ( 30 ) NOT NULL,
	naziv VARCHAR ( 255 ) NOT NULL,
	CONSTRAINT PK_KondGrupaArtikal67 PRIMARY KEY (idKondGrupa)
	);
CREATE TABLE TaksaFOD (
	oznTarGr VARCHAR ( 255 ) NOT NULL,
	faktura INTEGER NOT NULL,
	opstiDokument INTEGER NOT NULL,
	vrsta VARCHAR ( 20 ) NOT NULL,
	osnovica DECIMAL ( 20, 2 ) NOT NULL,
	iznos DECIMAL ( 20, 2 ) NOT NULL,
	CONSTRAINT PK_TaksaFOD46 PRIMARY KEY (oznTarGr, faktura, opstiDokument)
	);
CREATE TABLE UkalkulisaniPDV (
	idPdv INTEGER NOT NULL,
	idDok INTEGER,
	visaOsnovica DECIMAL ( 20, 2 ) NOT NULL,
	nizaOsnovica DECIMAL ( 20, 2 ) NOT NULL,
	visaPdv DECIMAL ( 20, 2 ) NOT NULL,
	nizaPdv DECIMAL ( 20, 2 ) NOT NULL,
	neoporezivo DECIMAL ( 20, 2 ) NOT NULL,
	obrisan SMALLINT NOT NULL,
	datum DATE,
	oznDokumenta VARCHAR ( 50 ),
	sfrKomitent VARCHAR ( 20 ),
	oznOgranak VARCHAR ( 255 ),
	oznRj VARCHAR ( 255 ),
	opis VARCHAR ( 255 ),
	CONSTRAINT TC_UkalkulisaniPDV535 UNIQUE (idDok),
	CONSTRAINT PK_UkalkulisaniPDV106 PRIMARY KEY (idPdv)
	);
CREATE TABLE Konsignacija (
	idDok INTEGER NOT NULL,
	oznDokumenta VARCHAR ( 255 ),
	tip VARCHAR ( 255 ) NOT NULL,
	podTip VARCHAR ( 30 ),
	datum DATE,
	datArh DATE,
	iznosSaPorezom DECIMAL ( 20, 2 ) DEFAULT 0,
	procRabata DOUBLE PRECISION NOT NULL,
	arhiviran SMALLINT NOT NULL,
	proknjizen SMALLINT NOT NULL,
	storno INTEGER NOT NULL,
	iznosBezPoreza DECIMAL ( 20, 2 ) DEFAULT 0,
	pdvIznos DECIMAL ( 20, 2 ) DEFAULT 0,
	rjUlaz VARCHAR ( 255 ) NOT NULL,
	rBroj INTEGER NOT NULL,
	rbrDok INTEGER NOT NULL,
	poruka VARCHAR ( 5000 ),
	cvProdajna SMALLINT,
	usernamePoc VARCHAR ( 20 ) NOT NULL,
	usernameKraj VARCHAR ( 20 ) NOT NULL,
	oznOgranak VARCHAR ( 255 ) NOT NULL,
	oznRj VARCHAR ( 255 ) NOT NULL,
	stornoIznos DECIMAL ( 20, 2 ) DEFAULT 0,
	CONSTRAINT PK_Konsignacija810 PRIMARY KEY (idDok)
	);
CREATE TABLE Valuta (
	oznValuta VARCHAR ( 10 ) NOT NULL,
	kodValuta INTEGER,
	naziv VARCHAR ( 100 ),
	zemlja VARCHAR ( 100 ),
	auto SMALLINT DEFAULT 0 NOT NULL,
	CONSTRAINT PK_Valuta90 PRIMARY KEY (oznValuta)
	);
CREATE TABLE DokumentLog (
	idLog INTEGER NOT NULL,
	idDok INTEGER NOT NULL,
	pzusername VARCHAR ( 20 ) NOT NULL,
	vrsta INTEGER NOT NULL,
	opis VARCHAR ( 1000 ) NOT NULL,
	vreme TIMESTAMP NOT NULL,
	CONSTRAINT PK_DokumentLog101 PRIMARY KEY (idLog),
	CONSTRAINT TC_DokumentLog498 UNIQUE (idLog)
	);
CREATE TABLE Dozvola (
	pzusername VARCHAR ( 20 ) NOT NULL,
	tip VARCHAR ( 20 ) NOT NULL,
	opcija VARCHAR ( 300 ) NOT NULL,
	CONSTRAINT PK_Dozvola91 PRIMARY KEY (pzusername, tip, opcija)
	);
CREATE TABLE FizickoLice (
	idDok INTEGER NOT NULL,
	imePrezime VARCHAR ( 100 ),
	adresa VARCHAR ( 100 ),
	mesto VARCHAR ( 100 ),
	jmbg CHAR ( 13 ),
	CONSTRAINT PK_FizickoLice65 PRIMARY KEY (idDok)
	);
CREATE TABLE Zahtev (
	idZahteva INTEGER NOT NULL,
	idPoruzbine INTEGER NOT NULL,
	napomena VARCHAR ( 1000 ),
	CONSTRAINT PK_Zahtev73 PRIMARY KEY (idPoruzbine, idZahteva)
	);
CREATE TABLE OpstiDokument (
	idDok INTEGER NOT NULL,
	oznDokumenta VARCHAR ( 255 ),
	tip VARCHAR ( 255 ) NOT NULL,
	podTip VARCHAR ( 30 ),
	datum DATE,
	datValute DATE,
	datArh DATE,
	iznosSaPorezom DECIMAL ( 20, 2 ) DEFAULT 0,
	procRabata DOUBLE PRECISION,
	arhiviran SMALLINT NOT NULL,
	proknjizen SMALLINT NOT NULL,
	storno INTEGER NOT NULL,
	iznosBezPoreza DECIMAL ( 20, 2 ) DEFAULT 0,
	pdvIznos DECIMAL ( 20, 2 ),
	rjUlaz VARCHAR ( 255 ),
	poruka VARCHAR ( 5000 ),
	cvProdajna SMALLINT NOT NULL,
	usernamePoc VARCHAR ( 20 ) NOT NULL,
	usernameKraj VARCHAR ( 20 ) NOT NULL,
	oznOgranak VARCHAR ( 255 ),
	oznRj VARCHAR ( 255 ),
	sfrKomitent VARCHAR ( 255 ),
	original INTEGER,
	rBroj INTEGER NOT NULL,
	rbrDok INTEGER NOT NULL,
	stornoIznos DECIMAL ( 20, 2 ) DEFAULT 0,
	dbl1 DECIMAL ( 20, 2 ) DEFAULT 0,
	dbl2 DECIMAL ( 20, 2 ) DEFAULT 0,
	dbl3 DECIMAL ( 20, 2 ) DEFAULT 0,
	dbl4 DECIMAL ( 20, 2 ) DEFAULT 0,
	dbl5 DECIMAL ( 20, 2 ) DEFAULT 0,
	dbl6 DECIMAL ( 20, 2 ) DEFAULT 0,
	dbl7 DECIMAL ( 20, 2 ) DEFAULT 0,
	dbl8 DECIMAL ( 20, 2 ) DEFAULT 0,
	dbl9 DECIMAL ( 20, 2 ) DEFAULT 0,
	dbl10 DECIMAL ( 20, 2 ) DEFAULT 0,
	str1 VARCHAR ( 255 ),
	str2 VARCHAR ( 255 ),
	str3 VARCHAR ( 255 ),
	int1 INTEGER,
	int2 INTEGER,
	discriminator VARCHAR ( 255 ),
	date1 DATE,
	date2 DATE,
	date3 DATE,
	vrednostRobe DECIMAL ( 20, 2 ),
	vrednostUsluga DECIMAL ( 20, 2 ),
	oznPrj VARCHAR ( 255 ),
	oznMTroska VARCHAR ( 255 ),
	oznRadniNalog VARCHAR ( 255 ),
	CONSTRAINT PK_OstalaDokumenta22 PRIMARY KEY (idDok)
	);
CREATE TABLE UslugaFaktura (
	idDok INTEGER NOT NULL,
	rBroj INTEGER NOT NULL,
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	naziv VARCHAR ( 255 ) NOT NULL,
	kolicina DOUBLE PRECISION NOT NULL,
	cena DOUBLE PRECISION NOT NULL,
	sort INTEGER,
	CONSTRAINT PK_UslugaFakturaServisa41 PRIMARY KEY (idDok, rBroj)
	);
CREATE TABLE TGUsluga (
	sfrProizvod VARCHAR ( 255 ) NOT NULL,
	oznTarGr VARCHAR ( 255 ) NOT NULL,
	CONSTRAINT PK_TaksaUsluga8 PRIMARY KEY (oznTarGr, sfrProizvod)
	);
ALTER TABLE Dozvola ADD CONSTRAINT FK_Dozvola205 FOREIGN KEY (pzusername) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Zahtev ADD CONSTRAINT FK_Zahtev174 FOREIGN KEY (idPoruzbine) REFERENCES Porudzbina (idPoruzbine)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE BrojacRJ ADD CONSTRAINT FK_Brojac946 FOREIGN KEY (oznOgranak, oznRj) REFERENCES RadnaJedinica (oznOgranak, oznRj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE AIRTaksa ADD CONSTRAINT FK_AIRTaksa33 FOREIGN KEY (sfrProizvod, idDok, rBroj) REFERENCES ArtikalInterniRacun (sfrProizvod, idDok, rBroj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE PDVObracun ADD CONSTRAINT FK_PDVObracun925 FOREIGN KEY (pzusername) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Zamena ADD CONSTRAINT FK_Zamena955 FOREIGN KEY (artikal) REFERENCES Artikal (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Zamena ADD CONSTRAINT FK_Zamena956 FOREIGN KEY (zamena) REFERENCES Artikal (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Blagajna ADD CONSTRAINT FK_Blagajna901 FOREIGN KEY (oznKonto, analitika) REFERENCES Konto (oznKonto, analitika)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE EksternaSifra ADD CONSTRAINT FK_EksternaSifra211 FOREIGN KEY (sfrProizvod) REFERENCES Artikal (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE EksternaSifra ADD CONSTRAINT FK_EksternaSifra212 FOREIGN KEY (sfrKomitent) REFERENCES Komitent (sfrKomitent)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE FizickoLice ADD CONSTRAINT FK_FizickoLice152 FOREIGN KEY (idDok) REFERENCES Faktura (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalSlika ADD CONSTRAINT FK_ArtikalSlika43 FOREIGN KEY (sfrProizvod) REFERENCES Artikal (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalSlika ADD CONSTRAINT FK_ArtikalSlika44 FOREIGN KEY (fileName) REFERENCES Slika (fileName)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE TaksaInterniRacun ADD CONSTRAINT FK_TaksaInterniRacun111 FOREIGN KEY (idDok) REFERENCES InterniRacun (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE TaksaInterniRacun ADD CONSTRAINT FK_TaksaInterniRacun112 FOREIGN KEY (oznTarGr) REFERENCES TarifnaGrupa (oznTarGr)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE InterniRacun ADD CONSTRAINT FK_InterniRacun3 FOREIGN KEY (idDok) REFERENCES Dokument (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE InterniRacun ADD CONSTRAINT FK_InterniRacun921 FOREIGN KEY (usernameKraj) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE InterniRacun ADD CONSTRAINT FK_InterniRacun911 FOREIGN KEY (ulazniOgranak, ulaznaRJ) REFERENCES RadnaJedinica (oznOgranak, oznRj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE InterniRacun ADD CONSTRAINT FK_InterniRacun912 FOREIGN KEY (izlazniOgranak, izlaznaRJ) REFERENCES RadnaJedinica (oznOgranak, oznRj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE InterniRacun ADD CONSTRAINT FK_InterniRacun75 FOREIGN KEY (usernamePoc) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE InterniRacun ADD CONSTRAINT FK_InterniRacun7 FOREIGN KEY (idDok1) REFERENCES Dokument (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE KomitentGrupa ADD CONSTRAINT FK_KomitentGrupa197 FOREIGN KEY (pzusername) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE RadniNalog ADD CONSTRAINT FK_RadniNalog233 FOREIGN KEY (sfrKomitent) REFERENCES Komitent (sfrKomitent)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE PFRTaksa ADD CONSTRAINT FK_PFRTaksa137 FOREIGN KEY (idDok, sfrProizvod, rBroj) REFERENCES ProizvodFiskalniRacun (idDok, sfrProizvod, rBroj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE UkalkulisaniPDV ADD CONSTRAINT FK_UkalkulisaniPDV239 FOREIGN KEY (idDok) REFERENCES Dokument (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE UkalkulisaniPDV ADD CONSTRAINT FK_UkalkulisaniPDV240 FOREIGN KEY (sfrKomitent) REFERENCES Komitent (sfrKomitent)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE UkalkulisaniPDV ADD CONSTRAINT FK_UkalkulisaniPDV241 FOREIGN KEY (oznOgranak, oznRj) REFERENCES RadnaJedinica (oznOgranak, oznRj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE NZK ADD CONSTRAINT FK_NZK103 FOREIGN KEY (oznOgranak, oznRj) REFERENCES RadnaJedinica (oznOgranak, oznRj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE NZK ADD CONSTRAINT FK_NZK12 FOREIGN KEY (pzusername) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalOpstiDokument ADD CONSTRAINT FK_ArtikalOstaliDokumenti52 FOREIGN KEY (idDok) REFERENCES OpstiDokument (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalOpstiDokument ADD CONSTRAINT FK_ArtikalOpstiDokument69 FOREIGN KEY (par_idDok, par_sfrProizvod, par_rBroj) REFERENCES ArtikalOpstiDokument (idDok, sfrProizvod, rBroj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalOpstiDokument ADD CONSTRAINT FK_ArtikalOstaliDokumenti50 FOREIGN KEY (sfrProizvod) REFERENCES Artikal (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE TGKonto ADD CONSTRAINT FK_TGKonto21 FOREIGN KEY (oznTarGr) REFERENCES TarifnaGrupa (oznTarGr)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE TGKonto ADD CONSTRAINT FK_TGKonto20 FOREIGN KEY (oznKonto, analitika) REFERENCES Konto (oznKonto, analitika)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE StavkaKarticeArtikla ADD CONSTRAINT FK_StavkaKarticeArtikla937 FOREIGN KEY (sfrProizvod) REFERENCES Artikal (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE StavkaKarticeArtikla ADD CONSTRAINT FK_StavkaKarticeArtikla916 FOREIGN KEY (oznOgranak, oznRj) REFERENCES RadnaJedinica (oznOgranak, oznRj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE FakturaServisa ADD CONSTRAINT FK_FakturaServisa107 FOREIGN KEY (idDok) REFERENCES Faktura (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE NalogMagacinu ADD CONSTRAINT FK_NalogMagacinu209 FOREIGN KEY (idDok) REFERENCES Dokument (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE NalogMagacinu ADD CONSTRAINT FK_NalogMagacinu214 FOREIGN KEY (oznOgranak, oznRj) REFERENCES RadnaJedinica (oznOgranak, oznRj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Usluga ADD CONSTRAINT FK_Usluga939 FOREIGN KEY (sfrProizvod) REFERENCES Proizvod (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Faktura ADD CONSTRAINT FK_Faktura5 FOREIGN KEY (idDok) REFERENCES Dokument (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Faktura ADD CONSTRAINT FK_Faktura92 FOREIGN KEY (original) REFERENCES Faktura (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Faktura ADD CONSTRAINT FK_Faktura974 FOREIGN KEY (faktura) REFERENCES Faktura (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Faktura ADD CONSTRAINT FK_Faktura923 FOREIGN KEY (usernameKraj) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Faktura ADD CONSTRAINT FK_Faktura914 FOREIGN KEY (oznOgranak, oznRj) REFERENCES RadnaJedinica (oznOgranak, oznRj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Faktura ADD CONSTRAINT FK_Faktura73 FOREIGN KEY (usernamePoc) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Faktura ADD CONSTRAINT FK_Faktura223 FOREIGN KEY (oznRadniNalog) REFERENCES RadniNalog (oznRadniNalog)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Faktura ADD CONSTRAINT FK_Faktura897 FOREIGN KEY (sfrKomitent) REFERENCES Komitent (sfrKomitent)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Lista ADD CONSTRAINT FK_Lista84 FOREIGN KEY (pzusername) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Lista ADD CONSTRAINT FK_Lista89 FOREIGN KEY (sfrKomitent) REFERENCES Komitent (sfrKomitent)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE AODTaksa ADD CONSTRAINT FK_AODTaksa51 FOREIGN KEY (idDok, sfrProizvod, rBroj) REFERENCES ArtikalOpstiDokument (idDok, sfrProizvod, rBroj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE OsobinaArtikla ADD CONSTRAINT FK_OsobinaArtikla210 FOREIGN KEY (sfrProizvod, oznOgranak, oznRj) REFERENCES Stanje (sfrProizvod, oznOgranak, oznRj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Stanje ADD CONSTRAINT FK_Stanje943 FOREIGN KEY (sfrProizvod) REFERENCES Artikal (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Stanje ADD CONSTRAINT FK_Stanje942 FOREIGN KEY (oznOgranak, oznRj) REFERENCES RadnaJedinica (oznOgranak, oznRj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Konsignacija ADD CONSTRAINT FK_Konsignacija4 FOREIGN KEY (idDok) REFERENCES Dokument (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Konsignacija ADD CONSTRAINT FK_Konsignacija77 FOREIGN KEY (usernamePoc) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Konsignacija ADD CONSTRAINT FK_Konsignacija969 FOREIGN KEY (usernameKraj) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Konsignacija ADD CONSTRAINT FK_Konsignacija970 FOREIGN KEY (oznOgranak, oznRj) REFERENCES RadnaJedinica (oznOgranak, oznRj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE KomercijalnaPolitika ADD CONSTRAINT FK_RabatnaPolitika160 FOREIGN KEY (idKondGrupaKomitenti) REFERENCES KondGrupa (idKondGrupa)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE KomercijalnaPolitika ADD CONSTRAINT FK_RabatnaPolitika162 FOREIGN KEY (pzusername) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE KomercijalnaPolitika ADD CONSTRAINT FK_RabatnaPolitika159 FOREIGN KEY (idKondGrupaArtikli) REFERENCES KondGrupa (idKondGrupa)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalFaktura ADD CONSTRAINT FK_ArtikalFaktura962 FOREIGN KEY (idDok) REFERENCES Faktura (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalFaktura ADD CONSTRAINT FK_ArtikalFaktura25 FOREIGN KEY (sfrProizvod) REFERENCES Artikal (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE TaksaKalkulacija ADD CONSTRAINT FK_PDVKalkulacija964 FOREIGN KEY (idDok) REFERENCES Kalkulacija (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE TaksaKalkulacija ADD CONSTRAINT FK_PDVKalkulacija884 FOREIGN KEY (oznTarGr) REFERENCES TarifnaGrupa (oznTarGr)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Trosak ADD CONSTRAINT FK_Trosak147 FOREIGN KEY (idDok) REFERENCES Dokument (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Trosak ADD CONSTRAINT FK_Trosak151 FOREIGN KEY (original) REFERENCES Trosak (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Trosak ADD CONSTRAINT FK_Trosak965 FOREIGN KEY (kalkulacija) REFERENCES Kalkulacija (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Trosak ADD CONSTRAINT FK_Trosak896 FOREIGN KEY (sfrKomitent) REFERENCES Komitent (sfrKomitent)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE UFTaksa ADD CONSTRAINT FK_UFTaksa110 FOREIGN KEY (idDok, rBroj) REFERENCES UslugaFaktura (idDok, rBroj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalFakturaParameter ADD CONSTRAINT FK_ArtikalFakturaParameter218 FOREIGN KEY (sfrProizvod, idDok, rBroj) REFERENCES ArtikalFaktura (sfrProizvod, idDok, rBroj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalLista ADD CONSTRAINT FK_ArtikalLista85 FOREIGN KEY (idLista) REFERENCES Lista (idLista)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE TaksaTrosak ADD CONSTRAINT FK_TaksaTrosak67 FOREIGN KEY (oznTarGr) REFERENCES TarifnaGrupa (oznTarGr)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE TaksaTrosak ADD CONSTRAINT FK_TaksaTrosak146 FOREIGN KEY (idDok) REFERENCES Trosak (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE TGArtikal ADD CONSTRAINT FK_Taksa23 FOREIGN KEY (oznTarGr) REFERENCES TarifnaGrupa (oznTarGr)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE TGArtikal ADD CONSTRAINT FK_Taksa24 FOREIGN KEY (sfrProizvod) REFERENCES Artikal (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE TaksaFiskalniRacun ADD CONSTRAINT FK_TaksaFiskalniRacun136 FOREIGN KEY (idDok) REFERENCES FiskalniRacun (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE TaksaFiskalniRacun ADD CONSTRAINT FK_TaksaFiskalniRacun131 FOREIGN KEY (oznTarGr) REFERENCES TarifnaGrupa (oznTarGr)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Telefon ADD CONSTRAINT FK_Telefon95 FOREIGN KEY (idTipTelefona) REFERENCES TipTelefona (idTipTelefona)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Telefon ADD CONSTRAINT FK_Telefon97 FOREIGN KEY (pzusername) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Telefon ADD CONSTRAINT FK_Telefon96 FOREIGN KEY (sfrKomitent) REFERENCES Komitent (sfrKomitent)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Lokacija ADD CONSTRAINT FK_Lokacija945 FOREIGN KEY (sfrProizvod) REFERENCES Artikal (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Lokacija ADD CONSTRAINT FK_Lokacija944 FOREIGN KEY (oznOgranak, oznRj) REFERENCES RadnaJedinica (oznOgranak, oznRj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE TaksaFOD ADD CONSTRAINT FK_TaksaFOD118 FOREIGN KEY (oznTarGr) REFERENCES TarifnaGrupa (oznTarGr)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE TaksaFOD ADD CONSTRAINT FK_TaksaFOD117 FOREIGN KEY (faktura, opstiDokument) REFERENCES FakturaOpstiDokument (faktura, opstiDokument)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE KoPlaca ADD CONSTRAINT FK_KoPlaca960 FOREIGN KEY (oznNalogMagacinu) REFERENCES NalogMagacinu (oznNalogMagacinu)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE KoPlaca ADD CONSTRAINT FK_KoVozi950 FOREIGN KEY (oznBP) REFERENCES BrzaPosta (oznBP)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE UslugaFaktura ADD CONSTRAINT FK_UslugaFakturaServisa108 FOREIGN KEY (idDok) REFERENCES FakturaServisa (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE UslugaFaktura ADD CONSTRAINT FK_UslugaFakturaServisa109 FOREIGN KEY (sfrProizvod) REFERENCES Usluga (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Log ADD CONSTRAINT FK_Log919 FOREIGN KEY (pzusername) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE UDTaksa ADD CONSTRAINT FK_UDTaksa126 FOREIGN KEY (idDok, rBroj) REFERENCES UslugaDokument (idDok, rBroj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalTemp ADD CONSTRAINT FK_ArtikalTemp124 FOREIGN KEY (sfrProizvod) REFERENCES Artikal (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE NalogPrijem ADD CONSTRAINT FK_NalogPrijem215 FOREIGN KEY (oznOgranak, oznRj) REFERENCES RadnaJedinica (oznOgranak, oznRj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE NalogPrijem ADD CONSTRAINT FK_NalogPrijem207 FOREIGN KEY (idDok) REFERENCES Dokument (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE NalogPrijem ADD CONSTRAINT FK_NalogPrijem208 FOREIGN KEY (pzusername) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE AFTaksa ADD CONSTRAINT FK_AFTaksa27 FOREIGN KEY (sfrProizvod, idDok, rBroj) REFERENCES ArtikalFaktura (sfrProizvod, idDok, rBroj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalKalkulacija ADD CONSTRAINT FK_ArtikalKalkulacija966 FOREIGN KEY (idDok) REFERENCES Kalkulacija (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalKalkulacija ADD CONSTRAINT FK_ArtikalKalkulacija34 FOREIGN KEY (sfrProizvod) REFERENCES Artikal (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE TaksaNivelacija ADD CONSTRAINT FK_TaksaNivelacija113 FOREIGN KEY (idDok) REFERENCES Nivelacija (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE TaksaNivelacija ADD CONSTRAINT FK_TaksaNivelacija114 FOREIGN KEY (oznTarGr) REFERENCES TarifnaGrupa (oznTarGr)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE PutniTrosak ADD CONSTRAINT FK_PutniTrosak235 FOREIGN KEY (idDok) REFERENCES Faktura (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE PzUser ADD CONSTRAINT FK_PzUser192 FOREIGN KEY (idRadnoMesto) REFERENCES RadnoMesto (idRadnoMesto)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ShemaNasledjuje ADD CONSTRAINT FK_nasledjuje122 FOREIGN KEY (nadTipDok, nadTipRJ, nadPodTipDok, nadPTipRj, nadPpTipRj, nadOznRj, nadOznOgranak) REFERENCES Shema (tipDok, tipRJ, podTipDok, pTipRj, ppTipRj, oznRj, oznOgranak)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ShemaNasledjuje ADD CONSTRAINT FK_nasledjuje123 FOREIGN KEY (tipDok, tipRJ, podTipDok, pTipRj, ppTipRj, oznRj, oznOgranak) REFERENCES Shema (tipDok, tipRJ, podTipDok, pTipRj, ppTipRj, oznRj, oznOgranak)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ANTaksa ADD CONSTRAINT FK_ANTaksa41 FOREIGN KEY (sfrProizvod, idDok, rBroj) REFERENCES ArtikalNivelacija (sfrProizvod, idDok, rBroj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE TaksaKZ ADD CONSTRAINT FK_TaksaKZ119 FOREIGN KEY (zapisnik, kalkulacija) REFERENCES KalkulacijaZapisnik (zapisnik, kalkulacija)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE TaksaKZ ADD CONSTRAINT FK_TaksaKZ120 FOREIGN KEY (oznTarGr) REFERENCES TarifnaGrupa (oznTarGr)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE SFUTaksa ADD CONSTRAINT FK_SFUTaksa31 FOREIGN KEY (idDok, rBroj) REFERENCES StavkaFaktureUsl (idDok, rBroj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE KomitentParameter ADD CONSTRAINT FK_KomitentParameter238 FOREIGN KEY (sfrKomitent) REFERENCES Komitent (sfrKomitent)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalKonsignacija ADD CONSTRAINT FK_ArtikalKonsignacija971 FOREIGN KEY (idDok) REFERENCES Konsignacija (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalKonsignacija ADD CONSTRAINT FK_ArtikalKonsignacija36 FOREIGN KEY (sfrProizvod) REFERENCES Artikal (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE UserNalogMagacinu ADD CONSTRAINT FK_UserNalogMagacinu101 FOREIGN KEY (oznNalogMagacinu) REFERENCES NalogMagacinu (oznNalogMagacinu)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE UserNalogMagacinu ADD CONSTRAINT FK_UserNalogMagacinu102 FOREIGN KEY (pzusername) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Artikal ADD CONSTRAINT FK_Artikal938 FOREIGN KEY (sfrProizvod) REFERENCES Proizvod (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Artikal ADD CONSTRAINT FK_Artikal892 FOREIGN KEY (dobavljac) REFERENCES Komitent (sfrKomitent)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Artikal ADD CONSTRAINT FK_Artikal230 FOREIGN KEY (amortGrupa) REFERENCES AmortGrupa (oznAmortGrupa)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Artikal ADD CONSTRAINT FK_Artikal231 FOREIGN KEY (poreskaGrupa) REFERENCES AmortGrupa (oznAmortGrupa)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Artikal ADD CONSTRAINT FK_Artikal45 FOREIGN KEY (oznOgranak, oznRj) REFERENCES RadnaJedinica (oznOgranak, oznRj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Artikal ADD CONSTRAINT FK_Artikal881 FOREIGN KEY (oznRobGr) REFERENCES RobnaGrupa (oznRobGr)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Artikal ADD CONSTRAINT FK_Artikal918 FOREIGN KEY (oznAmbalaza) REFERENCES Ambalaza (oznAmbalaza)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Artikal ADD CONSTRAINT FK_Artikal232 FOREIGN KEY (idRacunopolagac) REFERENCES Racunopolagac (idRacunopolagac)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Artikal ADD CONSTRAINT FK_Artikal900 FOREIGN KEY (oznModel) REFERENCES Model (oznModel)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Artikal ADD CONSTRAINT FK_Artikal893 FOREIGN KEY (proizvodjac) REFERENCES Komitent (sfrKomitent)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE StavkaNZK ADD CONSTRAINT FK_StavkaNZK15 FOREIGN KEY (idDok) REFERENCES Dokument (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE StavkaNZK ADD CONSTRAINT FK_StavkaNZK972 FOREIGN KEY (idNalog) REFERENCES NZK (idNalog)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE StavkaNZK ADD CONSTRAINT FK_StavkaNZK105 FOREIGN KEY (sfrKomitent) REFERENCES Komitent (sfrKomitent)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE StavkaNZK ADD CONSTRAINT FK_StavkaNZK104 FOREIGN KEY (oznOgranak, oznRj) REFERENCES RadnaJedinica (oznOgranak, oznRj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE StavkaNZK ADD CONSTRAINT FK_StavkaNZK14 FOREIGN KEY (oznKonto, analitika) REFERENCES Konto (oznKonto, analitika)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE FiskalniRacun ADD CONSTRAINT FK_FiskalniRacun155 FOREIGN KEY (idDok) REFERENCES Dokument (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE FiskalniRacun ADD CONSTRAINT FK_FiskalniRacun128 FOREIGN KEY (oznOgranak, oznRj) REFERENCES RadnaJedinica (oznOgranak, oznRj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE FiskalniRacun ADD CONSTRAINT FK_FiskalniRacun138 FOREIGN KEY (sfrKomitent) REFERENCES Komitent (sfrKomitent)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE FiskalniRacun ADD CONSTRAINT FK_FiskalniRacun130 FOREIGN KEY (pzusername) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE FiskalniRacun ADD CONSTRAINT FK_FiskalniRacun216 FOREIGN KEY (original) REFERENCES FiskalniRacun (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Settings ADD CONSTRAINT FK_Settings68 FOREIGN KEY (pzusername) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalAkcija ADD CONSTRAINT FK_ArtikalAkcija149 FOREIGN KEY (sfrProizvod) REFERENCES Artikal (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalAkcija ADD CONSTRAINT FK_ArtikalAkcija150 FOREIGN KEY (pzusername) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ADTaksa ADD CONSTRAINT FK_ADTaksa237 FOREIGN KEY (idDok, sfrProizvod, rBroj) REFERENCES ArtikalDokument (idDok, sfrProizvod, rBroj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalGarnitura ADD CONSTRAINT FK_ArtikalGarnitura153 FOREIGN KEY (deo) REFERENCES Artikal (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalGarnitura ADD CONSTRAINT FK_ArtikalGarnitura154 FOREIGN KEY (garnitura) REFERENCES Artikal (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE TarifnaGrupa ADD CONSTRAINT FK_TarifnaGrupa22 FOREIGN KEY (oznVrstaTG) REFERENCES VrstaTG (oznVrstaTG)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE KalkulacijaZapisnik ADD CONSTRAINT FK_KalkulacijaZapisnik87 FOREIGN KEY (kalkulacija) REFERENCES Kalkulacija (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE KalkulacijaZapisnik ADD CONSTRAINT FK_KalkulacijaZapisnik145 FOREIGN KEY (zapisnik) REFERENCES Kalkulacija (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE AKTaksa ADD CONSTRAINT FK_AKTaksa35 FOREIGN KEY (sfrProizvod, idDok, rBroj) REFERENCES ArtikalKalkulacija (sfrProizvod, idDok, rBroj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE TaksaFaktura ADD CONSTRAINT FK_PDVFaktura0 FOREIGN KEY (oznTarGr) REFERENCES TarifnaGrupa (oznTarGr)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE TaksaFaktura ADD CONSTRAINT FK_PDVFaktura975 FOREIGN KEY (idDok) REFERENCES Faktura (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalInterniRacun ADD CONSTRAINT FK_ArtikalInterniRacun963 FOREIGN KEY (idDok) REFERENCES InterniRacun (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalInterniRacun ADD CONSTRAINT FK_ArtikalInterniRacun32 FOREIGN KEY (sfrProizvod) REFERENCES Artikal (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalDokument ADD CONSTRAINT FK_ArtikalDokument9 FOREIGN KEY (idDok) REFERENCES Dokument (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Porudzbina ADD CONSTRAINT FK_Porudzbina171 FOREIGN KEY (idDok) REFERENCES Faktura (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Porudzbina ADD CONSTRAINT FK_Porudzbina172 FOREIGN KEY (sfrKomitent) REFERENCES Komitent (sfrKomitent)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE StavkaPorudzbine ADD CONSTRAINT FK_StavkaPorudzbine139 FOREIGN KEY (idDok) REFERENCES Faktura (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE StavkaPorudzbine ADD CONSTRAINT FK_StavkaPorudzbine142 FOREIGN KEY (oznOgranak, oznRj) REFERENCES RadnaJedinica (oznOgranak, oznRj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Dokument ADD CONSTRAINT FK_Dokument200 FOREIGN KEY (usernamePoc) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Dokument ADD CONSTRAINT FK_Dokument201 FOREIGN KEY (usernameKraj) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Dokument ADD CONSTRAINT FK_Dokument8 FOREIGN KEY (oznOgranak, oznRj) REFERENCES RadnaJedinica (oznOgranak, oznRj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Dokument ADD CONSTRAINT FK_Dokument90 FOREIGN KEY (original) REFERENCES Dokument (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Dokument ADD CONSTRAINT FK_Dokument11 FOREIGN KEY (sfrKomitent) REFERENCES Komitent (sfrKomitent)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE RobnaGrupa ADD CONSTRAINT FK_RobnaGrupa59 FOREIGN KEY (oznNadGrupa) REFERENCES RobnaGrupa (oznRobGr)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE OpstiDokument ADD CONSTRAINT FK_OstalaDokumenta53 FOREIGN KEY (idDok) REFERENCES Dokument (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE OpstiDokument ADD CONSTRAINT FK_OpstiDokument198 FOREIGN KEY (usernamePoc) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE OpstiDokument ADD CONSTRAINT FK_OstalaDokumenta46 FOREIGN KEY (oznOgranak, oznRj) REFERENCES RadnaJedinica (oznOgranak, oznRj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE OpstiDokument ADD CONSTRAINT FK_OpstiDokument199 FOREIGN KEY (usernameKraj) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE OpstiDokument ADD CONSTRAINT FK_OpstiDokument94 FOREIGN KEY (original) REFERENCES OpstiDokument (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE OpstiDokument ADD CONSTRAINT FK_OpstiDokument221 FOREIGN KEY (oznRadniNalog) REFERENCES RadniNalog (oznRadniNalog)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE OpstiDokument ADD CONSTRAINT FK_OpstiDokument55 FOREIGN KEY (sfrKomitent) REFERENCES Komitent (sfrKomitent)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE OpstiDokument ADD CONSTRAINT FK_OpstiDokument220 FOREIGN KEY (oznPrj, oznMTroska) REFERENCES PrjMestoTroska (oznPrj, oznMTroska)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE RadnaJedinica ADD CONSTRAINT FK_RadnaJedinica926 FOREIGN KEY (oznOgranak) REFERENCES Ogranak (oznOgranak)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE RadnaJedinica ADD CONSTRAINT FK_RadnaJedinica217 FOREIGN KEY (refOgranak, refRj) REFERENCES RadnaJedinica (oznOgranak, oznRj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE RadnaJedinica ADD CONSTRAINT FK_RadnaJedinica213 FOREIGN KEY (oznDislokacija) REFERENCES Dislokacija (oznDislokacija)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE RadnaJedinica ADD CONSTRAINT FK_RadnaJedinica890 FOREIGN KEY (sfrKomitent) REFERENCES Komitent (sfrKomitent)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE FakturaOpstiDokument ADD CONSTRAINT FK_FakturaOpstiDokument115 FOREIGN KEY (opstiDokument) REFERENCES OpstiDokument (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE FakturaOpstiDokument ADD CONSTRAINT FK_FakturaOpstiDokument116 FOREIGN KEY (faktura) REFERENCES Faktura (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Kalkulacija ADD CONSTRAINT FK_Kalkulacija2 FOREIGN KEY (idDok) REFERENCES Dokument (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Kalkulacija ADD CONSTRAINT FK_Kalkulacija76 FOREIGN KEY (usernamePoc) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Kalkulacija ADD CONSTRAINT FK_Kalkulacija920 FOREIGN KEY (usernameKraj) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Kalkulacija ADD CONSTRAINT FK_Kalkulacija910 FOREIGN KEY (oznOgranak, oznRj) REFERENCES RadnaJedinica (oznOgranak, oznRj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Kalkulacija ADD CONSTRAINT FK_Kalkulacija93 FOREIGN KEY (original) REFERENCES Kalkulacija (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Kalkulacija ADD CONSTRAINT FK_Kalkulacija895 FOREIGN KEY (sfrKomitent) REFERENCES Komitent (sfrKomitent)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Kalkulacija ADD CONSTRAINT FK_Kalkulacija158 FOREIGN KEY (idKalkulacija) REFERENCES Kalkulacija (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE KomercijalnaPolitikaParam ADD CONSTRAINT FK_RabatnaPolitikaParameter163 FOREIGN KEY (idKomercijalnaPolitika) REFERENCES KomercijalnaPolitika (idKomercijalnaPolitika)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalPorudzbina ADD CONSTRAINT FK_ArtikalPorudzbina173 FOREIGN KEY (idPoruzbine) REFERENCES Porudzbina (idPoruzbine)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalPorudzbina ADD CONSTRAINT FK_ArtikalPorudzbina175 FOREIGN KEY (sfrProizvodFaktura) REFERENCES Artikal (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalPorudzbina ADD CONSTRAINT FK_ArtikalPorudzbina170 FOREIGN KEY (sfrProizvod) REFERENCES Artikal (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE TGUsluga ADD CONSTRAINT FK_TaksaUsluga28 FOREIGN KEY (sfrProizvod) REFERENCES Usluga (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE TGUsluga ADD CONSTRAINT FK_TaksaUsluga29 FOREIGN KEY (oznTarGr) REFERENCES TarifnaGrupa (oznTarGr)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE FakturaParameter ADD CONSTRAINT FK_FakturaParameter206 FOREIGN KEY (idDok) REFERENCES Faktura (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalNalog ADD CONSTRAINT FK_ArtikalNalog959 FOREIGN KEY (oznNalogMagacinu) REFERENCES NalogMagacinu (oznNalogMagacinu)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Kurs ADD CONSTRAINT FK_Kurs203 FOREIGN KEY (oznValuta) REFERENCES Valuta (oznValuta)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE StavkaSheme ADD CONSTRAINT FK_ShemaRed973 FOREIGN KEY (tipDok, tipRJ, podTipDok, pTipRj, ppTipRj, oznRj, oznOgranak) REFERENCES Shema (tipDok, tipRJ, podTipDok, pTipRj, ppTipRj, oznRj, oznOgranak)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE KomitentGrupaLink ADD CONSTRAINT FK_KomitentGrupaLink194 FOREIGN KEY (sfrKomitent) REFERENCES Komitent (sfrKomitent)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE KomitentGrupaLink ADD CONSTRAINT FK_KomitentGrupaLink195 FOREIGN KEY (idKomitentGrupa) REFERENCES KomitentGrupa (idKomitentGrupa)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Nivelacija ADD CONSTRAINT FK_Nivelacija1 FOREIGN KEY (idDok) REFERENCES Dokument (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Nivelacija ADD CONSTRAINT FK_Nivelacija913 FOREIGN KEY (oznOgranak, oznRj) REFERENCES RadnaJedinica (oznOgranak, oznRj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Nivelacija ADD CONSTRAINT FK_Nivelacija922 FOREIGN KEY (usernameKraj) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Nivelacija ADD CONSTRAINT FK_Nivelacija78 FOREIGN KEY (usernamePoc) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalNivelacija ADD CONSTRAINT FK_ArtikalNivelacija967 FOREIGN KEY (idDok) REFERENCES Nivelacija (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalNivelacija ADD CONSTRAINT FK_ArtikalNivelacija40 FOREIGN KEY (sfrProizvod) REFERENCES Artikal (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalNalogPrijem ADD CONSTRAINT FK_ArtikalNalogPrijem143 FOREIGN KEY (oznNalogPrijem) REFERENCES NalogPrijem (oznNalogPrijem)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE StavkaFaktureUsl ADD CONSTRAINT FK_StavkaFaktureUsl234 FOREIGN KEY (idDok) REFERENCES Faktura (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE StavkaFaktureUsl ADD CONSTRAINT FK_StavkaFaktureUsl30 FOREIGN KEY (sfrProizvod) REFERENCES Usluga (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE PzUserInfo ADD CONSTRAINT FK_PzUserInfo186 FOREIGN KEY (pzusername) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE StavkaKarticeKomitenta ADD CONSTRAINT FK_StavkaKarticeKomitenta899 FOREIGN KEY (sfrKomitent) REFERENCES Komitent (sfrKomitent)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE UslugaDokument ADD CONSTRAINT FK_UslugaDokument125 FOREIGN KEY (idDok) REFERENCES Dokument (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE TekuciRacun ADD CONSTRAINT FK_TekuciRacun929 FOREIGN KEY (oznFirma) REFERENCES Firma (oznFirma)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE TekuciRacun ADD CONSTRAINT FK_TekuciRacun894 FOREIGN KEY (sfrKomitent) REFERENCES Komitent (sfrKomitent)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE DokumentLog ADD CONSTRAINT FK_DokumentLog225 FOREIGN KEY (pzusername) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE DokumentLog ADD CONSTRAINT FK_DokumentLog224 FOREIGN KEY (idDok) REFERENCES Dokument (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE StavkaZahteva ADD CONSTRAINT FK_StavkaZahteva176 FOREIGN KEY (idPoruzbine, idZahteva) REFERENCES Zahtev (idPoruzbine, idZahteva)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Email ADD CONSTRAINT FK_Email189 FOREIGN KEY (pzusername) REFERENCES PzUser (pzusername)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Email ADD CONSTRAINT FK_Email188 FOREIGN KEY (sfrKomitent) REFERENCES Komitent (sfrKomitent)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE Email ADD CONSTRAINT FK_Email187 FOREIGN KEY (idTipEmaila) REFERENCES TipEmaila (idTipEmaila)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE DTaksa ADD CONSTRAINT FK_DTGR17 FOREIGN KEY (idDok) REFERENCES Dokument (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE DTaksa ADD CONSTRAINT FK_DTGR18 FOREIGN KEY (oznTarGr) REFERENCES TarifnaGrupa (oznTarGr)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE AKonsTaksa ADD CONSTRAINT FK_AKonsTaksa37 FOREIGN KEY (sfrProizvod, idDok, rBroj) REFERENCES ArtikalKonsignacija (sfrProizvod, idDok, rBroj)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE TaksaOpstiDokument ADD CONSTRAINT FK_TaksaOpstiDokument70 FOREIGN KEY (idDok) REFERENCES OpstiDokument (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE TaksaOpstiDokument ADD CONSTRAINT FK_TaksaOpstiDokument71 FOREIGN KEY (oznTarGr) REFERENCES TarifnaGrupa (oznTarGr)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ArtikalParameter ADD CONSTRAINT FK_ArtikalParameter236 FOREIGN KEY (sfrProizvod) REFERENCES Artikal (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ProizvodFiskalniRacun ADD CONSTRAINT FK_ProizvodFiskalniRacun141 FOREIGN KEY (idDok) REFERENCES FiskalniRacun (idDok)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE ProizvodFiskalniRacun ADD CONSTRAINT FK_ProizvodFiskalniRacun134 FOREIGN KEY (sfrProizvod) REFERENCES Proizvod (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE AOEM ADD CONSTRAINT FK_AOEM56 FOREIGN KEY (sfrProizvod) REFERENCES Artikal (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE AOEM ADD CONSTRAINT FK_AOEM57 FOREIGN KEY (oem) REFERENCES OEM (oem)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE OEBroj ADD CONSTRAINT FK_OEBroj148 FOREIGN KEY (sfrProizvod) REFERENCES Artikal (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE RabatnaSkala ADD CONSTRAINT FK_RabatnaSkala936 FOREIGN KEY (sfrProizvod) REFERENCES Artikal (sfrProizvod)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE RabatnaSkala ADD CONSTRAINT FK_RabatnaSkala891 FOREIGN KEY (sfrKomitent) REFERENCES Komitent (sfrKomitent)  ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE RabatnaSkala ADD CONSTRAINT FK_RabatnaSkala880 FOREIGN KEY (oznRobGr) REFERENCES RobnaGrupa (oznRobGr)  ON DELETE NO ACTION ON UPDATE NO ACTION;

-- ESIR

ALTER TABLE fiskalniracun
  ADD COLUMN tip character varying(255);
ALTER TABLE fiskalniracun
  ADD COLUMN podtip character varying(255);
ALTER TABLE fiskalniracun
  ADD COLUMN lpfrbroj character varying(255);
ALTER TABLE fiskalniracun
  ADD COLUMN lpfrvreme character varying(255);
ALTER TABLE fiskalniracun
  ADD COLUMN virman numeric(20,2);
ALTER TABLE fiskalniracun
  ADD COLUMN vaucer numeric(20,2);
ALTER TABLE fiskalniracun
  ADD COLUMN ips numeric(20,2);
ALTER TABLE fiskalniracun
  ADD COLUMN ostalo numeric(20,2);
ALTER TABLE fiskalniracun
  ADD COLUMN refbroj character varying(255);
ALTER TABLE fiskalniracun
  ADD COLUMN refvreme character varying(255);
ALTER TABLE fiskalniracun
  ADD COLUMN idkupca character varying(255);
ALTER TABLE fiskalniracun
  ADD COLUMN opcionopolje character varying(255);
ALTER TABLE fiskalniracun
  ADD COLUMN idfakture integer;
CREATE TABLE taxmap
(
  label character varying(10),
  ozntargr character varying(10) NOT NULL,
  CONSTRAINT pk_taxmap PRIMARY KEY (ozntargr)
);

-- E-FAKTURA

CREATE TABLE edokument
(
  iddok integer NOT NULL,
  responsedata text NOT NULL,
  sfrkomitent character varying(255),
  naziv character varying(255),
  ozndokumenta character varying(255),
  tip character varying(255),
  smer character varying(255),
  datum date,
  uspesno boolean,
  status character varying(255),
  requestid character varying(255),
  CONSTRAINT pk_edokument_iddok PRIMARY KEY (iddok)
);

-- PEZAR WS

create table ordr (
    id int8 not null,
    amount numeric(19, 2),
    created_at timestamp,
    customerid varchar(255),
    delivery_date date not null,
    inventoryid varchar(255),
    modified_at timestamp,
    note TEXT,
    order_date date,
    order_number varchar(255),
    ref_number varchar(255),
    salesmanid int4 not null,
    status int4 not null,
    primary key (id)
);

create table ordr_item (
    id int8 not null,
    created_at timestamp,
    delivered_qty numeric(19, 2),
    modified_at timestamp,
    note TEXT,
    order_number varchar(255),
    ordered_qty numeric(19, 2),
    price numeric(19, 2),
    productid varchar(255),
    product_name varchar(255),
    rebate numeric(19, 2),
    ref_number varchar(255),
    salesmanid int4,
    tax_amount numeric(19, 2),
    taxid varchar(255),
    order_id int8 not null,
    primary key (id)
);

ALTER TABLE artikal
  ADD COLUMN created_at timestamp without time zone NOT NULL DEFAULT NOW();
ALTER TABLE artikal
  ADD COLUMN modified_at timestamp without time zone NOT NULL DEFAULT NOW();

ALTER TABLE komitent
  ADD COLUMN created_at timestamp without time zone NOT NULL DEFAULT NOW();
ALTER TABLE komitent
  ADD COLUMN modified_at timestamp without time zone NOT NULL DEFAULT NOW();

ALTER TABLE stanje
  ADD COLUMN created_at timestamp without time zone NOT NULL DEFAULT NOW();
ALTER TABLE stanje
  ADD COLUMN modified_at timestamp without time zone NOT NULL DEFAULT NOW();

CREATE OR REPLACE FUNCTION trigger_set_timestamp()
RETURNS TRIGGER AS $$
BEGIN
  NEW.modified_at = NOW();
  RETURN NEW;
END;
$$ LANGUAGE plpgsql;

CREATE TRIGGER set_timestamp_artikal
BEFORE UPDATE ON artikal
FOR EACH ROW
EXECUTE PROCEDURE trigger_set_timestamp();

CREATE TRIGGER set_timestamp_komitent
BEFORE UPDATE ON komitent
FOR EACH ROW
EXECUTE PROCEDURE trigger_set_timestamp();

CREATE TRIGGER set_timestamp_stanje
BEFORE UPDATE ON stanje
FOR EACH ROW
EXECUTE PROCEDURE trigger_set_timestamp();

CREATE TRIGGER set_timestamp_ordr
BEFORE UPDATE ON ordr
FOR EACH ROW
EXECUTE PROCEDURE trigger_set_timestamp();

CREATE TRIGGER set_timestamp_ordr_item
BEFORE UPDATE ON ordr_item
FOR EACH ROW
EXECUTE PROCEDURE trigger_set_timestamp();