/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.model.ThreadPoolProfileDefinition;
import org.apache.camel.util.CamelContextHelper;

public final class ThreadPoolBuilder {
    private final CamelContext camelContext;
    private ThreadPoolProfileDefinition threadPoolDefinition;

    public ThreadPoolBuilder(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.threadPoolDefinition = new ThreadPoolProfileDefinition(camelContext.getExecutorServiceStrategy().getDefaultThreadPoolProfile());
    }

    public ThreadPoolBuilder poolSize(int poolSize) {
        this.threadPoolDefinition.poolSize(poolSize);
        return this;
    }

    public ThreadPoolBuilder maxPoolSize(int maxPoolSize) {
        this.threadPoolDefinition.maxPoolSize(maxPoolSize);
        return this;
    }

    public ThreadPoolBuilder keepAliveTime(long keepAliveTime) {
        this.threadPoolDefinition.keepAliveTime(keepAliveTime);
        return this;
    }

    public ThreadPoolBuilder timeUnit(TimeUnit timeUnit) {
        this.threadPoolDefinition.timeUnit(timeUnit);
        return this;
    }

    public ThreadPoolBuilder maxQueueSize(int maxQueueSize) {
        this.threadPoolDefinition.maxQueueSize(maxQueueSize);
        return this;
    }

    public ThreadPoolBuilder rejectedPolicy(ThreadPoolRejectedPolicy rejectedPolicy) {
        this.threadPoolDefinition.rejectedPolicy(rejectedPolicy);
        return this;
    }

    public ExecutorService build(String name) throws Exception {
        return this.build(null, name);
    }

    public ExecutorService build(Object source, String name) throws Exception {
        int size = CamelContextHelper.parseInteger(this.camelContext, this.threadPoolDefinition.getPoolSize());
        int max = CamelContextHelper.parseInteger(this.camelContext, this.threadPoolDefinition.getMaxPoolSize());
        long keepAlive = CamelContextHelper.parseLong(this.camelContext, this.threadPoolDefinition.getKeepAliveTime());
        int queueSize = CamelContextHelper.parseInteger(this.camelContext, this.threadPoolDefinition.getMaxQueueSize());
        TimeUnit unit = this.threadPoolDefinition.getTimeUnit();
        RejectedExecutionHandler handler = this.threadPoolDefinition.getRejectedExecutionHandler();
        ExecutorService answer = this.camelContext.getExecutorServiceStrategy().newThreadPool(source, name, size, max, keepAlive, unit, queueSize, handler, true);
        return answer;
    }
}

