/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.bean.MethodBean;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanInvocation
implements Externalizable {
    private static final transient Logger LOG = LoggerFactory.getLogger(BeanInvocation.class);
    private Object[] args;
    private MethodBean methodBean;
    private transient Method method;

    public BeanInvocation() {
    }

    public BeanInvocation(Method method, Object[] args) {
        this.method = method;
        this.args = args;
    }

    public String toString() {
        List<Object> list = null;
        if (this.args != null) {
            list = Arrays.asList(this.args);
        }
        return "BeanInvocation " + this.method + " with " + list + "]";
    }

    public Object[] getArgs() {
        return this.args;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setArgs(Object[] args) {
        this.args = args;
    }

    public void invoke(Object pojo, Exchange exchange) {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Invoking method: " + this.getMethod() + " with args: " + this.getArgs());
            }
            Object response = this.getMethod().invoke(pojo, this.getArgs());
            if (LOG.isTraceEnabled()) {
                LOG.trace("Got response: " + response);
            }
            exchange.getOut().setBody(response);
        }
        catch (InvocationTargetException e) {
            exchange.setException(ObjectHelper.wrapRuntimeCamelException(e.getCause()));
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.methodBean = ObjectHelper.cast(MethodBean.class, objectInput.readObject());
        try {
            this.method = this.methodBean.getMethod();
        }
        catch (NoSuchMethodException e) {
            throw new IOException(e);
        }
        this.args = ObjectHelper.cast(Object[].class, objectInput.readObject());
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this.methodBean == null) {
            this.methodBean = new MethodBean(this.method);
        }
        objectOutput.writeObject(this.methodBean);
        objectOutput.writeObject(this.args);
    }
}

