/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.processor.Traceable;

public class TransformProcessor
implements Processor,
Traceable {
    private final Expression expression;

    public TransformProcessor(Expression expression) {
        this.expression = expression;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Object newBody = this.expression.evaluate(exchange, Object.class);
        exchange.getOut().setBody(newBody);
        exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
        exchange.getOut().setAttachments(exchange.getIn().getAttachments());
    }

    public String toString() {
        return "Transform(" + this.expression + ")";
    }

    @Override
    public String getTraceLabel() {
        return "transform[" + this.expression + "]";
    }
}

