/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar;

import java.util.Collection;
import java.util.stream.Collectors;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import rs.tetrabyte.datarest.task.RestTaskFactory;
import rs.tetrabyte.fxml.FXMLTaskFactory;
import rs.tetrabyte.pezar.beans.Resident;
import rs.tetrabyte.pezar.commands.DisplayContent;
import rs.tetrabyte.pezar.commands.UICommands;
import rs.tetrabyte.pezar.config.DataRestFXMLConfig;
import rs.tetrabyte.pezar.config.PezarFXConfiguration;
import rs.tetrabyte.pezar.context.LogInService;
import rs.tetrabyte.pezar.context.TenantContext;
import rs.tetrabyte.pezar.context.data.Server;
import rs.tetrabyte.pezar.controller.LoginViewController;
import rs.tetrabyte.pezar.controller.ServersViewController;
import rs.tetrabyte.pezar.settings.LocalSettingsManager;
import rs.tetrabyte.task.ExceptionHandler;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication
public class PezarFX
extends Application {
    private ApplicationContext context;
    private Scene scene;
    private UICommands uiCommands;
    private Stage stage;

    public static void main(String[] args) {
        PezarFX.launch((String[])args);
    }

    public void start(Stage stage) throws Exception {
        this.stage = stage;
        this.context = new AnnotationConfigApplicationContext(new Class[]{DataRestFXMLConfig.class, PezarFXConfiguration.class});
        this.uiCommands = (UICommands)this.context.getBean(UICommands.class);
        LocalSettingsManager localSettingsMgr = (LocalSettingsManager)this.context.getBean(LocalSettingsManager.class);
        this.scene = (Scene)this.context.getBean(Scene.class);
        stage.setScene(this.scene);
        double height = localSettingsMgr.getSettings().getDouble("stage-height", Double.valueOf(800.0));
        double width = localSettingsMgr.getSettings().getDouble("stage-width", Double.valueOf(1200.0));
        stage.setWidth(width);
        stage.setHeight(height);
        stage.setMaximized(localSettingsMgr.getSettings().getBoolean("stage-maximized", Boolean.valueOf(false)).booleanValue());
        stage.show();
        this.scene.getStylesheets().add((Object)"css/pezar-fx.css");
        this.scene.getStylesheets().add((Object)"css/modena-dark.css");
        FXMLTaskFactory fxmlTaskFactory = (FXMLTaskFactory)this.context.getBean(FXMLTaskFactory.class);
        Integer serverIndex = localSettingsMgr.getSettings().getInteger("current-server", Integer.valueOf(-1));
        if (serverIndex != -1) {
            rs.tetrabyte.pezar.settings.Server server = (rs.tetrabyte.pezar.settings.Server)localSettingsMgr.getSettings().getServers().get(serverIndex.intValue());
            ((TenantContext)this.context.getBean(TenantContext.class)).setActiveServer(new Server(server.getUrl(), server.getName(), server.getLocale()));
            ((RestTaskFactory)this.context.getBean(RestTaskFactory.class)).createTask(client -> client.getResources(String.valueOf(server.getUrl()) + "/" + "residents", Resident.class).getContent()).whenDone(residents -> {
                ((TenantContext)this.context.getBean(TenantContext.class)).setResidents((Collection)residents.stream().collect(Collectors.toList()));
                ((TenantContext)this.context.getBean(TenantContext.class)).setActiveServer(new Server(server.getUrl(), server.getName(), server.getLocale()));
                if (StringUtils.isEmpty((CharSequence)server.getUserName()) || StringUtils.isEmpty((CharSequence)server.getPassword())) {
                    fxmlTaskFactory.createTask(LoginViewController.class).output(new Object[]{server}).whenDone(v -> {
                        this.uiCommands.clearScreen().execute();
                        this.uiCommands.displayContent((Node)((Parent)v.getView())).in(DisplayContent.TargetContainer.Screen).closable(false).execute();
                    }).execute();
                } else {
                    this.uiCommands.lockUI().execute();
                    ((LogInService)this.context.getBean(LogInService.class)).login(server.getUserName(), server.getPassword(), (LogInService.LoginHandler)new /* Unavailable Anonymous Inner Class!! */);
                }
            }).ifFailed(ex -> {
                ((ExceptionHandler)this.context.getBean(ExceptionHandler.class)).handle(ex);
                fxmlTaskFactory.createTask(ServersViewController.class).whenDone(v -> {
                    this.uiCommands.clearScreen().execute();
                    this.uiCommands.displayContent((Node)((Parent)v.getView())).in(DisplayContent.TargetContainer.Screen).closable(false).execute();
                }).execute();
            }).execute();
        } else {
            fxmlTaskFactory.createTask(ServersViewController.class).whenDone(v -> {
                this.uiCommands.clearScreen().execute();
                this.uiCommands.displayContent((Node)((Parent)v.getView())).in(DisplayContent.TargetContainer.Screen).closable(false).execute();
            }).execute();
        }
    }

    public void stop() throws Exception {
        LocalSettingsManager localSettingsMgr = (LocalSettingsManager)this.context.getBean(LocalSettingsManager.class);
        localSettingsMgr.getSettings().put("stage-maximized", (Object)this.stage.isMaximized());
        if (!this.stage.isMaximized()) {
            localSettingsMgr.getSettings().put("stage-height", (Object)this.stage.getHeight());
            localSettingsMgr.getSettings().put("stage-width", (Object)this.stage.getWidth());
        }
        localSettingsMgr.saveSettings();
        ((LogInService)this.context.getBean(LogInService.class)).logout();
        super.stop();
    }

    static /* synthetic */ UICommands access$0(PezarFX pezarFX) {
        return pezarFX.uiCommands;
    }
}

