/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.commands;

import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import org.controlsfx.control.Notifications;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.fxml.LocaleContext;
import rs.tetrabyte.pezar.commands.UICommand;
import rs.tetrabyte.pezar.custom.screen.Screen;
import rs.tetrabyte.pezar.factory.GlyphFactory;

public class ShowNotification
extends UICommand {
    private static final String NAME = "show-notification";
    @Autowired
    private LocaleContext localeContext;
    @Autowired
    private Screen screen;
    private String title;
    private String text;
    private Node graphic;
    private Duration hideAfterDuration = Duration.seconds((double)5.0);
    private Pos position = Pos.BOTTOM_RIGHT;
    private boolean closable;
    private Object[] textArgs;
    private Object[] titleArgs;

    void validate() {
    }

    String getName() {
        return NAME;
    }

    public ShowNotification withTitle(String title, Object ... args) {
        this.title = title;
        this.titleArgs = args;
        return this;
    }

    public ShowNotification withText(String text, Object ... args) {
        this.text = text;
        this.textArgs = args;
        return this;
    }

    public ShowNotification withPosition(Pos pos) {
        this.position = pos;
        return this;
    }

    public ShowNotification withGlyph(String glyphCode) {
        this.graphic = GlyphFactory.createGlyph((String)glyphCode);
        return this;
    }

    public ShowNotification withDuration(int seconds) {
        this.hideAfterDuration = Duration.seconds((double)seconds);
        return this;
    }

    public ShowNotification withDuration(Duration duration) {
        this.hideAfterDuration = duration;
        return this;
    }

    public ShowNotification asClosable() {
        this.closable = true;
        return this;
    }

    public ShowNotification success() {
        FontAwesomeIconView graphic = new FontAwesomeIconView(FontAwesomeIcon.CHECK_CIRCLE);
        graphic.setFill((Paint)Color.GREEN);
        this.setGraphic((Node)graphic);
        return this;
    }

    public ShowNotification error() {
        FontAwesomeIconView graphic = new FontAwesomeIconView(FontAwesomeIcon.TIMES_CIRCLE);
        graphic.setFill((Paint)Color.RED);
        this.setGraphic((Node)graphic);
        return this;
    }

    public ShowNotification warning() {
        FontAwesomeIconView graphic = new FontAwesomeIconView(FontAwesomeIcon.WARNING);
        graphic.setFill((Paint)Color.YELLOW);
        this.setGraphic((Node)graphic);
        return this;
    }

    public ShowNotification info() {
        FontAwesomeIconView graphic = new FontAwesomeIconView(FontAwesomeIcon.EXCLAMATION_CIRCLE);
        graphic.setFill((Paint)Color.BLUE);
        this.setGraphic((Node)graphic);
        return this;
    }

    private void setGraphic(Node graphic) {
        graphic.getStyleClass().clear();
        graphic.setStyle("-glyph-size: 100");
        this.graphic = graphic;
    }

    public Node getGraphic() {
        return this.graphic;
    }

    public Duration getHideAfterDuration() {
        return this.hideAfterDuration;
    }

    public Pos getPosition() {
        return this.position;
    }

    public String getText() {
        return this.text;
    }

    public Object[] getTextArgs() {
        return this.textArgs;
    }

    public String getTitle() {
        return this.title;
    }

    public Object[] getTitleArgs() {
        return this.titleArgs;
    }

    public boolean isClosable() {
        return this.closable;
    }

    public void execute() {
        String text = this.getText();
        String title = this.getTitle();
        if (text != null && text.startsWith("%")) {
            text = this.localeContext.getMessage(text.substring(1, text.length()), this.getTextArgs());
        }
        if (title != null && title.startsWith("%")) {
            title = this.localeContext.getMessage(title.substring(1, title.length()), this.getTitleArgs());
        }
        Notifications n = Notifications.create().graphic(this.getGraphic()).hideAfter(this.getHideAfterDuration()).owner((Object)this.screen).position(this.getPosition()).text(text).title(title);
        if (!this.isClosable()) {
            n.hideCloseButton();
        }
        n.show();
        super.execute(false);
    }

    public String toString() {
        return String.valueOf(super.toString()) + "[title=" + this.title + ", text=" + this.text + ", hideAfterDuration=" + this.hideAfterDuration + ", position=" + this.position + "]";
    }
}

