/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.commands;

import com.google.common.eventbus.EventBus;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import rs.tetrabyte.pezar.commands.UICommand;

public class UICommandFactory {
    private EventBus eventBus;
    private AutowireCapableBeanFactory beanFactory;

    public UICommandFactory(EventBus eventBus, AutowireCapableBeanFactory beanFactory) {
        this.eventBus = eventBus;
        this.beanFactory = beanFactory;
    }

    public <T extends UICommand> T createCommand(Class<T> commandClass) {
        try {
            UICommand command = (UICommand)commandClass.newInstance();
            this.beanFactory.autowireBean((Object)command);
            command.setEventBus(this.eventBus);
            command.setCommandFactory(this);
            command.initialize();
            return (T)command;
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }
}

