/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.context;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TreeTableColumn;
import jidefx.scene.control.validation.ValidationUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.datamodel.uidescriptors.entity.DLineDescriptor;
import rs.tetrabyte.datamodel.uidescriptors.entity.DSummaryDescriptor;
import rs.tetrabyte.datamodel.uidescriptors.entity.EFormDescriptor;
import rs.tetrabyte.datamodel.uidescriptors.entity.ESearchDescriptor;
import rs.tetrabyte.datamodel.uidescriptors.entity.ETableDescriptor;
import rs.tetrabyte.datarest.client.RestClient;
import rs.tetrabyte.pezar.beans.AbstractEntity;
import rs.tetrabyte.pezar.beans.Document;
import rs.tetrabyte.pezar.commands.UICommands;
import rs.tetrabyte.pezar.context.MessageService;
import rs.tetrabyte.pezar.controller.FormFieldController;
import rs.tetrabyte.pezar.custom.FormFieldContainer;
import rs.tetrabyte.pezar.custom.FormView;
import rs.tetrabyte.pezar.custom.accelerable.PFXLabel;
import rs.tetrabyte.pezar.custom.accelerable.PFXTab;
import rs.tetrabyte.pezar.custom.factory.form.FormFieldContainerGroupFactory;
import rs.tetrabyte.pezar.custom.factory.form.controller.FormFieldControllerBuilder;
import rs.tetrabyte.pezar.custom.factory.form.controller.FormFieldControllerFactory;
import rs.tetrabyte.pezar.custom.factory.form.controller.impl.FormPropertyFieldBuilder;
import rs.tetrabyte.pezar.custom.factory.form.reader.EntityReader;
import rs.tetrabyte.pezar.custom.factory.form.reader.ObjectReader;
import rs.tetrabyte.pezar.custom.factory.treeTable.TreeTableColumnFactory;
import rs.tetrabyte.pezar.factory.GlyphFactory;
import rs.tetrabyte.pezar.factory.field.util.ControlUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class ControlsFactoryService {
    private static String ACCELERATOR_PATTERN = "(.+)\\[(.+?)\\]\\s*(\\{.+?\\})?";
    @Autowired
    private MessageService messages;
    @Autowired
    private FormFieldControllerFactory fieldControllerFactory;
    @Autowired
    private RestClient restClient;
    @Autowired
    private UICommands uiCommands;
    private FormPropertyFieldBuilder propertyFieldBuilder = new FormPropertyFieldBuilder();
    private static Logger logger = LoggerFactory.getLogger((String)"FormView");

    public Label createAcceleratedLabel(EFormDescriptor.EFormFieldDescriptor desc) {
        return this.createAcceleratedLabel(desc.getLabel(), desc.getGlyph(), new Object[0]);
    }

    public Label createAcceleratedLabel(ESearchDescriptor.ESearchFieldDescriptor desc) {
        return this.createAcceleratedLabel(desc.getLabel(), desc.getGlyph(), new Object[0]);
    }

    public Label createAcceleratedLabel(String txt, String glyph, Object ... args) {
        String text = this.messages.getMessage(txt, args);
        String[] parsed = ControlsFactoryService.parseAcceleratedLabel((String)text);
        PFXLabel label = new PFXLabel();
        String[] split = parsed[0].split(",");
        label.setLabelText(split.length == 2 ? split[1].trim() : split[0].trim());
        if (parsed.length > 1 && parsed[1] != null && !"".equals(parsed[1])) {
            label.setAcceleratorString(parsed[1]);
        }
        if (glyph != null) {
            label.setGlyph(glyph);
        }
        return label;
    }

    public Tab createAcceleratedTab(DLineDescriptor desc) {
        String text = this.messages.getMessage(desc.getLabel(), new Object[0]);
        String[] parsed = ControlsFactoryService.parseAcceleratedLabel((String)text);
        String[] split = parsed[0].split(",");
        PFXTab tab = new PFXTab();
        tab.setTabText(split.length == 2 ? split[1].trim() : split[0].trim());
        if (parsed.length > 1 && parsed[1] != null && !"".equals(parsed[1])) {
            tab.setAcceleratorString(parsed[1]);
        }
        if (desc.getGlyph() != null) {
            tab.setGlyph(desc.getGlyph());
        }
        return tab;
    }

    public FormFieldContainer createFormFieldContainer(EFormDescriptor.EFormFieldDescriptor fieldDescriptor, Control c, Orientation fieldOrientation) {
        return new FormFieldContainer(fieldDescriptor.getFieldId(), this.createAcceleratedLabel(fieldDescriptor), GlyphFactory.createGlyph((String)fieldDescriptor.getGlyph()), c, fieldDescriptor.getGroupId(), fieldDescriptor.getOrder(), fieldOrientation);
    }

    public FormFieldController createFormFieldController(EFormDescriptor.EFormFieldDescriptor fieldDescriptor) {
        return this.fieldControllerFactory.createController((FormFieldControllerBuilder)this.propertyFieldBuilder, fieldDescriptor);
    }

    public <E extends AbstractEntity> FormView<E> createFormView(EFormDescriptor formDescriptor) {
        return this.createFormView(formDescriptor, Orientation.HORIZONTAL);
    }

    public <E extends AbstractEntity> FormView<E> createFormView(EFormDescriptor formDescriptor, Orientation fieldOrientation) {
        FormView formView = new FormView((ObjectReader)new EntityReader(this.restClient));
        formView.setFieldGroupFactory((Callable)new FormFieldContainerGroupFactory(formDescriptor, this.messages));
        formView.setFieldContainerFactory(fld -> {
            Optional<EFormDescriptor.EFormFieldDescriptor> desc = formDescriptor.getFields().stream().filter(d -> d.getFieldId().equals(fld.getId())).findFirst();
            if (desc.isPresent()) {
                EFormDescriptor.EFormFieldDescriptor d2 = desc.get();
                FormFieldController c = this.createFormFieldController(d2);
                c.bind(fld.getValue());
                fld.getValue().addListener((o, ov, nv) -> logger.debug(String.valueOf(formDescriptor.getFormId()) + " - " + d2.getLabel() + " : " + nv));
                ControlUtil.transferFocusOnEnter((Control)c.getControl());
                if (formView.getFormMode() == FormView.FormMode.UPDATE && !desc.get().isUpdatable()) {
                    c.getControl().setDisable(true);
                }
                FormFieldContainer container = this.createFormFieldContainer(d2, c.getControl(), fieldOrientation);
                return container;
            }
            return null;
        });
        return formView;
    }

    public <E extends AbstractEntity> List<TreeTableColumn<E, String>> createTreeTableColumns(ETableDescriptor d) {
        ArrayList columns = new ArrayList();
        d.getColumns().stream().map(c -> {
            TreeTableColumn column = TreeTableColumnFactory.createColumn((ETableDescriptor.ETableColumnDescriptor)c);
            column.setText(ControlsFactoryService.parseAcceleratedLabel((String)this.messages.getMessage(c.getLabel(), new Object[0]))[0]);
            return column;
        }).forEach(column -> {
            boolean bl = columns.add((TreeTableColumn)column);
        });
        return columns;
    }

    public List<TreeTableColumn<Document, BigDecimal>> createTreeTableColumns(DSummaryDescriptor d) {
        ArrayList<TreeTableColumn<Document, BigDecimal>> columns = new ArrayList<TreeTableColumn<Document, BigDecimal>>();
        d.getLines().forEach(item -> item.getSumList().forEach(sum -> {
            TreeTableColumn column = TreeTableColumnFactory.createColumn((DSummaryDescriptor.ESumDescriptor)sum);
            column.setText(ControlsFactoryService.parseAcceleratedLabel((String)this.messages.getMessage(sum.getLabel(), new Object[0]))[0]);
            columns.add(column);
        }));
        d.getSumList().forEach(sum -> {
            TreeTableColumn column = TreeTableColumnFactory.createColumn((DSummaryDescriptor.ESumDescriptor)sum);
            column.setText(ControlsFactoryService.parseAcceleratedLabel((String)this.messages.getMessage(sum.getLabel(), new Object[0]))[0]);
            columns.add(column);
        });
        return columns;
    }

    public boolean validateOnDemand(Node node) {
        Boolean valid = ValidationUtils.validateOnDemand((Node)node);
        if (!valid.booleanValue()) {
            this.uiCommands.showNotification().error().withTitle(this.messages.getMessage("%msg.err.validation.title", new Object[0]), new Object[0]).withText(this.messages.getMessage("%msg.err.validation.text", new Object[0]), new Object[0]).withDuration(4).withPosition(Pos.BOTTOM_RIGHT).execute();
        }
        return valid;
    }

    private static String[] parseAcceleratedLabel(String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return new String[]{""};
        }
        String[] parsed = new String[3];
        Matcher m = Pattern.compile(ACCELERATOR_PATTERN).matcher(text);
        if (m.find()) {
            parsed[0] = m.group(1);
            if (m.groupCount() > 1 && m.group(2) != null) {
                parsed[1] = m.group(2);
            }
            if (m.groupCount() > 2 && m.group(3) != null) {
                parsed[2] = m.group(3).replaceAll("\\{|\\}", "");
            }
        } else {
            parsed[0] = text;
        }
        return parsed;
    }
}

