/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.context;

import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.datamodel.uidescriptors.entity.EBrowserDescriptor;
import rs.tetrabyte.fxml.FXMLValuePair;
import rs.tetrabyte.pezar.browser.EBrowser;
import rs.tetrabyte.pezar.commons.message.ModelChangedNotification;
import rs.tetrabyte.pezar.event.TenantChanged;
import rs.tetrabyte.pezar.event.UserLoggedOut;
import rs.tetrabyte.pezar.rest.UIDescriptorReader;

public class EBrowserContext {
    @Autowired
    private UIDescriptorReader descReader;
    private Map<String, FXMLValuePair<?, ? extends EBrowser>> browsers = new WeakHashMap();
    private Map<String, EBrowserDescriptor> descriptors = new HashMap();

    public FXMLValuePair<?, ? extends EBrowser> getBrowser(String browserId) {
        return (FXMLValuePair)this.browsers.get(browserId);
    }

    public void putBrowser(String browserId, FXMLValuePair<?, ? extends EBrowser> pair) {
        this.browsers.put(browserId, pair);
    }

    public void getBrowserDescriptor(String browserId, Consumer<EBrowserDescriptor> desc) {
        if (this.descriptors.containsKey(browserId)) {
            desc.accept((EBrowserDescriptor)this.descriptors.get(browserId));
        } else {
            this.descReader.readBrowserDescriptorForBrowserId(browserId, descriptor -> {
                this.descriptors.put(browserId, descriptor);
                desc.accept((EBrowserDescriptor)descriptor);
            });
        }
    }

    @Subscribe
    private void tenantChanged(TenantChanged event) {
        this.resetContext();
    }

    @Subscribe
    private void modelChanged(ModelChangedNotification notif) {
        this.resetContext();
    }

    @Subscribe
    private void userLoggedOut(UserLoggedOut event) {
        this.resetContext();
    }

    private void resetContext() {
        this.browsers.clear();
        this.descriptors.clear();
    }
}

