/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.context;

import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.Button;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.datarest.task.RestTaskFactory;
import rs.tetrabyte.pezar.beans.Inventory;
import rs.tetrabyte.pezar.commands.UICommands;
import rs.tetrabyte.pezar.context.ControlsFactoryService;
import rs.tetrabyte.pezar.custom.picker.EntityPicker;
import rs.tetrabyte.pezar.custom.picker.Picker;
import rs.tetrabyte.pezar.custom.picker.PickerFactory;
import rs.tetrabyte.pezar.factory.ButtonFactory;
import rs.tetrabyte.pezar.factory.GlyphFactory;
import rs.tetrabyte.pezar.fxml.factory.PFXButtonBuilder;
import rs.tetrabyte.pezar.rest.UIDescriptorReader;

public class InventoryPickerService {
    @Autowired
    private PickerFactory factory;
    @Autowired
    private UICommands commands;
    @Autowired
    private ButtonFactory buttonFactory;
    @Autowired
    private RestTaskFactory restTaskFactory;
    @Autowired
    private UIDescriptorReader descReader;
    @Autowired
    private ControlsFactoryService cfs;

    public void getInventory(String discriminator, Consumer<Inventory> consumer) {
        this.descReader.readBrowserDescriptorForRepository("inventories", browser -> this.restTaskFactory.createTask(client -> {
            String uri = client.pathBuilder().base().slash("core").slash("inventories").slash("search").slash("discriminator").param("d", discriminator).get();
            return client.getPagedResources(uri, Inventory.class);
        }).whenDone(page -> {
            if (page.getMetadata() == null) {
                return;
            }
            if (page.getMetadata().getTotalElements() == 1L) {
                page.getContent().stream().findFirst().ifPresent(consumer::accept);
            } else {
                Button btnOk = this.buttonFactory.createButton(PFXButtonBuilder.PFXButtonType.Ok);
                EntityPicker picker = new EntityPicker(Inventory.class, String.format("browser[%s]", browser.getBrowserId()));
                picker.setRequired(true);
                picker.setName("inventory");
                Node view = this.factory.createViewBuilder().addPicker((Picker)picker).buildView();
                this.commands.showDialog(Inventory.class).withTitle("%title.choose-inventory", new Object[0]).withContent(view).withGraphic(GlyphFactory.createGlyph((String)"f059", (double)38.0)).withWidth(500).withHeight(100).withButton(btnOk, dlg -> {
                    if (!this.cfs.validateOnDemand((Node)dlg.getDialogPane())) {
                        return;
                    }
                    dlg.setValue((Object)((Inventory)picker.getValue()));
                }).onOpened(dlg -> picker.onPicked(inventory -> dlg.setValue(inventory))).onValueSet(dlg -> {
                    dlg.close();
                    consumer.accept((Inventory)dlg.getValue());
                }).execute();
            }
        }).execute());
    }
}

