/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.context;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.SimpleJasperReportsContext;
import net.sf.jasperreports.engine.fonts.FontExtensionsCollector;
import net.sf.jasperreports.engine.fonts.FontExtensionsReceiver;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.SimpleFontExtensionHelper;
import net.sf.jasperreports.engine.fonts.SimpleFontFace;
import net.sf.jasperreports.engine.fonts.SimpleFontFamily;
import net.sf.jasperreports.engine.util.JRLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.datarest.client.ResourceEntity;
import rs.tetrabyte.datarest.task.RestTaskFactory;
import rs.tetrabyte.fxml.FXMLTaskFactory;
import rs.tetrabyte.pezar.beans.Document;
import rs.tetrabyte.pezar.beans.Resident;
import rs.tetrabyte.pezar.commands.UICommands;
import rs.tetrabyte.pezar.context.TenantContext;
import rs.tetrabyte.pezar.controller.ReportViewController;
import rs.tetrabyte.task.TaskFactory;

public class ReportingService {
    private static Logger logger = LoggerFactory.getLogger(ReportingService.class);
    @Autowired
    private RestTaskFactory restTaskFactory;
    @Autowired
    private TaskFactory taskFactory;
    @Autowired
    private FXMLTaskFactory fxmlTaskFactory;
    @Autowired
    private UICommands uiCommands;
    @Autowired
    private TenantContext tenantContext;
    private JasperReportsContext context;

    public void showReport(Document document) {
        this.restTaskFactory.createTask(client -> {
            JasperPrint print;
            logger.debug("Loading document report: {}", (Object)document.getLink("report").getHref());
            byte[] report = (byte[])client.getHttpClient().get(client.expand(document.getLink("report").getHref()), byte[].class).getBody();
            ByteArrayInputStream is = null;
            try {
                is = new ByteArrayInputStream(report);
                print = (JasperPrint)JRLoader.loadObject((InputStream)is);
                is.close();
            }
            catch (IOException | JRException e) {
                logger.error(String.format("Error while loading document report. document[ %s ]", document.getLink("report").getHref()), e);
                return null;
            }
            return print;
        }).whenDone(print -> this.taskFactory.createTask(() -> this.getJasperContext()).whenDone(contex -> this.fxmlTaskFactory.createTask(ReportViewController.class).output(new Object[]{print}).output(new Object[]{this.context}).whenDone(pair -> this.uiCommands.displayContent(pair.getView()).execute()).execute()).execute()).execute();
    }

    private JasperReportsContext getJasperContext() {
        if (this.context == null) {
            SimpleJasperReportsContext simpleContext = new SimpleJasperReportsContext();
            if (this.tenantContext.getActiveResident().isPresent()) {
                ResourceEntity reports = ((Resident)this.tenantContext.getActiveResident().get()).getRelatedEntity("reports", ResourceEntity.class);
                this.loadFonts(simpleContext, reports);
                this.loadDefaultProperties(simpleContext.getParent(), reports);
            }
            this.context = simpleContext;
        }
        return this.context;
    }

    private void loadFonts(SimpleJasperReportsContext context, ResourceEntity reports) {
        if (!reports.hasLink("fonts")) {
            return;
        }
        try {
            String fontsUrl = reports.getLink("fonts").getHref();
            InputStream is = new URL(fontsUrl).openStream();
            FontExtensionsCollector collector = new FontExtensionsCollector();
            SimpleFontExtensionHelper.getInstance().loadFontExtensions((JasperReportsContext)context, is, (FontExtensionsReceiver)collector, false);
            is.close();
            collector.getFontFamilies().forEach(family -> {
                SimpleFontFamily sff = (SimpleFontFamily)family;
                this.loadFont(fontsUrl, (SimpleFontFace)sff.getNormalFace());
                this.loadFont(fontsUrl, (SimpleFontFace)sff.getBoldFace());
                this.loadFont(fontsUrl, (SimpleFontFace)sff.getItalicFace());
                this.loadFont(fontsUrl, (SimpleFontFace)sff.getBoldItalicFace());
            });
            context.setExtensions(FontFamily.class, collector.getFontFamilies());
        }
        catch (Exception e) {
            logger.error("Error while loading fonts", (Throwable)e);
        }
    }

    private void loadFont(String fontsUrl, SimpleFontFace fontFace) {
        fontFace.setTtf(String.valueOf(fontsUrl.replace("fonts.xml", "")) + fontFace.getTtf());
    }

    private void loadDefaultProperties(JasperReportsContext context, ResourceEntity reports) {
        if (!reports.hasLink("config")) {
            return;
        }
        Properties defaultProperties = new Properties();
        InputStream is = null;
        try {
            is = new URL(reports.getLink("config").getHref()).openStream();
            defaultProperties.load(is);
            defaultProperties.entrySet().forEach(entry -> context.setProperty(entry.getKey().toString(), entry.getValue().toString()));
            is.close();
        }
        catch (Exception e) {
            logger.error("Error while loading default properties", (Throwable)e);
        }
    }
}

