/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.datamodel.uidescriptors.features.UIFeatureDescriptor;
import rs.tetrabyte.fxml.LocaleContext;
import rs.tetrabyte.pezar.features.UIFeature;
import rs.tetrabyte.pezar.features.UIFeatureBuilder;
import rs.tetrabyte.pezar.features.UIFeatureFactory;
import rs.tetrabyte.pezar.rest.UIDescriptorReader;

public class UIFeatureService {
    @Autowired
    private UIDescriptorReader uiDescriptorReader;
    @Autowired
    private UIFeatureFactory factory;
    @Autowired
    private LocaleContext localeCtx;
    private ObservableList<UIFeature> features = FXCollections.observableArrayList();
    private List<Consumer<List<? extends UIFeature>>> consumers = new ArrayList();
    private BooleanProperty fetching;
    private boolean fetched = false;
    private List<UIFeature> temp = new ArrayList();

    public UIFeatureService() {
        this.features.addListener((ListChangeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    void fetchFeatures() {
        this.setFetching(true);
        this.uiDescriptorReader.readTreeFeatureDescriptorRoot(root -> {
            if (root.getChildren() != null) {
                this.fetched = true;
                this.registerFeatures(root.getChildren(), root.getFeatureId());
                this.setFetching(false);
                this.features.addAll((Collection)this.temp);
                this.temp.clear();
            }
        });
    }

    void registerFeatures(List<UIFeatureDescriptor> descriptors, String parentId) {
        for (UIFeatureDescriptor descriptor : descriptors) {
            UIFeature feature = this.factory.createFeature(descriptor, parentId);
            this.registerFeature(new UIFeature[]{feature});
            if (descriptor.getChildren() == null || descriptor.getChildren().size() <= 0) continue;
            this.registerFeatures(descriptor.getChildren(), descriptor.getFeatureId());
        }
    }

    void registerFeatures(List<UIFeature> features) {
        if (!this.fetched) {
            this.temp.addAll(features);
        } else {
            this.features.addAll(features);
        }
    }

    void registerFeature(UIFeature ... feature) {
        this.registerFeatures(Arrays.asList(feature));
    }

    public void getFeatures(Consumer<List<? extends UIFeature>> features) {
        this.consumers.add(features);
        features.accept(new ArrayList(this.features));
    }

    void clear() {
        this.features.clear();
        this.consumers.clear();
        this.temp.clear();
        this.fetched = false;
        this.fetching = new SimpleBooleanProperty();
    }

    public final BooleanProperty fetchingProperty() {
        return this.fetching;
    }

    public final boolean isFetching() {
        return this.fetchingProperty().get();
    }

    final void setFetching(boolean fetching) {
        this.fetchingProperty().set(fetching);
    }

    public UIFeatureBuilder getBuilder() {
        return new UIFeatureBuilder(this.localeCtx);
    }

    static /* synthetic */ List access$0(UIFeatureService uIFeatureService) {
        return uIFeatureService.consumers;
    }
}

