/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.context;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import javafx.scene.Parent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import rs.tetrabyte.datarest.client.ResourceEntity;
import rs.tetrabyte.datarest.task.RestTaskFactory;
import rs.tetrabyte.pezar.context.UiSettingService;

public class UiSettingService {
    private static final Logger logger = LoggerFactory.getLogger(UiSettingService.class);
    private final RestTaskFactory rest;
    private final List<UiSettingFactory<?>> factories;

    public UiSettingService(RestTaskFactory rest) {
        this.rest = rest;
        this.factories = new ArrayList();
        this.factories.add(new ColumnSettingsFactory(null));
    }

    public void registerSettingFactory(UiSettingFactory<?> factory) {
        if (!this.factories.stream().filter(f -> f.getClass().equals(factory.getClass())).findAny().isPresent()) {
            this.factories.add(factory);
        }
    }

    public <T> void save(UiSetting<T> setting) {
        if (setting == null) {
            return;
        }
        if (setting.getSettingId() == null) {
            logger.debug("Can't save setting that doesn't have an ID");
        } else {
            this.rest.createTask(client -> (UiSetting)client.insert(client.pathBuilder().base().slash("account/ui").get(), (ResourceEntity)setting)).whenDone(d -> logger.debug("UI setting saved: " + setting.getSettingId())).ifFailed(e -> logger.warn("Failed to save UI setting: " + setting.getSettingId(), e)).execute();
        }
    }

    public void save(Node node) {
        this.factories.forEach(f -> {
            if (f.accept(node)) {
                if (node.getId() == null) {
                    logger.debug("Node does not have an ID. Skipping state save " + node);
                    return;
                }
                UiSetting setting = f.toSetting(node);
                this.save(setting);
            } else if (node instanceof Parent) {
                Parent parent = (Parent)node;
                parent.getChildrenUnmodifiable().forEach(child -> this.save(child));
            }
        });
    }

    public <T> void restore(String settingId, Class<T> type, Consumer<UiSetting<T>> setting) {
        this.rest.createTask(client -> {
            String uri = String.valueOf(client.pathBuilder().base().slash("account/ui").slash(settingId).get()) + "?" + client.getTrailingParams();
            logger.debug("Loading UI setting: {} [ {} ] ", (Object)settingId, (Object)uri);
            return client.getHttpClient().get(uri, (ParameterizedTypeReference)new UiSettingTypeReference(this, type));
        }).whenDone(s -> {
            if (setting != null && s != null && s.getBody() != null && ((UiSetting)s.getBody()).getValue() != null) {
                setting.accept((UiSetting)s.getBody());
            }
        }).ifFailed(e -> logger.warn("Failed to load UI setting: " + settingId, e)).execute();
    }

    public void restore(Node node) {
        this.factories.forEach(f -> {
            if (f.accept(node)) {
                if (node.getId() == null) {
                    logger.debug("Node does not have an ID. Skipping state restore " + node);
                    return;
                }
                this.restore(node.getId(), f.getValueType(), setting -> {
                    f.restore(node, setting);
                    logger.debug("Node state restored: " + node.getId());
                });
            } else if (node instanceof Parent) {
                Parent parent = (Parent)node;
                parent.getChildrenUnmodifiable().forEach(child -> this.restore(child));
                parent.getChildrenUnmodifiable().addListener((ListChangeListener)new /* Unavailable Anonymous Inner Class!! */);
            }
        });
    }
}

