/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller;

import com.google.common.eventbus.Subscribe;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.shape.Circle;
import javafx.util.Callback;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.fxml.FXMLController;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.pezar.context.TenantContext;
import rs.tetrabyte.pezar.context.UIFeatureService;
import rs.tetrabyte.pezar.custom.LockablePane;
import rs.tetrabyte.pezar.custom.LockablePaneWrapper;
import rs.tetrabyte.pezar.custom.factory.cell.FeaturesTreeCellFactory;
import rs.tetrabyte.pezar.event.TenantChanged;
import rs.tetrabyte.pezar.features.UIFeature;
import rs.tetrabyte.pezar.features.UIFeatureDefault;
import rs.tetrabyte.pezar.features.event.UIEvent;

@FXMLView(value="/fxml/FeaturesTreeView.fxml", wrappers={LockablePaneWrapper.class})
public class FeaturesTreeViewController
extends FXMLController {
    @FXML
    private TreeView<UIFeature> treeView;
    @FXML
    private BorderPane pnlImage;
    @FXML
    private ImageView imageView;
    @FXML
    private Label lblActiveResident;
    @FXML
    private Label lblActiveYear;
    @Autowired
    private TenantContext tenantContext;
    @Autowired
    private UIFeatureService featureService;
    private TreeItem<UIFeature> rootItem;

    @PostConstruct
    private void start() {
        this.rootItem = new TreeItem((Object)new UIFeatureDefault("root", "", "", null), null);
        this.treeView.setRoot(this.rootItem);
        ((LockablePane)this.getRootNode(LockablePane.class)).lockedProperty().bind((ObservableValue)this.featureService.fetchingProperty());
        this.featureService.getFeatures(features -> features.forEach(arg_0 -> this.addFeature(arg_0)));
        this.postConstruct();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.treeView.setCellFactory((Callback)new FeaturesTreeCellFactory());
        this.treeView.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ENTER) {
                this.handleAction(e);
            }
        });
        this.treeView.addEventFilter(MouseEvent.MOUSE_CLICKED, e -> {
            if (e.getClickCount() == 2) {
                this.handleAction(e);
            }
        });
        this.treeView.setOnDragDetected(e -> {});
    }

    private void postConstruct() {
        this.tenantContext.getActiveResident().ifPresent(r -> {
            this.lblActiveResident.setText(r.getName());
            this.lblActiveYear.setText(this.tenantContext.getActiveYear());
            String url = r.getLink("logo").getHref();
            this.imageView.setImage(new Image(url));
            this.pnlImage.setStyle("-fx-background-color: white");
            Circle c = new Circle(0.0, 60.0, 120.0);
            c.setSmooth(true);
            c.setCache(true);
            this.pnlImage.setClip((Node)c);
        });
        this.treeView.requestFocus();
        if (this.rootItem.getChildren().size() > 0) {
            this.treeView.getSelectionModel().select((Object)((TreeItem)this.rootItem.getChildren().get(0)));
        }
    }

    @Subscribe
    public void tenantChanged(TenantChanged event) {
        this.lblActiveYear.setText(event.getYear());
    }

    private void addFeature(UIFeature feature) {
        TreeItem parent = "root".equals(feature.getParentId()) ? this.rootItem : this.getItemById((List)this.rootItem.getChildren(), feature.getParentId());
        TreeItem ftrItem = this.createItem(feature);
        if (parent != null) {
            parent.getChildren().add((Object)ftrItem);
        } else {
            this.rootItem.getChildren().add((Object)ftrItem);
        }
    }

    private TreeItem<UIFeature> createItem(UIFeature ftr) {
        if (ftr == null) {
            return null;
        }
        TreeItem itm = new TreeItem((Object)ftr);
        if (ftr.getChildren() == null) {
            return itm;
        }
        ftr.getChildren().stream().forEach(f -> {
            boolean bl = itm.getChildren().add((Object)this.createItem(f));
        });
        return itm;
    }

    private TreeItem<UIFeature> getItemById(List<TreeItem<UIFeature>> items, String featureId) {
        if (featureId == null) {
            return null;
        }
        if (items == null || items.size() == 0) {
            return null;
        }
        TreeItem retItem = null;
        for (TreeItem treeItem : items) {
            if (featureId.equals(((UIFeature)treeItem.getValue()).getId())) {
                retItem = treeItem;
                continue;
            }
            TreeItem tmp = this.getItemById((List)treeItem.getChildren(), featureId);
            if (tmp == null) continue;
            retItem = tmp;
        }
        return retItem;
    }

    @FXML
    public void onKeyReleased(KeyEvent event) {
    }

    @FXML
    public void onMouseClicked(MouseEvent event) {
    }

    private void handleAction(Event evt) {
        UIFeature feature = (UIFeature)((TreeItem)this.treeView.getSelectionModel().getSelectedItem()).getValue();
        if (feature == null || feature.getOnAction() == null) {
            return;
        }
        feature.getOnAction().handle((Event)new UIEvent(null, evt));
    }
}

