/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.shape.Circle;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.fxml.FXMLTaskFactory;
import rs.tetrabyte.fxml.PostLoad;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.fxml.annotation.Input;
import rs.tetrabyte.pezar.commands.DisplayContent;
import rs.tetrabyte.pezar.commands.UICommands;
import rs.tetrabyte.pezar.context.LogInService;
import rs.tetrabyte.pezar.context.TenantContext;
import rs.tetrabyte.pezar.controller.ServersViewController;
import rs.tetrabyte.pezar.factory.field.util.ControlUtil;
import rs.tetrabyte.pezar.settings.Server;

@FXMLView(value="/fxml/LoginView.fxml")
public class LoginViewController
implements Initializable,
PostLoad {
    @FXML
    private TextField txtUsername;
    @FXML
    private PasswordField txtPassword;
    @FXML
    private CheckBox cbRememberMe;
    @FXML
    private Button btnLogIn;
    @FXML
    private Label lblMessage;
    @FXML
    private FlowPane pnlLogo;
    @Autowired
    private FXMLTaskFactory fxmlTaskFactory;
    @Autowired
    private UICommands uiCommands;
    @Autowired
    private LogInService loginService;
    @Autowired
    private TenantContext tenantContext;
    @Input
    private Server server;

    @FXML
    public void login(ActionEvent event) {
        if (StringUtils.isEmpty((CharSequence)this.txtUsername.getText()) || StringUtils.isEmpty((CharSequence)this.txtPassword.getText())) {
            this.lblMessage.setVisible(true);
        } else {
            this.lblMessage.setVisible(false);
            this.uiCommands.lockUI().execute();
            this.loginService.login(this.txtUsername.getText(), this.txtPassword.getText(), (LogInService.LoginHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    @FXML
    public void onServerList(ActionEvent event) {
        this.fxmlTaskFactory.createTask(ServersViewController.class).whenDone(vp -> {
            this.uiCommands.clearScreen().execute();
            this.uiCommands.displayContent((Node)((Parent)vp.getView())).in(DisplayContent.TargetContainer.Screen).closable(false).execute();
        }).execute();
    }

    public void initialize(URL location, ResourceBundle resources) {
        ControlUtil.transferFocusOnArrowKeys((Control[])new Control[]{this.txtUsername, this.txtPassword});
        ControlUtil.transferFocusOnEnter((Control[])new Control[]{this.txtUsername, this.txtPassword});
        this.cbRememberMe.selectedProperty().addListener((o, ov, nv) -> {
            if (!nv.booleanValue()) {
                this.server.setPassword(null);
            }
        });
        this.setServer();
    }

    public void postLoad() {
        if (!StringUtils.isEmpty((CharSequence)this.txtUsername.getText())) {
            this.txtPassword.requestFocus();
        } else {
            this.txtUsername.requestFocus();
        }
        if (!StringUtils.isEmpty((CharSequence)this.txtPassword.getText()) && !StringUtils.isEmpty((CharSequence)this.txtUsername.getText())) {
            this.btnLogIn.requestFocus();
        }
    }

    private void setServer() {
        String userName = this.server.getUserName();
        String password = this.server.getPassword();
        if (!StringUtils.isEmpty((CharSequence)userName)) {
            this.txtUsername.setText(userName);
        }
        if (!StringUtils.isEmpty((CharSequence)password)) {
            // empty if block
        }
        this.txtPassword.setText(password);
        if (!StringUtils.isEmpty((CharSequence)userName) && !StringUtils.isEmpty((CharSequence)password)) {
            this.cbRememberMe.setSelected(true);
        }
        this.tenantContext.getResidents().stream().forEach(r -> {
            if (r.hasLink("logo")) {
                ImageView image = new ImageView(r.getLink("logo").getHref());
                image.setFitWidth(100.0);
                image.setFitHeight(100.0);
                image.setPreserveRatio(true);
                image.setSmooth(true);
                image.setCache(true);
                BorderPane p = new BorderPane();
                p.getStyleClass().add((Object)"logo-view");
                p.setPrefHeight(95.0);
                p.setPrefWidth(95.0);
                p.setCenter((Node)image);
                Circle circle = new Circle(50.0, 50.0, 46.0);
                p.setClip((Node)circle);
                this.pnlLogo.getChildren().add((Object)p);
            }
        });
    }

    static /* synthetic */ UICommands access$0(LoginViewController loginViewController) {
        return loginViewController.uiCommands;
    }

    static /* synthetic */ Label access$1(LoginViewController loginViewController) {
        return loginViewController.lblMessage;
    }

    static /* synthetic */ Server access$2(LoginViewController loginViewController) {
        return loginViewController.server;
    }

    static /* synthetic */ TextField access$3(LoginViewController loginViewController) {
        return loginViewController.txtUsername;
    }

    static /* synthetic */ CheckBox access$4(LoginViewController loginViewController) {
        return loginViewController.cbRememberMe;
    }

    static /* synthetic */ PasswordField access$5(LoginViewController loginViewController) {
        return loginViewController.txtPassword;
    }
}

