/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Resource;
import rs.tetrabyte.datarest.client.RestClient;
import rs.tetrabyte.fxml.FXMLController;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.pezar.commands.UICommands;
import rs.tetrabyte.pezar.context.ControlsFactoryService;
import rs.tetrabyte.pezar.context.FocusService;
import rs.tetrabyte.pezar.context.MessageService;
import rs.tetrabyte.pezar.context.ParameterService;
import rs.tetrabyte.pezar.context.data.Parameters;
import rs.tetrabyte.pezar.controller.FormFieldController;
import rs.tetrabyte.pezar.custom.FormFieldContainer;
import rs.tetrabyte.pezar.custom.PopupWrapper;
import rs.tetrabyte.pezar.factory.GlyphFactory;

@FXMLView(value="/fxml/ParametersView.fxml", wrappers={PopupWrapper.class})
public class ParametersViewController
extends FXMLController {
    @FXML
    private VBox setPane;
    @FXML
    private BorderPane groupsPane;
    @Autowired
    private ParameterService paramService;
    @Autowired
    private MessageService messages;
    @Autowired
    private ControlsFactoryService cfs;
    @Autowired
    private UICommands uiCommands;
    @Autowired
    private FocusService focusService;
    @Autowired
    private RestClient client;
    private List<Parameters.Parameter> parameters = new ArrayList();

    @FXML
    void onSave(ActionEvent e) {
        this.paramService.saveParameters(this.parameters, () -> {
            this.uiCommands.popContent().execute();
            this.uiCommands.showNotification().success().withText(this.messages.getMessage("%msg.save-success", new Object[0]), new Object[0]).withDuration(1).withPosition(Pos.CENTER).execute();
        });
    }

    @FXML
    void onCancel(ActionEvent e) {
        this.uiCommands.popContent().execute();
    }

    @PostConstruct
    private void createUI() {
        this.getSets(sets -> {
            sets.getSets().forEach(set -> {
                Button button = this.createButton(set);
                button.getStyleClass().add((Object)"btn-shortcut");
                this.setPane.getChildren().add((Object)button);
                VBox parametersBox = new VBox(10.0);
                set.getGroups().forEach(group -> {
                    TitledPane groupPane = this.createGroupPane(group);
                    parametersBox.getChildren().add((Object)groupPane);
                });
                button.getProperties().put((Object)"pane", (Object)parametersBox);
                button.setOnAction(e -> {
                    this.groupsPane.setCenter((Node)parametersBox);
                    this.focusService.setFocus((Node)parametersBox);
                });
            });
            if (this.setPane.getChildren().size() > 0) {
                ((Button)this.setPane.getChildren().get(0)).getOnAction().handle(null);
            }
        });
    }

    private void getSets(Consumer<Parameters> sets) {
        this.doAsync(() -> {
            Resource root = this.client.getResource(this.client.pathBuilder().base().slash("core").get());
            Resource parameters = this.client.getResource(root.getLink("parameters"));
            return (Parameters)this.client.getSingle(parameters.getLink("sets"), Parameters.class);
        }).whenDone(params -> sets.accept((Parameters)params));
    }

    private Button createButton(Parameters.ParameterSet set) {
        Button button = new Button();
        Node glyph = null;
        glyph = !StringUtils.isEmpty((CharSequence)set.getGlyph()) ? GlyphFactory.createGlyph((String)set.getGlyph()) : GlyphFactory.createGlyph((String)"f128");
        Label label = new Label(this.messages.getMessage(set.getLabel(), new Object[0]));
        label.setWrapText(true);
        label.getStyleClass().add((Object)"text");
        label.setTextAlignment(TextAlignment.CENTER);
        VBox box = new VBox(5.0, new Node[]{glyph, label});
        box.setAlignment(Pos.CENTER);
        button.setGraphic((Node)box);
        return button;
    }

    private TitledPane createGroupPane(Parameters.ParameterGroup group) {
        VBox parametersBox = new VBox(5.0);
        group.getParameters().forEach(param -> {
            this.parameters.add(param);
            FormFieldController controller = this.cfs.createFormFieldController(param.getDescriptor());
            controller.bind(param.valueProperty());
            FormFieldContainer container = this.cfs.createFormFieldContainer(param.getDescriptor(), controller.getControl(), Orientation.HORIZONTAL);
            parametersBox.getChildren().add((Object)container);
        });
        TitledPane groupPane = new TitledPane(this.messages.getMessage(group.getLabel(), new Object[0]), (Node)parametersBox);
        groupPane.setFocusTraversable(false);
        return groupPane;
    }
}

