/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller;

import java.util.stream.Collectors;
import javafx.beans.property.SimpleStringProperty;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.datarest.task.RestTaskFactory;
import rs.tetrabyte.fxml.FXMLController;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.pezar.beans.Resident;
import rs.tetrabyte.pezar.commands.UICommands;
import rs.tetrabyte.pezar.controller.ResidentFormViewController;
import rs.tetrabyte.pezar.custom.LockablePane;
import rs.tetrabyte.pezar.custom.LockablePaneWrapper;
import rs.tetrabyte.task.UIAccessor;

@FXMLView(value="/fxml/resident/ResidentsView.fxml", wrappers={LockablePaneWrapper.class})
public class ResidentsViewController
extends FXMLController {
    @FXML
    TableView<Resident> tableView;
    @FXML
    TableColumn<Resident, String> colName;
    @FXML
    TableColumn<Resident, String> colId;
    @FXML
    TableColumn<Resident, String> colYears;
    @Autowired
    RestTaskFactory restTaskFactory;
    @Autowired
    UICommands uiCommands;
    LockablePane rootPane;

    @PostConstruct
    private void init() {
        this.rootPane = (LockablePane)this.getRootNode(LockablePane.class);
        this.colName.setCellValueFactory(a -> ((Resident)a.getValue()).nameProperty());
        this.colId.setCellValueFactory(a -> ((Resident)a.getValue()).residentIdProperty());
        this.colYears.setCellValueFactory(a -> new SimpleStringProperty(((Resident)a.getValue()).getYears().stream().collect(Collectors.joining(", "))));
        this.restTaskFactory.createTask(client -> client.getResources(client.pathBuilder().base().slash("residents").get(), Resident.class)).whenDone(residents -> this.tableView.getItems().addAll(residents.getContent())).uiAccessor((UIAccessor)this.rootPane).execute();
        this.tableView.getSelectionModel().select(this.tableView.getItems().size() > 0 ? 0 : -1);
        this.tableView.requestFocus();
    }

    @FXML
    public void onNew(ActionEvent event) {
        this.loadView(ResidentFormViewController.class).output(new Object[]{this}).get(view -> this.rootPane.addNodeOnTop(view));
    }

    @FXML
    public void onEdit(ActionEvent event) {
        if (this.tableView.getSelectionModel().getSelectedItem() != null) {
            this.loadView(ResidentFormViewController.class).output(new Object[]{this}).output(new Object[]{this.tableView.getSelectionModel().getSelectedItem()}).get(view -> this.rootPane.addNodeOnTop(view));
        }
    }

    @FXML
    public void onDelete(ActionEvent event) {
        Resident temp = (Resident)this.tableView.getSelectionModel().getSelectedItem();
        if (temp == null) {
            return;
        }
        this.uiCommands.showAlert().confirm().withMessage("%alert.delete.msg", new Object[0]).withTitle("%alert.delete.title", new Object[0]).onConfirmed(e -> this.restTaskFactory.createTask(cli -> cli.delete(temp.getId())).whenDone(c -> this.tableView.getItems().remove((Object)temp)).execute()).execute();
    }

    @FXML
    public void onRefresh(ActionEvent event) {
        this.restTaskFactory.createTask(client -> client.getResources(client.pathBuilder().base().slash("residents").get(), Resident.class)).whenDone(residents -> this.tableView.getItems().setAll(residents.getContent())).uiAccessor((UIAccessor)this.rootPane).execute();
    }

    void addResident(Resident resident) {
        this.rootPane.popNode();
        this.tableView.getItems().add((Object)resident);
        this.tableView.getSelectionModel().select(this.tableView.getItems().size() - 1);
        this.tableView.requestFocus();
    }

    void updateResident(Resident resident) {
        this.tableView.getItems().set(this.tableView.getSelectionModel().getSelectedIndex(), (Object)resident);
        this.rootPane.popNode();
        this.tableView.requestFocus();
    }
}

