/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import rs.tetrabyte.datamodel.uidescriptors.entity.ESearchDescriptor;
import rs.tetrabyte.datarest.fx.RepositoryFX;
import rs.tetrabyte.pezar.beans.AbstractEntity;
import rs.tetrabyte.pezar.controller.FormFieldController;
import rs.tetrabyte.pezar.custom.SearchFormView;
import rs.tetrabyte.pezar.factory.GlyphFactory;
import rs.tetrabyte.pezar.factory.field.search.SearchFieldFactory;
import rs.tetrabyte.pezar.factory.field.util.SearchObject;

public class SearchFormViewController
implements Initializable {
    private SearchFormView searchView;
    private ESearchDescriptor descriptor;
    private SearchFieldFactory factory;
    private SearchObject search;

    public SearchFormViewController(SearchFormView search, ESearchDescriptor desc, SearchFieldFactory factory) {
        this.searchView = search;
        this.descriptor = desc;
        this.factory = factory;
    }

    public void setRepository(RepositoryFX<AbstractEntity> repo) {
        this.search = new SearchObject(repo);
        this.searchView.getButtonBar().getButtons().stream().filter(b -> b.getId().equals("btn-search")).findFirst().ifPresent(b -> ((Button)b).setOnAction(e -> this.search.executeSearch()));
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.descriptor.getFields().forEach(desc -> {
            FormFieldController ctrl = this.factory.createControl(desc);
            SearchObject.Property prop = new SearchObject.Property();
            prop.setName(desc.getFieldId());
            prop.setType(desc.getType());
            ctrl.bind(prop.valueProperty());
            this.search.addProperty(prop);
            this.searchView.addField(desc.getFieldId(), desc.getLabel(), GlyphFactory.createGlyph((String)desc.getGlyph()), ctrl.getControl(), desc.getGroupId());
        });
    }
}

