/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.fxml.PostLoad;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.fxml.annotation.Input;
import rs.tetrabyte.pezar.commands.UICommands;
import rs.tetrabyte.pezar.settings.Server;

@FXMLView(value="/fxml/ServerParamsView.fxml")
public class ServerParamsViewController
implements Initializable,
PostLoad {
    @FXML
    private TextField txtServerName;
    @FXML
    private TextField txtServerURL;
    @FXML
    private ComboBox<String> cbLanguage;
    @FXML
    private Label lblError;
    @Autowired
    private UICommands uiCommands;
    @Input
    private ListView<Server> listView;
    @Input
    private Boolean isUpdate;

    @FXML
    public void onOK(ActionEvent event) {
        try {
            URL url = new URL(this.txtServerURL.getText().trim());
            HttpURLConnection huc = (HttpURLConnection)url.openConnection();
            huc.setRequestMethod("HEAD");
            int responseCode = huc.getResponseCode();
            if (responseCode == 404) {
                this.uiCommands.showNotification().withTitle("Server URL error", new Object[0]).withText("Bad server URL", new Object[0]).error().withPosition(Pos.CENTER).execute();
                return;
            }
            if (!this.isUpdate.booleanValue()) {
                Server server = new Server();
                server.setId(Integer.valueOf(this.listView.getItems().size()));
                server.setName(this.txtServerName.getText());
                server.setUrl(this.txtServerURL.getText());
                this.listView.getItems().add((Object)server);
                this.listView.getSelectionModel().select(this.listView.getItems().size() - 1);
            } else {
                int index = this.listView.getSelectionModel().getSelectedIndex();
                Server server = (Server)this.listView.getSelectionModel().getSelectedItem();
                server.setName(this.txtServerName.getText());
                server.setUrl(this.txtServerURL.getText());
                this.listView.getItems().set(index, (Object)server);
                this.listView.getSelectionModel().select(index);
            }
            this.uiCommands.popContent().execute();
        }
        catch (Exception e) {
            this.uiCommands.showNotification().withText(e.getMessage(), new Object[0]).error().withPosition(Pos.CENTER).execute();
        }
    }

    @FXML
    public void onCancel(ActionEvent event) {
        this.uiCommands.popContent().execute();
    }

    public void postLoad() {
        this.txtServerName.requestFocus();
    }

    public void initialize(URL location, ResourceBundle resources) {
        if (this.isUpdate.booleanValue()) {
            Server server = (Server)this.listView.getSelectionModel().getSelectedItem();
            this.txtServerName.setText(server.getName());
            this.txtServerURL.setText(server.getUrl());
        } else {
            this.txtServerURL.setText("http://");
        }
    }
}

