/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller;

import java.net.URL;
import java.util.Collection;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.ListView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.datarest.task.RestTaskFactory;
import rs.tetrabyte.fxml.FXMLTaskFactory;
import rs.tetrabyte.fxml.Output;
import rs.tetrabyte.fxml.PostLoad;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.pezar.beans.Resident;
import rs.tetrabyte.pezar.commands.DisplayContent;
import rs.tetrabyte.pezar.commands.UICommands;
import rs.tetrabyte.pezar.context.LogInService;
import rs.tetrabyte.pezar.context.TenantContext;
import rs.tetrabyte.pezar.context.data.Server;
import rs.tetrabyte.pezar.controller.LoginViewController;
import rs.tetrabyte.pezar.controller.ServerParamsViewController;
import rs.tetrabyte.pezar.settings.LocalSettingsManager;

@FXMLView(value="/fxml/ServersView.fxml")
public class ServersViewController
implements Initializable,
PostLoad {
    @FXML
    private ListView<rs.tetrabyte.pezar.settings.Server> serverList;
    @Autowired
    private FXMLTaskFactory fxmlTaskFactory;
    @Autowired
    private UICommands uiCommands;
    @Autowired
    private LocalSettingsManager settingsManager;
    @Autowired
    private RestTaskFactory restTaskFactory;
    @Autowired
    private LogInService loginService;
    @Autowired
    private TenantContext tenantContext;
    private String locale;
    private rs.tetrabyte.pezar.settings.Server server;

    @FXML
    public void onNew(ActionEvent event) {
        this.fxmlTaskFactory.createTask(ServerParamsViewController.class).output(Output.values((Object[])new Object[]{this.serverList, new Boolean(false)})).whenDone(v -> this.uiCommands.displayContent((Node)((Parent)v.getView())).closable(false).in(DisplayContent.TargetContainer.Screen).execute()).execute();
    }

    @FXML
    public void onEdit(ActionEvent event) {
        this.fxmlTaskFactory.createTask(ServerParamsViewController.class).output(Output.values((Object[])new Object[]{this.serverList, new Boolean(true)})).whenDone(v -> this.uiCommands.displayContent((Node)((Parent)v.getView())).closable(false).in(DisplayContent.TargetContainer.Screen).execute()).execute();
    }

    @FXML
    public void onDelete(ActionEvent event) {
        this.serverList.getItems().remove(this.serverList.getSelectionModel().getSelectedItem());
    }

    @FXML
    public void onKeyPressed(KeyEvent event) {
        if (event.getCode() == KeyCode.ENTER) {
            this.openLoginScreen();
        }
    }

    @FXML
    public void onMouseClicked(MouseEvent event) {
        if (event.getClickCount() == 2) {
            this.openLoginScreen();
        }
    }

    private void openLoginScreen() {
        this.server = (rs.tetrabyte.pezar.settings.Server)this.serverList.getSelectionModel().getSelectedItem();
        this.tenantContext.setActiveServer(new Server(this.server.getUrl(), this.server.getName(), this.server.getLocale()));
        this.restTaskFactory.createTask(client -> client.getResources(client.pathBuilder().base().slash("residents").get(), Resident.class)).whenDone(residents -> {
            this.tenantContext.setResidents((Collection)residents.getContent().stream().collect(Collectors.toList()));
            this.locale = null;
            if (!StringUtils.isEmpty((CharSequence)this.server.getLocale())) {
                this.locale = this.server.getLocale();
                this.go();
            } else {
                Optional<Resident> def = residents.getContent().stream().filter(r -> r.getResidentId().equals("default")).findFirst();
                if (def.isPresent()) {
                    Resident resident = def.get();
                    if (!resident.hasLink("locales")) {
                        this.uiCommands.showNotification().error().withText("Can't found default resident locale", new Object[0]);
                        return;
                    }
                    resident.relatedResources("locales", Resident.Resource.class).get(locales -> {
                        if (locales.getContent().size() == 0) {
                            this.uiCommands.showNotification().withText("Can't found default locale", new Object[0]);
                        } else if (locales.getContent().size() == 1) {
                            this.locale = ((Resident.Resource)locales.getContent().iterator().next()).getName();
                            this.go();
                        } else {
                            ChoiceDialog dlg = new ChoiceDialog((Object)this.locale, (Collection)locales.getContent().stream().map(r -> r.getName()).collect(Collectors.toList()));
                            dlg.initOwner(this.serverList.getScene().getWindow());
                            dlg.setTitle("Language");
                            dlg.setContentText("Choose locale");
                            dlg.showAndWait().ifPresent(l -> {
                                this.locale = l;
                                this.go();
                            });
                        }
                    });
                } else {
                    this.uiCommands.showNotification().withText("Can't found default resident", new Object[0]);
                    return;
                }
            }
        }).execute();
    }

    private void go() {
        this.server.setLocale(this.locale);
        this.tenantContext.setActiveServer(new Server(this.server.getUrl(), this.server.getName(), this.server.getLocale()));
        this.settingsManager.getSettings().put("current-server", (Object)this.server.getId());
        this.uiCommands.lockUI().execute();
        if (!StringUtils.isEmpty((CharSequence)this.server.getUserName()) && !StringUtils.isEmpty((CharSequence)this.server.getPassword())) {
            this.uiCommands.lockUI().execute();
            this.loginService.login(this.server.getUserName(), this.server.getPassword(), (LogInService.LoginHandler)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.fxmlTaskFactory.createTask(LoginViewController.class).output(new Object[]{this.server}).whenDone(v -> this.uiCommands.displayContent((Node)((Parent)v.getView())).in(DisplayContent.TargetContainer.Screen).closable(true).execute()).execute();
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.serverList.setItems(this.settingsManager.getSettings().getServers());
        if (this.serverList.getItems().size() > 0) {
            this.serverList.getSelectionModel().select(0);
        }
    }

    public void postLoad() {
        this.serverList.requestFocus();
    }

    static /* synthetic */ UICommands access$0(ServersViewController serversViewController) {
        return serversViewController.uiCommands;
    }

    static /* synthetic */ FXMLTaskFactory access$1(ServersViewController serversViewController) {
        return serversViewController.fxmlTaskFactory;
    }

    static /* synthetic */ rs.tetrabyte.pezar.settings.Server access$2(ServersViewController serversViewController) {
        return serversViewController.server;
    }
}

