/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller;

import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Separator;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.fxml.FXMLController;
import rs.tetrabyte.fxml.LocaleContext;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.pezar.context.UIFeatureService;
import rs.tetrabyte.pezar.context.UiSettingService;
import rs.tetrabyte.pezar.controller.ShortcutsViewController;
import rs.tetrabyte.pezar.custom.LockablePane;
import rs.tetrabyte.pezar.custom.LockablePaneWrapper;
import rs.tetrabyte.pezar.features.UIFeature;

/*
 * Exception performing whole class analysis ignored.
 */
@FXMLView(value="/fxml/ShortcutsView.fxml", wrappers={LockablePaneWrapper.class})
public class ShortcutsViewController
extends FXMLController {
    @FXML
    private FlowPane content;
    @Autowired
    private UiSettingService settingsService;
    @Autowired
    private UIFeatureService featureService;
    @Autowired
    private LocaleContext locale;

    @PostConstruct
    private void initDragAndDrop() {
        ((LockablePane)this.getRootNode(LockablePane.class)).lockedProperty().bind((ObservableValue)this.featureService.fetchingProperty());
        this.content.setOnDragOver(event -> {
            event.acceptTransferModes(TransferMode.ANY);
            event.consume();
        });
        this.content.setOnDragDropped(e -> {
            if (e.getTarget() != this.content) {
                return;
            }
            Dragboard db = e.getDragboard();
            this.featureService.getFeatures(features -> {
                Optional<UIFeature> feature = features.stream().filter(f -> f.getId().equals(db.getString())).findAny();
                if (feature.isPresent()) {
                    this.content.getChildren().add((Object)this.createButtonPane(feature.get(), this.content.getChildren().size()));
                    this.saveShortcuts();
                } else {
                    Button btn = (Button)e.getGestureSource();
                    ButtonPane btnPane = (ButtonPane)btn.getParent();
                    this.content.getChildren().remove((Object)btnPane);
                    ButtonPane.access$2((ButtonPane)btnPane, (int)this.content.getChildren().size());
                    this.content.getChildren().add((Object)btnPane);
                    this.saveShortcuts();
                }
            });
        });
    }

    private void saveShortcuts() {
        List featureSettings = this.content.getChildren().stream().filter(n -> ButtonPane.access$0((ButtonPane)((ButtonPane)n)).getProperties().containsKey((Object)"feature")).map(n -> {
            UIFeature feature = (UIFeature)ButtonPane.access$0((ButtonPane)((ButtonPane)n)).getProperties().get((Object)"feature");
            int order = this.content.getChildren().indexOf(n);
            return new FeatureSetting(feature.getId(), order);
        }).collect(Collectors.toList());
        UiSettingService.UiSetting shortcutsSetting = new UiSettingService.UiSetting("shortcuts-view", (Object)new ShortcutsSetting(featureSettings));
        this.settingsService.save(shortcutsSetting);
    }

    @PostConstruct
    private void restoreShortcuts() {
        this.settingsService.restore("shortcuts-view", ShortcutsSetting.class, setting -> ((ShortcutsSetting)setting.getValue()).getFeatures().forEach(featureSetting -> this.featureService.getFeatures(features -> features.stream().filter(feature -> feature.getId().equals(featureSetting.getFeatureId())).findAny().ifPresent(feature -> {
            int insertIndex = 0;
            int i = 0;
            while (i < this.content.getChildren().size()) {
                ButtonPane bp = (ButtonPane)this.content.getChildren().get(i);
                if (ButtonPane.access$1((ButtonPane)bp) < FeatureSetting.access$0((FeatureSetting)featureSetting)) {
                    insertIndex = ButtonPane.access$1((ButtonPane)bp) + 1;
                }
                ++i;
            }
            this.content.getChildren().add(insertIndex, (Object)this.createButtonPane(feature, insertIndex));
        }))));
    }

    private HBox createButtonPane(UIFeature feature, int order) {
        Button btn = this.createButton(feature);
        Separator spr = this.createButtonSeparator();
        return new ButtonPane(btn, spr, order);
    }

    private Separator createButtonSeparator() {
        Separator s = new Separator(Orientation.VERTICAL);
        s.setOnDragEntered(e -> s.setStyle("-fx-border-color: red; -fx-border-width: 2;"));
        s.setOnDragExited(e -> s.setStyle("-fx-border-color: transparent; -fx-border-width: 0;"));
        s.setOnDragDropped(e -> {
            Dragboard dragboard = e.getDragboard();
            if (dragboard.hasString()) {
                String value = dragboard.getString();
                this.featureService.getFeatures(features -> {
                    Optional<UIFeature> feature = features.stream().filter(f -> f.getId().equals(value)).findAny();
                    int insertIndex = this.content.getChildren().indexOf((Object)s.getParent());
                    if (feature.isPresent()) {
                        this.content.getChildren().add(insertIndex, (Object)this.createButtonPane(feature.get(), insertIndex));
                    } else {
                        Button btn = (Button)e.getGestureSource();
                        ButtonPane btnPane = (ButtonPane)btn.getParent();
                        if (this.content.getChildren().indexOf((Object)btnPane) < insertIndex) {
                            --insertIndex;
                        }
                        this.content.getChildren().remove((Object)btnPane);
                        this.content.getChildren().add(insertIndex, (Object)btnPane);
                        this.saveShortcuts();
                    }
                });
            }
        });
        return s;
    }

    private Button createButton(UIFeature feature) {
        VBox vBox = new VBox();
        if (feature.getGraphic() == null) {
            vBox.getChildren().add((Object)new FontAwesomeIconView(FontAwesomeIcon.STAR_HALF_EMPTY));
        } else {
            vBox.getChildren().add((Object)feature.getGraphic());
        }
        Label label = new Label(feature.getLabel());
        label.setWrapText(true);
        label.getStyleClass().add((Object)"text");
        label.setTextAlignment(TextAlignment.CENTER);
        vBox.getChildren().add((Object)label);
        vBox.setAlignment(Pos.CENTER);
        vBox.getStyleClass().add((Object)"btn-shortcut-graphic");
        vBox.setSpacing(5.0);
        vBox.setPadding(new Insets(2.0));
        Button btn = new Button(null, (Node)vBox);
        btn.getStyleClass().add((Object)"btn-shortcut");
        if (feature.getOnAction() != null) {
            btn.setOnAction(e -> feature.getOnAction().handle(null));
        }
        btn.addEventFilter(KeyEvent.KEY_RELEASED, e -> {
            if (e.getCode() == KeyCode.ENTER && btn.getOnAction() != null) {
                btn.getOnAction().handle(null);
            }
        });
        btn.getProperties().put((Object)"feature", (Object)feature);
        btn.setOnDragDetected(event -> {
            Dragboard db = btn.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
            ClipboardContent clipboard = new ClipboardContent();
            int nodeIndex = btn.getParent().getChildrenUnmodifiable().indexOf((Object)btn);
            clipboard.putString(Integer.toString(nodeIndex));
            db.setContent((Map)clipboard);
            event.consume();
        });
        MenuItem itmDelete = new MenuItem(this.locale.getMessage("btn.delete", new Object[0]));
        itmDelete.setOnAction(e -> {
            this.content.getChildren().remove((Object)btn.getParent());
            this.saveShortcuts();
        });
        ContextMenu menu = new ContextMenu(new MenuItem[]{itmDelete});
        btn.setContextMenu(menu);
        return btn;
    }
}

