/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller.browser;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javax.annotation.PostConstruct;
import jidefx.scene.control.field.DateField;
import jidefx.scene.control.field.FormattedTextField;
import org.controlsfx.control.PrefixSelectionComboBox;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resources;
import org.springframework.util.StringUtils;
import rs.tetrabyte.datamodel.uidescriptors.entity.EBrowserDescriptor;
import rs.tetrabyte.datamodel.uidescriptors.entity.EFieldKind;
import rs.tetrabyte.datamodel.uidescriptors.entity.ESearchDescriptor;
import rs.tetrabyte.datarest.client.Params;
import rs.tetrabyte.datarest.context.RepositoryFXContext;
import rs.tetrabyte.datarest.fx.RepositoryFX;
import rs.tetrabyte.datarest.fx.RepositoryFXEvent;
import rs.tetrabyte.datarest.repository.RepositorySearch;
import rs.tetrabyte.datarest.task.RestTaskFactory;
import rs.tetrabyte.fxml.FXMLController;
import rs.tetrabyte.fxml.LocaleContext;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.fxml.annotation.Input;
import rs.tetrabyte.pezar.beans.AbstractEntity;
import rs.tetrabyte.pezar.beans.Lookup;
import rs.tetrabyte.pezar.context.AcceleratorService;
import rs.tetrabyte.pezar.context.ControlsFactoryService;
import rs.tetrabyte.pezar.controller.browser.EBrowserTableSearchViewController;
import rs.tetrabyte.pezar.factory.field.util.ControlUtil;
import rs.tetrabyte.pezar.factory.field.util.ValueObject;

@FXMLView(value="/fxml/browser/EBrowserTableSearchView.fxml")
public class EBrowserTableSearchViewController
extends FXMLController {
    @FXML
    VBox content;
    @Autowired
    LocaleContext localeContext;
    @Autowired
    RepositoryFXContext restContext;
    @Autowired
    RestTaskFactory restTaskFactory;
    @Autowired
    AcceleratorService accelerators;
    @Autowired
    ControlsFactoryService cfs;
    @Input
    EBrowserDescriptor descriptor;
    @Input
    RepositoryFX<AbstractEntity> repository;
    @Input
    StringProperty entityId;
    private StringExpression exp;
    private TextField txtCode;
    private static final String template = "(name)op(values),";
    private static final DateFormat CONVERTER_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    @PostConstruct
    private void initSearchFields() {
        ArrayList<StringBinding> bindings = new ArrayList<StringBinding>();
        for (ESearchDescriptor.ESearchFieldDescriptor desc : this.descriptor.getSearch().getFields()) {
            TextField ctrl;
            Label label = this.cfs.createAcceleratedLabel(desc);
            this.content.getChildren().add((Object)label);
            if (desc.getKind() == EFieldKind.PROPERTY) {
                if (!desc.getFieldId().equals("code")) continue;
                this.txtCode = new TextField();
                ControlUtil.executeOnEnter((Control)this.txtCode, () -> this.onSearch(null));
                this.content.getChildren().add((Object)this.txtCode);
                label.setLabelFor((Node)this.txtCode);
                continue;
            }
            switch (desc.getType()) {
                case "decimal": {
                    1 verifierA = new /* Unavailable Anonymous Inner Class!! */;
                    2 verifierB = new /* Unavailable Anonymous Inner Class!! */;
                    HBox hbox = new HBox(10.0);
                    FormattedTextField nf1 = new FormattedTextField();
                    nf1.setPattern("a.b");
                    nf1.getPatternVerifiers().put((Object)"a", (Object)verifierA);
                    nf1.getPatternVerifiers().put((Object)"b", (Object)verifierB);
                    nf1.setAlignment(Pos.BASELINE_RIGHT);
                    label.setLabelFor((Node)nf1);
                    hbox.getChildren().add((Object)nf1);
                    FormattedTextField nf2 = new FormattedTextField();
                    nf2.setPattern("a.b");
                    nf2.getPatternVerifiers().put((Object)"a", (Object)verifierA);
                    nf2.getPatternVerifiers().put((Object)"b", (Object)verifierB);
                    nf2.setAlignment(Pos.BASELINE_RIGHT);
                    hbox.getChildren().add((Object)nf2);
                    ctrl = hbox;
                    bindings.add(this.createBinding((TextField)nf1, desc.getFieldId(), ">:", "\\.|-\\.", val -> val == null ? val : new BigDecimal((String)val).toString()));
                    bindings.add(this.createBinding((TextField)nf2, desc.getFieldId(), "<:", "\\.|-\\.", val -> val == null ? val : new BigDecimal((String)val).toString()));
                    break;
                }
                case "boolean": {
                    PrefixSelectionComboBox bool = new PrefixSelectionComboBox();
                    label.setLabelFor((Node)bool);
                    bool.getItems().add((Object)new ValueObject(null, null));
                    bool.getItems().add((Object)new ValueObject("true", this.localeContext.getMessage("yes", new Object[0])));
                    bool.getItems().add((Object)new ValueObject("false", this.localeContext.getMessage("no", new Object[0])));
                    ControlUtil.executeOnEnter((Control)bool, () -> this.onSearch(null));
                    ctrl = bool;
                    StringBinding boolBinding = Bindings.createStringBinding(() -> bool.getSelectionModel().getSelectedItem() != null ? ((ValueObject)bool.getSelectionModel().getSelectedItem()).getValue() : "", (Observable[])new Observable[]{bool.getSelectionModel().selectedItemProperty()});
                    bindings.add(this.createBinding(boolBinding, desc.getFieldId(), ":", "", val -> val, (Observable)bool.getSelectionModel().selectedItemProperty()));
                    break;
                }
                case "integer": {
                    3 verifier = new /* Unavailable Anonymous Inner Class!! */;
                    HBox h = new HBox(10.0);
                    FormattedTextField inf1 = new FormattedTextField();
                    inf1.setPattern("p");
                    inf1.getPatternVerifiers().put((Object)"p", (Object)verifier);
                    inf1.setAlignment(Pos.BASELINE_RIGHT);
                    label.setLabelFor((Node)inf1);
                    h.getChildren().add((Object)inf1);
                    FormattedTextField inf2 = new FormattedTextField();
                    inf2.setPattern("p");
                    inf2.getPatternVerifiers().put((Object)"p", (Object)verifier);
                    inf2.setAlignment(Pos.BASELINE_RIGHT);
                    h.getChildren().add((Object)inf2);
                    ctrl = h;
                    bindings.add(this.createBinding((TextField)inf1, desc.getFieldId(), ">:", "-", val -> val));
                    bindings.add(this.createBinding((TextField)inf2, desc.getFieldId(), "<:", "-", val -> val));
                    break;
                }
                case "date": {
                    HBox dateBox = new HBox(10.0);
                    DateField df1 = this.createDateField(desc);
                    DateField df2 = this.createDateField(desc);
                    dateBox.getChildren().addAll((Object[])new Node[]{df1, df2});
                    label.setLabelFor((Node)df1);
                    ctrl = dateBox;
                    bindings.add(this.createBinding(df1, desc.getFieldId(), ">:"));
                    bindings.add(this.createBinding(df2, desc.getFieldId(), "<:"));
                    break;
                }
                case "lookup": {
                    PrefixSelectionComboBox lookup = new PrefixSelectionComboBox();
                    lookup.getItems().add((Object)new ValueObject(null, null));
                    label.setLabelFor((Node)lookup);
                    Link discriminatorSearchLink = this.restContext.getRepositoryFX("lookups/" + desc.getLookup().getDiscriminator()).getSearchLink("discriminator");
                    this.restTaskFactory.createTask(client -> client.getResources(discriminatorSearchLink, Lookup.class, new Params().param("d", (Object)desc.getLookup().getDiscriminator())).getContent()).whenDone(lookups -> lookup.getItems().addAll((Collection)lookups.stream().map(l -> new ValueObject(l.getValue(), l.getValue())).collect(Collectors.toList()))).execute();
                    ControlUtil.executeOnEnter((Control)lookup, () -> this.onSearch(null));
                    lookup.setMaxWidth(Double.MAX_VALUE);
                    ctrl = lookup;
                    StringBinding lookupBinding = Bindings.createStringBinding(() -> lookup.getSelectionModel().getSelectedItem() != null ? ((ValueObject)lookup.getSelectionModel().getSelectedItem()).getValue() : "", (Observable[])new Observable[]{lookup.getSelectionModel().selectedItemProperty()});
                    bindings.add(this.createBinding(lookupBinding, desc.getFieldId(), ":", "", val -> val, (Observable)lookup.getSelectionModel().selectedItemProperty()));
                    break;
                }
                case "option": {
                    PrefixSelectionComboBox opt = new PrefixSelectionComboBox();
                    label.setLabelFor((Node)opt);
                    opt.getItems().add((Object)new ValueObject(null, null));
                    opt.getItems().addAll((Collection)desc.getValues().stream().map(v -> new ValueObject(v.getValue(), v.getLabel())).collect(Collectors.toList()));
                    ControlUtil.executeOnEnter((Control)opt, () -> this.onSearch(null));
                    opt.setMaxWidth(Double.MAX_VALUE);
                    ctrl = opt;
                    StringBinding optBinding = Bindings.createStringBinding(() -> opt.getSelectionModel().getSelectedItem() != null ? ((ValueObject)opt.getSelectionModel().getSelectedItem()).getValue() : "", (Observable[])new Observable[]{opt.getSelectionModel().selectedItemProperty()});
                    bindings.add(this.createBinding(optBinding, desc.getFieldId(), ":", "", val -> val, (Observable)opt.getSelectionModel().selectedItemProperty()));
                    break;
                }
                default: {
                    TextField txt = new TextField();
                    label.setLabelFor((Node)txt);
                    ctrl = txt;
                    bindings.add(this.createBinding(txt, desc.getFieldId(), "~", "", val -> val.trim().replaceAll("\\s+", ",")));
                }
            }
            ctrl.setId(desc.getFieldId());
            this.content.getChildren().add((Object)ctrl);
        }
        this.exp = Bindings.concat((Object[])bindings.toArray());
        this.accelerators.refresh();
    }

    @PostConstruct
    void handleSearchByCode() {
        this.repository.addEventFilter(RepositoryFXEvent.READ_MANY_OK, e -> {
            if (this.txtCode == null || StringUtils.isEmpty((Object)this.txtCode.getText())) {
                return;
            }
            ((Resources)e.getValue()).getContent().stream().filter(entity -> entity.getCode().equals(this.txtCode.getText())).findFirst().ifPresent(entity -> this.entityId.set((Object)entity.getId().getHref()));
        });
    }

    private DateField createDateField(ESearchDescriptor.ESearchFieldDescriptor desc) {
        DateField df;
        try {
            df = DateField.createDateField((DateFormat)new SimpleDateFormat(desc.getFormat(), this.localeContext.getLocale()), (Date)new Date());
        }
        catch (Exception e) {
            df = DateField.createDateField((DateFormat)DateFormat.getDateInstance(), (Date)new Date());
        }
        df.setPopupButtonVisible(true);
        return df;
    }

    private StringBinding createBinding(DateField df, String name, String op) {
        ControlUtil.executeOnEnter((Control)df, () -> this.onSearch(null));
        return Bindings.createStringBinding(() -> df.getValue() != null ? this.replace(name, StringBinding.stringExpression((ObservableValue)new SimpleStringProperty(op)), CONVERTER_FORMAT.format((Date)df.getValue())) : "", (Observable[])new Observable[]{df.valueProperty()});
    }

    private StringBinding createBinding(TextField tf, String name, StringExpression op, String nullPattern, Function<String, String> val) {
        ControlUtil.executeOnEnter((Control)tf, () -> this.onSearch(null));
        return Bindings.createStringBinding(() -> !StringUtils.isEmpty((Object)tf.getText()) && !tf.getText().equals(nullPattern) && !tf.getText().matches(nullPattern) ? this.replace(name, op, (String)val.apply(tf.getText())) : "", (Observable[])new Observable[]{tf.textProperty()});
    }

    private StringBinding createBinding(TextField tf, String name, String op, String nullPattern, Function<String, String> val) {
        return this.createBinding(tf, name, StringBinding.stringExpression((ObservableValue)new SimpleStringProperty(op)), nullPattern, val);
    }

    private StringBinding createBinding(StringBinding binding, String name, StringExpression op, String nullPattern, Function<String, String> val, Observable observable) {
        return Bindings.createStringBinding(() -> !StringUtils.isEmpty((Object)binding.get()) && !binding.get().equals(nullPattern) ? this.replace(name, op, (String)val.apply(binding.get())) : "", (Observable[])new Observable[]{observable});
    }

    private StringBinding createBinding(StringBinding binding, String name, String op, String nullPattern, Function<String, String> val, Observable observable) {
        return this.createBinding(binding, name, StringBinding.stringExpression((ObservableValue)new SimpleStringProperty(op)), nullPattern, val, observable);
    }

    private String replace(String name, StringExpression op, String values) {
        return template.replace("name", name).replace("op", (CharSequence)op.get()).replace("values", values);
    }

    @FXML
    void onSearch(ActionEvent event) {
        RepositorySearch search = null;
        if (this.txtCode != null && !StringUtils.isEmpty((Object)this.txtCode.getText())) {
            search = RepositorySearch.builder().withRel("codeSequence").withParam("c", this.txtCode.getText().trim()).build();
        } else {
            String searchString = (String)this.exp.get();
            if (searchString.endsWith(",")) {
                searchString = searchString.substring(0, searchString.length() - 1);
                search = RepositorySearch.builder().withRel("attributes").withParam("s", searchString).build();
            } else {
                search = RepositorySearch.builder().withRel("discriminator").withParam("d", this.descriptor.getBrowserId().split("/")[1]).build();
            }
        }
        this.repository.search(search);
    }
}

