/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller.browser.document;

import java.math.BigDecimal;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import rs.tetrabyte.datamodel.uidescriptors.entity.DDetailDescriptor;
import rs.tetrabyte.datamodel.uidescriptors.entity.DSummaryDescriptor;
import rs.tetrabyte.datarest.fx.RepositoryFX;
import rs.tetrabyte.datarest.fx.RepositoryFXEvent;
import rs.tetrabyte.fxml.FXMLController;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.fxml.annotation.Input;
import rs.tetrabyte.pezar.beans.Document;
import rs.tetrabyte.pezar.beans.DocumentLine;
import rs.tetrabyte.pezar.beans.DocumentSum;
import rs.tetrabyte.pezar.browser.DSummaryView;
import rs.tetrabyte.pezar.context.MessageService;

@FXMLView(value="/fxml/browser/document/DSummaryView.fxml")
public class DSummaryController
extends FXMLController {
    @FXML
    private BorderPane content;
    @Autowired
    private Logger logger;
    @Autowired
    private MessageService messages;
    @Input
    private DDetailDescriptor descriptor;
    @Input(value="lineRepository")
    private ObjectProperty<RepositoryFX<DocumentLine>> lineRepo = new SimpleObjectProperty();
    @Input
    private RepositoryFX<Document> documentRepo;
    @Input(value="globalSummary")
    private List<DocumentSum> globalSummary;
    private DSummaryView summaryView;
    private List<DocumentSum> summary;
    private static final ExpressionParser PARSER = new SpelExpressionParser();
    private static final ParserContext PARSER_CONTEXT = ParserContext.TEMPLATE_EXPRESSION;
    private static final String METHOD_CALL_PATTERN_STRING = "((?U)[.\\w]+\\s*\\(.*?\\))";
    private static final Pattern METHOD_CALL_PATTERN = Pattern.compile(METHOD_CALL_PATTERN_STRING);

    @PostConstruct
    private void configureDocumentRepo() {
        this.documentRepo.addEventFilter(RepositoryFXEvent.READ_ONE_OK, e -> this.setModel((Document)e.getValue()));
        this.documentRepo.addEventFilter(RepositoryFXEvent.READ_TEMPLATE_OK, e -> this.setModel((Document)e.getValue()));
        this.documentRepo.addEventFilter(RepositoryFXEvent.INSERT_OK, e -> this.setModel((Document)e.getValue()));
    }

    private void setModel(Document document) {
        this.summary = document.getSummary();
        this.summaryView.setModel(this.summary);
    }

    @PostConstruct
    private void configureItemRepo() {
        this.lineRepo.addListener((o, ov, nv) -> {
            this.summaryView.setModel(this.summary);
            nv.addEventFilter(RepositoryFXEvent.INSERT_OK, e -> this.addItem((DocumentLine)e.getValue()));
            nv.addEventFilter(RepositoryFXEvent.UPDATE_OK, e -> {
                this.removeItem((DocumentLine)e.getSource());
                this.addItem((DocumentLine)e.getValue());
            });
            nv.addEventFilter(RepositoryFXEvent.DELETE_OK, e -> this.removeItem((DocumentLine)e.getValue()));
        });
    }

    @PostConstruct
    private void initView() {
        this.summaryView = new DSummaryView(this.descriptor.getSummaryDescriptor(), this.messages);
        this.content.setCenter((Node)this.summaryView);
    }

    private void addItem(DocumentLine item) {
        this.descriptor.getSummaryDescriptor().getLines().stream().filter(i -> i.getDiscriminator().equals(item.getDiscriminator())).findFirst().ifPresent(desc -> desc.getSumList().forEach(sum -> this.addSum(sum, item)));
        this.descriptor.getSummaryDescriptor().getSumList().forEach(sum -> this.addSum(sum));
    }

    private void addSum(DSummaryDescriptor.ESumDescriptor sum) {
        DocumentSum documentSum = this.summary.stream().filter(s -> sum.getName().equals(s.getName())).findFirst().get();
        documentSum.setValue(this.parseDocumentSumExpression((Object)this, sum.getValue()));
    }

    private void addSum(DSummaryDescriptor.ESumDescriptor sum, DocumentLine item) {
        this.addSum(sum, item, this.summary);
        this.addSum(sum, item, this.globalSummary);
    }

    private void addSum(DSummaryDescriptor.ESumDescriptor sum, DocumentLine item, List<DocumentSum> summary) {
        summary.stream().filter(s -> sum.getName().equals(s.getName())).findFirst().ifPresent(documentSum -> documentSum.setValue(documentSum.getValue().add(this.parseItemSumExpression(item, sum.getValue()))));
    }

    private void removeItem(DocumentLine item) {
        this.descriptor.getSummaryDescriptor().getLines().stream().filter(i -> i.getDiscriminator().equals(item.getDiscriminator())).findFirst().ifPresent(desc -> desc.getSumList().forEach(sum -> this.removeSum(sum, item)));
        this.descriptor.getSummaryDescriptor().getSumList().forEach(sum -> this.addSum(sum));
    }

    private void removeSum(DSummaryDescriptor.ESumDescriptor sum, DocumentLine item) {
        this.removeSum(sum, item, this.summary);
        this.removeSum(sum, item, this.globalSummary);
    }

    private void removeSum(DSummaryDescriptor.ESumDescriptor sum, DocumentLine item, List<DocumentSum> summary) {
        summary.stream().filter(s -> sum.getName().equals(s.getName())).findFirst().ifPresent(documentSum -> documentSum.setValue(documentSum.getValue().subtract(this.parseItemSumExpression(item, sum.getValue()))));
    }

    private BigDecimal parseItemSumExpression(DocumentLine item, String value) {
        return this.parseStringExpression((Object)item, value, null);
    }

    private BigDecimal parseDocumentSumExpression(Object object, String value) {
        return this.parseBigDecimalExpression(object, value, null);
    }

    public BigDecimal getSum(String name) {
        return this.summary.stream().filter(s -> s.getName().equals(name)).map(DocumentSum::getValue).findFirst().orElseThrow(() -> new IllegalArgumentException("Can't find document sum with name " + name));
    }

    private BigDecimal parseStringExpression(Object object, String expression, String format) {
        String actualExpression = expression;
        Matcher m = METHOD_CALL_PATTERN.matcher(expression);
        String replaced = "";
        while (m.find()) {
            String target = m.group();
            if (replaced.contains(target)) continue;
            actualExpression = actualExpression.replace(target, String.format("new java.math.BigDecimal(%s)", target));
            replaced = String.valueOf(replaced) + " " + target;
        }
        try {
            String stringValue = (String)PARSER.parseExpression(actualExpression, PARSER_CONTEXT).getValue(object, String.class);
            return new BigDecimal(stringValue);
        }
        catch (Exception e) {
            this.logger.error("SpEL parser failed on expression: " + actualExpression, (Throwable)e);
            return BigDecimal.ZERO;
        }
    }

    private BigDecimal parseBigDecimalExpression(Object object, String expression, String format) {
        try {
            String stringValue = (String)PARSER.parseExpression(expression, PARSER_CONTEXT).getValue(object, String.class);
            return new BigDecimal(stringValue);
        }
        catch (Exception e) {
            this.logger.warn("Couldn't parse expression: " + expression + ", cause: " + e.getMessage());
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("SpEL parser failed on expression: " + expression, (Throwable)e);
            }
            return BigDecimal.ZERO;
        }
    }
}

