/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller.browser.user;

import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.datarest.context.RepositoryFXContext;
import rs.tetrabyte.datarest.repository.RepositorySearch;
import rs.tetrabyte.fxml.FXMLController;
import rs.tetrabyte.fxml.Output;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.pezar.beans.Resident;
import rs.tetrabyte.pezar.context.AcceleratorService;
import rs.tetrabyte.pezar.context.TenantContext;
import rs.tetrabyte.pezar.controller.browser.user.RoleFormViewController;
import rs.tetrabyte.pezar.controller.browser.user.RolesTablePerspectiveController;
import rs.tetrabyte.pezar.controller.browser.user.UserFormViewController;
import rs.tetrabyte.pezar.controller.browser.user.UsersRolesViewController;
import rs.tetrabyte.pezar.controller.browser.user.UsersTablePerspectiveController;

@FXMLView(value="/fxml/user/AccountsManagementView.fxml")
public class AccountsManagementViewController
extends FXMLController {
    @FXML
    Tab tabUsers;
    @FXML
    Tab tabRoles;
    @Autowired
    private TenantContext tenantContext;
    @Autowired
    private AcceleratorService accelerators;
    @Autowired
    private RepositoryFXContext repoCtx;

    @FXML
    public void usersTabSelected(Event event) {
        if (this.tabUsers.getContent() != null) {
            this.accelerators.refresh();
            return;
        }
        String residents = this.tenantContext.getResidents().stream().map(r -> r.getResidentId()).collect(Collectors.joining(","));
        RepositorySearch initialSearch = RepositorySearch.builder().withRel("resident").withParam("residentId", residents).build();
        this.loadView(UsersRolesViewController.class).output(Output.value((String)"tableControllerClass", UsersTablePerspectiveController.class).and("formControllerClass", UserFormViewController.class)).output(new Object[]{this.repoCtx.getRepositoryFX("users"), initialSearch}).get(arg_0 -> ((Tab)this.tabUsers).setContent(arg_0));
    }

    @FXML
    public void rolesTabSelected(Event event) {
        if (this.tabRoles.getContent() != null) {
            this.accelerators.refresh();
            return;
        }
        String resident = ((Resident)this.tenantContext.getActiveResident().get()).getResidentId();
        RepositorySearch initialSearch = RepositorySearch.builder().withRel("residentRoleLevel").withParam("residentId", resident).withParam("roleLevel", "ROLE_USER").build();
        this.loadView(UsersRolesViewController.class).output(Output.value((String)"tableControllerClass", RolesTablePerspectiveController.class).and("formControllerClass", RoleFormViewController.class)).output(new Object[]{this.repoCtx.getRepositoryFX("roles"), initialSearch}).get(arg_0 -> ((Tab)this.tabRoles).setContent(arg_0));
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.tabUsers.setGraphic((Node)new FontAwesomeIconView(FontAwesomeIcon.USER_CIRCLE, "28"));
        this.tabRoles.setGraphic((Node)new FontAwesomeIconView(FontAwesomeIcon.USERS, "28"));
    }
}

