/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller.browser.user;

import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.datarest.fx.RepositoryFX;
import rs.tetrabyte.datarest.repository.RepositorySearch;
import rs.tetrabyte.fxml.FXMLController;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.fxml.annotation.Input;
import rs.tetrabyte.pezar.beans.Resident;
import rs.tetrabyte.pezar.beans.User;
import rs.tetrabyte.pezar.context.TenantContext;

@FXMLView(value="/fxml/user/UsersTablePerspective.fxml")
public class UsersTablePerspectiveController
extends FXMLController {
    @FXML
    private HBox container;
    @FXML
    private TextField txtSearch;
    @FXML
    private Button btnSearch;
    @FXML
    private TableColumn<User, String> colFirstName;
    @FXML
    private TableColumn<User, String> colLastName;
    @FXML
    private TableColumn<User, String> colUserName;
    @FXML
    private TableColumn<User, Boolean> colEnabled;
    @FXML
    private TableColumn<User, Resident> colDefaultResident;
    @FXML
    private TableView<User> tableView;
    @FXML
    private ComboBox<Resident> cbResidents;
    @Autowired
    private TenantContext tenantContext;
    @Input
    private RepositoryFX<User> repository;
    @Input
    private ObjectProperty<User> selectedResource;

    @FXML
    public void onSearch(ActionEvent event) {
    }

    private void setRepository() {
        this.selectedResource.bind((ObservableValue)this.tableView.getSelectionModel().selectedItemProperty());
        this.tableView.itemsProperty().bind((ObservableValue)this.repository.getResponseCollection().responseListProperty());
        this.repository.getResponseCollection().responseListProperty().addListener((o, ov, nv) -> {
            this.tableView.requestFocus();
            if (nv.size() > 0 && this.tableView.getSelectionModel().getSelectedIndex() == -1) {
                this.tableView.getSelectionModel().select(0);
            }
        });
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.colFirstName.setCellValueFactory(cellData -> ((User)cellData.getValue()).firstNameProperty());
        this.colLastName.setCellValueFactory(cellData -> ((User)cellData.getValue()).lastNameProperty());
        this.colUserName.setCellValueFactory(cellData -> ((User)cellData.getValue()).usernameProperty());
        this.colEnabled.setCellValueFactory(cellData -> ((User)cellData.getValue()).enabledProperty());
        this.colDefaultResident.setCellValueFactory(cellData -> {
            String residentId = ((User)cellData.getValue()).getDefaultResident();
            return new SimpleObjectProperty((Object)this.tenantContext.getResidents().stream().filter(res -> res.getResidentId().equals(residentId)).findFirst().orElse(null));
        });
        this.cbResidents.getItems().addAll((Collection)this.tenantContext.getResidents());
        if (this.tenantContext.getResidents().size() == 1) {
            this.cbResidents.getSelectionModel().select(0);
        }
        this.cbResidents.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> this.repository.search(RepositorySearch.builder().withRel("resident").withParam("residentId", nv.getResidentId()).build()));
        this.setRepository();
    }
}

