/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller.extension;

import java.util.Optional;
import java.util.function.Consumer;
import javafx.scene.Node;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.fxml.FXMLController;
import rs.tetrabyte.fxml.FXMLTaskFactory;
import rs.tetrabyte.pezar.context.ModuleService;
import rs.tetrabyte.pezar.controller.extension.Extension;

public class ExtensibleViewController
extends FXMLController {
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private FXMLTaskFactory fxmlTaskFactory;
    @Autowired
    private Logger logger;

    public Optional<Class<?>> getExtensionClass(String id) {
        return this.moduleService.getClass(type -> type.isAnnotationPresent(Extension.class) && type.getAnnotation(Extension.class).value().equals(id));
    }

    public void loadExtension(String id, Consumer<Node> view) {
        this.getExtensionClass(id).ifPresent(extClass -> this.fxmlTaskFactory.createTask(extClass).whenDone(pair -> view.accept(pair.getView())));
    }

    public Optional<FXMLController.FXMLViewLoader<Node>> loadExtension(String id) {
        Optional extClass = this.getExtensionClass(id);
        if (extClass.isPresent()) {
            return Optional.of(this.loadView((Class)extClass.get()));
        }
        this.logger.warn("Extension could not be found: " + id);
        return Optional.empty();
    }
}

