/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.custom;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import javafx.util.Callback;
import rs.tetrabyte.pezar.beans.AbstractEntity;

public class EntityTreeItem
extends TreeItem<AbstractEntity> {
    private AbstractEntity entity;
    private Callback<AbstractEntity, Collection<AbstractEntity>> childrenResolver;
    private boolean childrenResolved;
    private int childrenCount;

    public EntityTreeItem(AbstractEntity entity, Callback<AbstractEntity, Collection<AbstractEntity>> childrenResolver) {
        super((Object)entity);
        this.childrenResolver = childrenResolver;
        this.entity = entity;
        this.childrenCount = entity.getChildCount();
        super.getChildren().addListener((ListChangeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean isLeaf() {
        return this.childrenCount == 0;
    }

    public ObservableList<TreeItem<AbstractEntity>> getChildren() {
        if (this.childrenResolved) {
            return super.getChildren();
        }
        if (this.childrenResolver != null && !this.isLeaf()) {
            List children = ((Collection)this.childrenResolver.call((Object)this.entity)).stream().map(e -> new EntityTreeItem(e, this.childrenResolver)).collect(Collectors.toList());
            this.childrenResolved = true;
            super.getChildren().setAll(children);
        }
        return super.getChildren();
    }

    public void addChild(EntityTreeItem child) {
        super.getChildren().add((Object)child);
    }

    public void removeChild(EntityTreeItem child) {
        super.getChildren().remove((Object)child);
    }

    static /* synthetic */ void access$0(EntityTreeItem entityTreeItem, int n) {
        entityTreeItem.childrenCount = n;
    }
}

