/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.custom;

import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import jidefx.scene.control.decoration.DecorationDelegate;
import jidefx.scene.control.decoration.DecorationSupport;
import jidefx.scene.control.editor.Editor;
import jidefx.scene.control.validation.ValidationEvent;
import jidefx.scene.control.validation.ValidationMode;
import jidefx.scene.control.validation.ValidationUtils;
import jidefx.scene.control.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import rs.tetrabyte.datamodel.uidescriptors.entity.EFormDescriptor;
import rs.tetrabyte.datarest.client.RestClient;
import rs.tetrabyte.fxml.Output;
import rs.tetrabyte.pezar.beans.AbstractEntity;
import rs.tetrabyte.pezar.commands.UICommands;
import rs.tetrabyte.pezar.custom.ReferenceBrowserField;
import rs.tetrabyte.pezar.custom.ReferenceFieldBrowserSupport;
import rs.tetrabyte.pezar.factory.field.util.EntityDescriptor;
import rs.tetrabyte.pezar.factory.field.util.ReferenceDescriptor;

public class ReferenceBrowserField
extends Control
implements ReferenceFieldBrowserSupport,
DecorationSupport,
Editor<String> {
    private Button button;
    private ObjectProperty<String> valueProperty = new SimpleObjectProperty();
    private UICommands uiCommands;
    private RestClient client;
    private DecorationDelegate _operator;
    private Output output;

    public ReferenceBrowserField(UICommands uiCommands, RestClient client, EFormDescriptor.EFormFieldDescriptor desc) {
        this.client = client;
        this.getStyleClass().add((Object)"reference-browser-field");
        this.uiCommands = uiCommands;
        this.setSkin((javafx.scene.control.Skin)new Skin(this, this));
        this.button = new Button();
        this.button.setOnAction(e -> this.openBrowser(desc));
        this.button.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.TAB && desc.isRequired() && (this.getValue() == null || "".equals(this.getValue()))) {
                this.button.fire();
            }
        });
        this.button.getStyleClass().add((Object)"description");
        this.button.setMaxWidth(Double.MAX_VALUE);
        this.button.setText("...");
        this.button.textProperty().addListener((o, ov, nv) -> this.button.setTooltip(new Tooltip(nv)));
        HBox.setHgrow((Node)this.button, (Priority)Priority.ALWAYS);
        HBox box = new HBox(5.0);
        box.getChildren().addAll((Object[])new Node[]{this.button});
        this.getChildren().add((Object)box);
        this.focusedProperty().addListener((o, ov, nv) -> {
            if (nv.booleanValue()) {
                this.button.requestFocus();
            }
        });
        ValidationUtils.install((Node)this, (ObservableValue)this.observableValue(), (Validator)this.createValidator(desc), (ValidationMode)ValidationMode.ON_DEMAND);
    }

    public void requestFocus() {
        this.button.requestFocus();
    }

    public ObservableValue<String> observableValue() {
        return this.valueProperty;
    }

    public String getValue() {
        return (String)this.valueProperty.get();
    }

    public void setValue(String value) {
        this.valueProperty.set((Object)value);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return;
        }
        String text = ((AbstractEntity)this.client.getSingle(value, AbstractEntity.class)).getDescription();
        text = EntityDescriptor.of((String)text).getInlineDescription();
        this.button.setText(text);
    }

    public ObjectProperty<String> valueProperty() {
        return this.valueProperty;
    }

    protected void layoutChildren() {
        this.prepareDecorations();
        super.layoutChildren();
        Platform.runLater(() -> this.layoutDecorations());
    }

    public void prepareDecorations() {
        if (this._operator == null) {
            this._operator = new DecorationDelegate((Region)this);
        }
        this._operator.prepareDecorations();
    }

    public void layoutDecorations() {
        this._operator.layoutDecorations();
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void positionInArea(Node child, double areaX, double areaY, double areaWidth, double areaHeight, double areaBaselineOffset, HPos halignment, VPos valignment) {
        super.positionInArea(child, areaX, areaY, areaWidth, areaHeight, areaBaselineOffset, halignment, valignment);
    }

    private Validator createValidator(EFormDescriptor.EFormFieldDescriptor desc) {
        return vo -> {
            if (StringUtils.isEmpty((CharSequence)((String)vo.getNewValue())) && desc.isRequired()) {
                return new ValidationEvent(ValidationEvent.VALIDATION_ERROR);
            }
            return ValidationEvent.OK;
        };
    }

    private void openBrowser(EFormDescriptor.EFormFieldDescriptor desc) {
        String browserId = ReferenceDescriptor.of((String)desc.getFormat()).getRepoDiscriminated();
        this.uiCommands.openBrowser(browserId).withOutput(this.output).onCommit(c -> {
            AbstractEntity committed = c.getCommittedResource();
            this.valueProperty.set((Object)committed.getId().getHref());
            String text = EntityDescriptor.of((String)committed.getDescription()).getInlineDescription();
            this.button.setText(text);
            this.uiCommands.popContent().execute();
            ValidationUtils.validateOnDemand((Node)this);
        }).execute();
    }

    public void setOutput(Output output) {
        this.output = output;
    }
}

