/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.custom.factory.form.controller.impl;

import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import org.controlsfx.control.PrefixSelectionComboBox;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resources;
import rs.tetrabyte.datamodel.uidescriptors.entity.EFormDescriptor;
import rs.tetrabyte.datarest.client.Params;
import rs.tetrabyte.datarest.client.RestClient;
import rs.tetrabyte.datarest.context.RepositoryFXContext;
import rs.tetrabyte.pezar.beans.Lookup;
import rs.tetrabyte.pezar.controller.FormFieldController;
import rs.tetrabyte.pezar.custom.factory.form.controller.FormFieldControllerBuilder;
import rs.tetrabyte.pezar.custom.factory.form.controller.impl.FormOptionFieldBuilder;
import rs.tetrabyte.pezar.factory.field.util.ValueObject;

public class FormLookupFieldBuilder
implements FormFieldControllerBuilder {
    @Autowired
    private RestClient client;
    @Autowired
    private RepositoryFXContext restContext;
    private FormOptionFieldBuilder optionFieldBuilder = new FormOptionFieldBuilder();

    public List<FormFieldControllerBuilder> getChildern() {
        return null;
    }

    public boolean supportsType(String type) {
        if (type == null) {
            return false;
        }
        return "lookup".equals(type);
    }

    public boolean suppportsDisplayFormat(String format) {
        return true;
    }

    public FormFieldController createControl(EFormDescriptor.EFormFieldDescriptor desc) {
        return this.createComboBox(desc);
    }

    private FormFieldController createComboBox(EFormDescriptor.EFormFieldDescriptor desc) {
        FormFieldController controller = this.optionFieldBuilder.createControl(desc);
        PrefixSelectionComboBox cb = (PrefixSelectionComboBox)controller.getControl();
        ArrayList<ValueObject> values = new ArrayList<ValueObject>();
        if (!desc.isRequired()) {
            values.add(new ValueObject("", ""));
        }
        String lookupDiscriminator = desc.getLookup().getDiscriminator();
        Link discriminatorSearchLink = this.restContext.getRepositoryFX("lookups/" + lookupDiscriminator).getSearchLink("discriminator");
        Resources resources = this.client.getResources(discriminatorSearchLink, Lookup.class, new Params().param("d", (Object)desc.getLookup().getDiscriminator()));
        for (Lookup res : resources.getContent()) {
            ValueObject value = new ValueObject(res.getValue(), res.getValue());
            values.add(value);
        }
        ((ObservableList)cb.itemsProperty().get()).addAll(values);
        return controller;
    }
}

