/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.custom.factory.treeTable;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Optional;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.springframework.util.Assert;
import rs.tetrabyte.datamodel.uidescriptors.entity.DSummaryDescriptor;
import rs.tetrabyte.datamodel.uidescriptors.entity.EFieldKind;
import rs.tetrabyte.datamodel.uidescriptors.entity.ETableDescriptor;
import rs.tetrabyte.pezar.beans.AbstractEntity;
import rs.tetrabyte.pezar.beans.Document;
import rs.tetrabyte.pezar.beans.ItemAttribute;
import rs.tetrabyte.pezar.factory.GlyphFactory;
import rs.tetrabyte.pezar.factory.field.util.ControlUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class TreeTableColumnFactory {
    private static final DecimalFormat DECIMAL_FORMAT;
    private static final DecimalFormat PERCENT_FORMAT;
    private static final DateFormat DATE_FORMAT;

    static {
        DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
        DECIMAL_FORMAT = new DecimalFormat("###,###.00");
        DECIMAL_FORMAT.setParseBigDecimal(true);
        PERCENT_FORMAT = new DecimalFormat("###,###.00 %");
        PERCENT_FORMAT.setParseBigDecimal(true);
    }

    public static <E extends AbstractEntity> TreeTableColumn<E, String> createColumn(ETableDescriptor.ETableColumnDescriptor desc) {
        TreeTableColumn column = new TreeTableColumn();
        column.setId("col-" + desc.getId());
        column.setCellFactory(a -> TreeTableColumnFactory.createCell((String)desc.getType(), (String)desc.getFormat()));
        column.setText(ControlUtil.parseAcceleratedLabel((String)desc.getLabel())[0]);
        column.setGraphic(GlyphFactory.createGlyph((String)desc.getGlyph()));
        column.setCellValueFactory(a -> TreeTableColumnFactory.getValue((ETableDescriptor.ETableColumnDescriptor)desc, (TreeTableColumn.CellDataFeatures)a));
        return column;
    }

    public static TreeTableColumn<Document, BigDecimal> createColumn(DSummaryDescriptor.ESumDescriptor desc) {
        TreeTableColumn column = new TreeTableColumn();
        column.setText(desc.getLabel());
        column.setCellValueFactory(a -> ((Document)a.getValue().getValue()).findSum(desc.getName()).valueProperty());
        column.setCellFactory(a -> new /* Unavailable Anonymous Inner Class!! */);
        return column;
    }

    private static <E extends AbstractEntity> ObservableValue<String> getValue(ETableDescriptor.ETableColumnDescriptor desc, TreeTableColumn.CellDataFeatures<E, String> param) {
        AbstractEntity resource = (AbstractEntity)param.getValue().getValue();
        if (desc.getKind() == EFieldKind.PROPERTY) {
            try {
                StringProperty value = (StringProperty)FieldUtils.readField((Object)resource, (String)desc.getId(), (boolean)true);
                return value.get() != null ? value : new SimpleStringProperty("");
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (desc.getKind() == EFieldKind.ATTRIBUTE) {
            Optional<ItemAttribute> a = resource.getAttributes().stream().filter(attr -> attr.getName().equals(desc.getId())).findFirst();
            if (a.isPresent()) {
                StringProperty value = a.get().valueProperty();
                return value.get() != null ? value : new SimpleStringProperty("");
            }
            return new SimpleStringProperty("");
        }
        return null;
    }

    public static <E extends AbstractEntity, T> TreeTableCell<E, T> createCell(String type, String format) {
        Assert.hasLength((String)type, (String)"Type can't be null");
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private static DecimalFormat getDecimalFormat(String format) {
        DecimalFormat df = StringUtils.isEmpty((CharSequence)format) ? DECIMAL_FORMAT : new DecimalFormat(format);
        df.setParseBigDecimal(true);
        return df;
    }

    private static DecimalFormat getPercentFormat(String format) {
        DecimalFormat df = StringUtils.isEmpty((CharSequence)format) ? PERCENT_FORMAT : new DecimalFormat(String.valueOf(format) + " %");
        df.setParseBigDecimal(true);
        return df;
    }

    private static DateFormat getDateFormat(String format) {
        return StringUtils.isEmpty((CharSequence)format) ? DateFormat.getDateInstance(2) : new SimpleDateFormat(format);
    }

    static /* synthetic */ DecimalFormat access$0() {
        return DECIMAL_FORMAT;
    }

    static /* synthetic */ DecimalFormat access$1(String string) {
        return TreeTableColumnFactory.getDecimalFormat((String)string);
    }

    static /* synthetic */ DecimalFormat access$2(String string) {
        return TreeTableColumnFactory.getPercentFormat((String)string);
    }

    static /* synthetic */ DateFormat access$3() {
        return DATE_FORMAT;
    }

    static /* synthetic */ DateFormat access$4(String string) {
        return TreeTableColumnFactory.getDateFormat((String)string);
    }
}

