/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.custom.picker;

import javafx.scene.control.Control;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import rs.tetrabyte.datamodel.uidescriptors.entity.EFormDescriptor;
import rs.tetrabyte.datarest.client.ResourceEntity;
import rs.tetrabyte.datarest.client.RestClient;
import rs.tetrabyte.datarest.context.RepositoryFXContext;
import rs.tetrabyte.pezar.commands.UICommands;
import rs.tetrabyte.pezar.custom.ReferenceOptionField;
import rs.tetrabyte.pezar.custom.ReferenceTextField;
import rs.tetrabyte.pezar.custom.picker.Picker;
import rs.tetrabyte.pezar.factory.field.util.ReferenceDescriptor;

public class EntityPicker<T extends ResourceEntity>
extends Picker<T> {
    @Autowired
    private UICommands uiCommands;
    @Autowired
    private RepositoryFXContext repoCtx;
    @Autowired
    private RestClient client;
    private String format;
    private Control control;

    public EntityPicker(Class<T> type, String format) {
        super(type);
        this.format = format;
    }

    public Control createControl() {
        Assert.hasLength((String)this.format, (String)"You must set format for EntityPicker");
        String lookup = ReferenceDescriptor.of((String)this.format).getLookup();
        EFormDescriptor.EFormFieldDescriptor desc = new EFormDescriptor.EFormFieldDescriptor();
        desc.setFieldId(this.getName());
        desc.setLabel("");
        desc.setFormat(this.format);
        desc.setRequired(this.isRequired());
        switch (lookup) {
            case "browser": {
                ReferenceTextField tf = new ReferenceTextField(this.uiCommands, this.repoCtx, this.client, desc);
                tf.valueProperty().addListener((o, ov, nv) -> {
                    if (nv != null && !"".equals(nv)) {
                        this.valueProperty().set((Object)this.client.getSingle(nv, this.getType()));
                    }
                });
                this.control = tf;
                break;
            }
            case "simple": {
                ReferenceOptionField of = new ReferenceOptionField(desc, this.repoCtx, this.client);
                of.valueProperty().addListener((o, ov, nv) -> {
                    if (nv != null) {
                        this.valueProperty().set((Object)this.client.getSingle(nv.getValue(), this.getType()));
                    }
                });
                this.control = of;
                break;
            }
            default: {
                this.control = null;
            }
        }
        return this.control;
    }

    public EntityPicker<T> withFormat(String format) {
        this.format = format;
        return this;
    }

    public void requestfocus() {
        if (this.control != null) {
            this.control.requestFocus();
        }
    }
}

