/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.custom.picker;

import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.Control;

public abstract class Picker<E> {
    private ObjectProperty<E> value = new SimpleObjectProperty();
    private boolean required = true;
    private String name;
    private Class<E> type;

    protected Picker(Class<E> type) {
        this.type = type;
    }

    public final ObjectProperty<E> valueProperty() {
        return this.value;
    }

    public final E getValue() {
        return (E)this.valueProperty().get();
    }

    public final void setValue(E value) {
        this.valueProperty().set(value);
    }

    public <T extends Picker<E>> T onPicked(Consumer<E> value) {
        this.value.addListener((o, ov, nv) -> Platform.runLater(() -> value.accept(nv)));
        return (T)this;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class<E> getType() {
        return this.type;
    }

    public abstract Control createControl();
}

