/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.custom.screen;

import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import java.util.Map;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.fxml.LocaleContext;
import rs.tetrabyte.pezar.commands.ClearScreen;
import rs.tetrabyte.pezar.commands.DisplayContent;
import rs.tetrabyte.pezar.commands.LockUI;
import rs.tetrabyte.pezar.commands.PopContent;
import rs.tetrabyte.pezar.commands.RemoveView;
import rs.tetrabyte.pezar.commands.ShowAlert;
import rs.tetrabyte.pezar.commands.ShowDialog;
import rs.tetrabyte.pezar.commands.UnlockUI;
import rs.tetrabyte.pezar.context.AcceleratorService;
import rs.tetrabyte.pezar.context.FocusService;
import rs.tetrabyte.pezar.custom.LockablePane;
import rs.tetrabyte.pezar.custom.screen.SubScreen;
import rs.tetrabyte.pezar.factory.SubScreenFactory;

public class Screen
extends LockablePane {
    @Autowired
    private LocaleContext localeContext;
    private SubScreenFactory subScreenFactory;
    private Map<String, SubScreen> panes = new HashMap();

    public Screen(SubScreenFactory subScreenFactory, AcceleratorService acceleratorService, FocusService focusService) {
        super(acceleratorService, focusService);
        this.subScreenFactory = subScreenFactory;
    }

    @Subscribe
    private void removeView(RemoveView command) {
        SubScreen subScreen = null;
        for (Node node : this.getChildren()) {
            SubScreen temp = (SubScreen)node;
            if (temp.getCenter() != command.getView()) continue;
            subScreen = temp;
        }
        if (subScreen != null) {
            this.removeNode(subScreen);
        }
    }

    public void showDialog(ShowDialog<?> command) {
        DialogPane dp = command.getDialog().getDialogPane();
        SubScreen subScreen = this.subScreenFactory.createSubScreen((Node)dp, false, false);
        subScreen.getStyleClass().clear();
        subScreen.getStyleClass().add((Object)"glass-pane");
        this.toFront(subScreen, null);
        if (command.getOnOpened() != null) {
            command.getOnOpened().accept(command.getDialog());
        }
    }

    public void displayContent(DisplayContent command) {
        if (command.getTarget() == DisplayContent.TargetContainer.Screen) {
            this.displayContent(command.getContent(), command.isSingletonContent(), command.isClosable(), command.getCallback());
        }
    }

    @Subscribe
    void popContent(PopContent command) {
        this.popNode();
    }

    @Subscribe
    private void lock(LockUI lockui) {
        if (lockui.getMessage() != null) {
            String message = lockui.getMessage();
            if (message.startsWith("%")) {
                message = this.localeContext.getMessage(message.substring(1, message.length()), lockui.getMessageArgs());
            }
            this.setMessage(String.valueOf(message) + ". " + this.localeContext.getMessage("msg.please-wait", new Object[0]));
        }
        this.lock();
    }

    @Subscribe
    private void unlock(UnlockUI unlockui) {
        this.setMessage(this.localeContext.getMessage("msg.please-wait", new Object[0]));
        this.unlock();
    }

    @Subscribe
    private void clearScreen(ClearScreen command) {
        this.panes = new HashMap();
        this.getChildren().clear();
    }

    @Subscribe
    private void showAlert(ShowAlert command) {
        command.getAlert((StackPane)this, this.localeContext).showAndWait().ifPresent(buttonType -> {
            if (command.getOnConfirmed() != null && buttonType == ButtonType.OK) {
                command.getOnConfirmed().handle(null);
            }
        });
    }

    private void displayContent(Node content, boolean singleton, boolean closable, Callback<Void, Void> callback) {
        if (singleton) {
            if (this.panes.get(Integer.toHexString(content.hashCode())) == null) {
                this.panes.put(Integer.toHexString(content.hashCode()), this.subScreenFactory.createSubScreen(content, false, closable));
            }
            this.toFront((SubScreen)this.panes.get(Integer.toHexString(content.hashCode())), callback);
        } else {
            SubScreen pane = this.subScreenFactory.createSubScreen(content, true, closable);
            this.toFront(pane, callback);
        }
    }

    private void toFront(SubScreen pane, Callback<Void, Void> callback) {
        if (callback != null) {
            pane.setOnDeactivate((EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.addNodeOnTop((Node)pane);
    }
}

