/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.factory.field.search;

import java.util.Collection;
import java.util.stream.Collectors;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import jidefx.scene.control.editor.ComboBoxEditor;
import rs.tetrabyte.datamodel.uidescriptors.entity.ESearchDescriptor;
import rs.tetrabyte.pezar.controller.FormFieldController;
import rs.tetrabyte.pezar.factory.field.search.SearchFieldFactory;
import rs.tetrabyte.pezar.factory.field.util.ValueObject;

public class SearchComboBoxFactory
implements SearchFieldFactory {
    private ChangeListener<ValueObject> changeListener;

    public boolean supportsType(String type) {
        return type.equals("option");
    }

    public FormFieldController createControl(ESearchDescriptor.ESearchFieldDescriptor d) {
        ComboBoxEditor cb = new ComboBoxEditor();
        if (d.getValues() != null && d.getValues().size() > 0) {
            cb.getItems().addAll((Collection)d.getValues().stream().map(v -> new ValueObject(v.getValue(), v.getLabel())).collect(Collectors.toList()));
        }
        FormFieldController c = new FormFieldController((Control)cb);
        c.setBind(p -> this.bind((ComboBox)cb, p));
        c.setUnBind(p -> this.unBind(cb));
        return c;
    }

    private void bind(ComboBox<ValueObject> cb, StringProperty prop) {
        cb.getSelectionModel().select((Object)new ValueObject(prop.getValue().toString(), ""));
        this.changeListener = new /* Unavailable Anonymous Inner Class!! */;
        cb.valueProperty().addListener(this.changeListener);
    }

    private void unBind(ComboBoxEditor<ValueObject> cb) {
        cb.valueProperty().removeListener(this.changeListener);
    }
}

