/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.factory.field.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EntityDescriptor {
    public static final String DESCRIPTION_REGEX = "title:(.+?) text:(.+)";
    private final String title;
    private final String text;

    public EntityDescriptor(String title, String text) {
        this.title = title;
        this.text = text;
    }

    public String getTitle() {
        return this.title;
    }

    public String getText() {
        return this.text;
    }

    public String getInlineDescription() {
        return String.valueOf(this.title) + (this.text != null && !"".equals(this.text) ? ", " + this.text : "");
    }

    public static EntityDescriptor of(String description) {
        if (description.matches(DESCRIPTION_REGEX)) {
            Matcher m = Pattern.compile(DESCRIPTION_REGEX).matcher(description);
            if (!m.find()) {
                throw new IllegalArgumentException("Could not parse entity description from: " + description);
            }
            String title = m.group(1);
            String text = m.group(2);
            return new EntityDescriptor(title, text);
        }
        return new EntityDescriptor(description, "");
    }
}

