/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.factory.field.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReferenceDescriptor {
    private static final String FORMAT = "(\\w+)\\[(.+?)/(.+?)\\]";
    private final String lookup;
    private final String repository;
    private final String discriminator;

    private ReferenceDescriptor(String lookup, String repository, String discriminator) {
        this.lookup = lookup;
        this.repository = repository;
        this.discriminator = discriminator;
    }

    public String getLookup() {
        return this.lookup;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public String getRepoDiscriminated() {
        return String.valueOf(this.getRepository()) + "/" + this.getDiscriminator();
    }

    public static ReferenceDescriptor of(String format) {
        Matcher m = Pattern.compile(FORMAT).matcher(format);
        if (!m.find()) {
            throw new IllegalArgumentException("Bad reference format: " + format);
        }
        String lookup = m.group(1);
        String repo = m.group(2);
        String discriminator = m.group(3);
        return new ReferenceDescriptor(lookup, repo, discriminator);
    }

    public String toString() {
        return "ReferenceDescriptor [lookup=" + this.lookup + ", repository=" + this.repository + ", discriminator=" + this.discriminator + "]";
    }
}

