/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.fxml.factory;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.hateoas.Resources;
import rs.tetrabyte.fxml.LocaleContext;
import rs.tetrabyte.pezar.beans.Resident;
import rs.tetrabyte.pezar.context.TenantContext;
import rs.tetrabyte.pezar.context.data.Server;
import rs.tetrabyte.pezar.fxml.factory.resources.CombinedResourceBundle;

public class LocaleContextImpl
implements LocaleContext {
    private static Logger logger = LoggerFactory.getLogger(LocaleContextImpl.class);
    private ResourceBundle resources;
    private Locale locale = Locale.getDefault();
    private TenantContext tenantCtx;
    private String baseUri = "";
    private List<URL> moduleMessages;

    public LocaleContextImpl() {
        this.resources = ResourceBundle.getBundle("locale/messages", this.locale);
    }

    public ResourceBundle getResources() {
        if (this.tenantCtx != null && this.tenantCtx.getActiveServer().isPresent() && !this.baseUri.equals(((Server)this.tenantCtx.getActiveServer().get()).getUrl())) {
            this.baseUri = ((Server)this.tenantCtx.getActiveServer().get()).getUrl();
            this.loadResources();
        }
        return this.resources;
    }

    private void loadResources() {
        this.locale = new Locale(((Server)this.tenantCtx.getActiveServer().get()).getLocale());
        Locale.setDefault(this.locale);
        this.tenantCtx.getActiveResident().ifPresent(resident -> {
            if (resident.hasLink("locales")) {
                Resources locales = resident.getRelatedResources("locales", Resident.Resource.class);
                try {
                    URL url = new URL(String.valueOf(locales.getLink("messages").getHref()) + "/");
                    ArrayList<URL> urls = new ArrayList<URL>();
                    urls.add(url);
                    if (this.moduleMessages != null) {
                        urls.addAll(this.moduleMessages);
                    }
                    logger.debug("Loading resource bundle from {}", (Object)urls.stream().map(URL::toExternalForm).collect(Collectors.joining(", ")));
                    ArrayList<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
                    for (URL u : urls) {
                        bundles.add(ResourceBundle.getBundle("messages", this.locale, new URLClassLoader(new URL[]{u})));
                    }
                    CombinedResourceBundle bundle = new CombinedResourceBundle(bundles);
                    bundle.load();
                    this.resources = bundle;
                }
                catch (MalformedURLException e) {
                    logger.error("Error while loading messages", (Throwable)e);
                }
            }
        });
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getMessage(String key, Object ... args) {
        try {
            String message = this.getResources().getString(key);
            return MessageFormat.format(message, args);
        }
        catch (Exception e) {
            logger.error("Error while getting the message [ key = {}, error = {} ]", (Object)key, (Object)e.getMessage());
            return "";
        }
    }

    public void setTenantContext(TenantContext tenantCtx) {
        this.tenantCtx = tenantCtx;
    }

    public void setModuleMessageLocations(List<String> locations) {
        if (locations == null) {
            return;
        }
        this.moduleMessages = locations.stream().map(location -> {
            try {
                return new URL(location.endsWith("/") ? location : String.valueOf(location) + "/");
            }
            catch (MalformedURLException e) {
                logger.error("Message location error", (Throwable)e);
                return null;
            }
        }).filter(location -> location != null).collect(Collectors.toList());
        this.loadResources();
    }
}

