/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.fxml.factory;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.NodeOrientation;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.util.Builder;
import org.apache.commons.lang3.StringUtils;
import rs.tetrabyte.fxml.LocaleContext;
import rs.tetrabyte.pezar.custom.accelerable.PFXButton;
import rs.tetrabyte.pezar.custom.accelerable.PFXMenuItem;
import rs.tetrabyte.pezar.factory.GlyphFactory;
import rs.tetrabyte.pezar.factory.field.util.ControlUtil;
import rs.tetrabyte.pezar.fxml.factory.PFXButtonBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
public class PFXButtonBuilder
implements Builder<Object> {
    private Class<?> type;
    private String text;
    private String id;
    private LocaleContext localeContext;
    private String label;
    private String accelerator;
    private boolean mnemonicParsing = false;
    private boolean defaultButton = false;
    private boolean focusTraversable = true;
    private List<Object> items;
    private ContentDisplay contentDisplay = ContentDisplay.LEFT;
    private NodeOrientation nodeOrientation = NodeOrientation.LEFT_TO_RIGHT;

    public PFXButtonBuilder(Class<?> type, LocaleContext localeContext, String id) {
        this.localeContext = localeContext;
        this.id = id;
        this.type = type;
    }

    public PFXButtonBuilder(LocaleContext localeContext, String id) {
        this(null, localeContext, id);
    }

    public PFXButtonBuilder(Class<?> type, LocaleContext localeContext) {
        this(type, localeContext, null);
    }

    public synchronized Object build() {
        Object btn = null;
        if (this.id == null) {
            btn = null;
        } else if (this.id.startsWith("btn-")) {
            btn = this.buildButton();
        } else if (this.id.startsWith("mbtn-")) {
            btn = this.buildMenuButton();
        } else if (this.id.startsWith("mitm-")) {
            btn = this.buildMenuItem();
        }
        if (btn == null) {
            try {
                btn = this.type.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        return btn;
    }

    private Button buildButton() {
        PFXButton btn = new PFXButton();
        btn.setText(this.text);
        btn.setId(this.id);
        btn.setMnemonicParsing(this.mnemonicParsing);
        btn.setDefaultButton(this.defaultButton);
        btn.setFocusTraversable(this.focusTraversable);
        PFXButtonType.getButtonType((String)this.id.replaceFirst("btn-", "")).ifPresent(type -> {
            if (!StringUtils.isEmpty((CharSequence)type.getTextKey())) {
                this.parseText(this.localeContext.getResources().getString(type.getTextKey()));
            }
            btn.setButtonText(this.label);
            if (!StringUtils.isEmpty((CharSequence)this.accelerator)) {
                btn.setAcceleratorString(this.accelerator);
            }
            btn.setGlyph(type.getGlyph());
            btn.setText(null);
        });
        btn.setNodeOrientation(this.nodeOrientation);
        return btn;
    }

    private MenuItem buildMenuItem() {
        PFXMenuItem mitm = new PFXMenuItem();
        mitm.setText(this.text);
        mitm.setId(this.id);
        mitm.setMnemonicParsing(this.mnemonicParsing);
        PFXButtonType.getButtonType((String)this.id.replaceFirst("mitm-", "")).ifPresent(type -> {
            if (!StringUtils.isEmpty((CharSequence)type.getTextKey())) {
                this.parseText(this.localeContext.getResources().getString(type.getTextKey()));
            }
            mitm.setButtonText(this.label);
            if (!StringUtils.isEmpty((CharSequence)this.accelerator)) {
                mitm.setAcceleratorString(this.accelerator);
            }
            mitm.setGlyph(type.getGlyph());
            mitm.setText(null);
        });
        return mitm;
    }

    private MenuButton buildMenuButton() {
        MenuButton btn = new MenuButton();
        btn.getStyleClass().add((Object)"btn");
        btn.setText(this.text);
        btn.setId(this.id);
        btn.setMnemonicParsing(this.mnemonicParsing);
        btn.setFocusTraversable(this.focusTraversable);
        PFXButtonType.getButtonType((String)this.id.replaceFirst("mbtn-", "")).ifPresent(type -> {
            if (!StringUtils.isEmpty((CharSequence)type.getTextKey())) {
                this.parseText(this.localeContext.getResources().getString(type.getTextKey()));
            }
            btn.setText(this.label);
            btn.setGraphic(GlyphFactory.createGlyph((String)type.getGlyph()));
        });
        if (this.items != null) {
            this.items.stream().forEach(i -> {
                boolean bl = btn.getItems().add((Object)((MenuItem)i));
            });
        }
        btn.setNodeOrientation(this.nodeOrientation);
        return btn;
    }

    private void parseText(String text) {
        if (!StringUtils.isEmpty((CharSequence)text)) {
            String[] parsed = ControlUtil.parseAcceleratedLabel((String)text);
            this.label = parsed[0];
            if (parsed.length > 1) {
                this.accelerator = parsed[1];
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setMnemonicParsing(boolean mnemonicParsing) {
        this.mnemonicParsing = mnemonicParsing;
    }

    public boolean isMnemonicParsing() {
        return this.mnemonicParsing;
    }

    public boolean isDefaultButton() {
        return this.defaultButton;
    }

    public void setDefaultButton(boolean defaultButton) {
        this.defaultButton = defaultButton;
    }

    public boolean isFocusTraversable() {
        return this.focusTraversable;
    }

    public void setFocusTraversable(boolean focusTraversable) {
        this.focusTraversable = focusTraversable;
    }

    public Object getItems() {
        return this.items;
    }

    public void setItems(Object item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        this.items.add(item);
    }

    public ContentDisplay getContentDisplay() {
        return this.contentDisplay;
    }

    public void setContentDisplay(ContentDisplay contentDisplay) {
        this.contentDisplay = contentDisplay;
    }

    public void setNodeOrientation(NodeOrientation nodeOrientation) {
        this.nodeOrientation = nodeOrientation;
    }

    public NodeOrientation getNodeOrientation() {
        return this.nodeOrientation;
    }
}

