/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.fxml.factory.resources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class CombinedResourceBundle
extends ResourceBundle {
    private Map<String, String> combinedResources = new HashMap();
    private List<ResourceBundle> resources;

    public CombinedResourceBundle(List<ResourceBundle> resources) {
        this.resources = resources;
    }

    public void load() {
        this.resources.forEach(bundle -> {
            Enumeration<String> keysEnumeration = bundle.getKeys();
            ArrayList<String> keysList = Collections.list(keysEnumeration);
            keysList.forEach(key -> {
                String string = this.combinedResources.put(key, bundle.getString((String)key));
            });
        });
    }

    public Object handleGetObject(String key) {
        Object obj = this.combinedResources.get(key);
        if (obj == null) {
            if (this.parent != null) {
                obj = this.parent.getObject(key);
            }
            if (obj == null) {
                throw new MissingResourceException("Can't find resource for bundle " + this.getClass().getName() + ", key " + key, this.getClass().getName(), key);
            }
        }
        return obj;
    }

    @Override
    public Enumeration<String> getKeys() {
        return Collections.enumeration(this.combinedResources.keySet());
    }
}

